#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bump;
uniform sampler2D emissive;
uniform sampler2D detail;
uniform sampler2D detailbump;
uniform vec2 detailParams; // uv-scale, intensity

in vec2 pos_zw;
in vec3 normal;
in vec3 ec_pos;
in vec2 uv;

#include <deferred/gbuffer_write_include.frag>

#include <deferred/tangentspace_include.frag>

void main()
{
	vec3 tangent, binormal;
	per_fragment_tangent_space(ec_pos, uv, tangent, binormal);
	
	vec3 baseNormal = normalize(normal);
	vec3 b1 = texture(bump, uv).xyz*2.0 - vec3(1.0);
	vec3 b2 = texture(detailbump, uv).xyz*2.0 - vec3(1.0);
	vec3 b = mix(b1, b2, detailParams.y);
	mat3 mr = mat3(tangent, binormal, baseNormal);
	vec3 n = normalize(mr*b);

	vec3 deta = (texture(detail, uv*detailParams.x).rgb*2.0 - vec3(1.0)) * detailParams.y;
	diffuse_specular.rgb = texture(diffuse, uv).rgb + deta;
	diffuse_specular.a = texture(specular, uv).r + deta.x;

	normal_depth.xyz = n;//mix(baseNormal, n, 0.125);
	//normal_depth.w = pos_zw.x/pos_zw.y;
	normal_depth.w = texture(emissive, uv).r; // use this for emissive light
}
