#version 430 core

uniform float time;

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec3 normal;
out vec3 wpos;
out vec2 uv;

void main()
{
	vec3 pos = POSITION;
	float s = smoothstep(0.0, 1.0, (TEXCOORD.y - 32.0)/4.0);
	pos += NORMAL * sin((time - TEXCOORD.y)*s*0.9)*0.05;
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	wpos = vec3(ModelViewMatrix * vec4(pos, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(pos, 1.0);
}
