#version 430 core

uniform sampler2D normal_depth;
uniform float viewport[2];
uniform float time;

in vec3 normal;
in vec3 wpos;
in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * vec2(viewport[0], viewport[1]);
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( uv.y > time || pos.z > wpos.z ) discard;

	float alpha = clamp((wpos.z - pos.z)*5.0, 0.0, 1.0);
	alpha *= 1.0 - smoothstep(0.0, 0.5, uv.x-0.5);
	frag_color.rgb = vec3(alpha);
	frag_color.a = 0.0;
}
