#version 430 core

uniform float time;
uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
//uniform mat4 ProjectionMatrix;
uniform vec2 extents;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL; // direction
layout (location = 2) in vec3 COLOR; // time offset, speed
layout (location = 3) in vec3 TANGENT; // radius, start, stop

out vec3 wpos;
out float fade;
out float angle;

void main()
{
	float seg = TANGENT.z - TANGENT.y;
	float t = mod((time - TANGENT.y)*COLOR.y + COLOR.x, seg);
	vec4 pos = vec4(POSITION + NORMAL*t, 1.0);
	pos.xz += sin(pos.xz + pos.yy*0.25)*0.2;

	wpos = vec3(ModelViewMatrix * pos);
	fade = smoothstep(0.0, 1.0, t);
	angle = t;
	float size = 1.0 - (length(wpos) / 128.f);
	gl_PointSize = TANGENT.x * size;
	gl_Position = ModelViewProjectionMatrix * pos;
}
