#version 430 core

uniform sampler2D particle;
uniform sampler2D depth;
uniform float viewport[2];

in vec3 wpos;
in float fade;
in float angle;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

vec2 rotate(in vec2 uv, float ang)
{
	vec2 p = uv - vec2(0.5);
	float s = sin(ang);
	float c = cos(ang);
	return vec2(p.x*c + p.y*s + 0.5, -p.x*s + p.y*c + 0.5);
}


void main()
{
	vec2 uv_pos = gl_FragCoord.xy * vec2(viewport[0], viewport[1]);
	float d = (texture(depth, uv_pos).x - 0.5) * 2.0;
	vec3 pos = calc_position(uv_pos, d);

	//if ( pos.z > wpos.z ) discard;

	vec4 part = texture(particle, rotate(gl_PointCoord.xy, angle));
	float alpha = clamp((wpos.z - pos.z)/8.0, 0.0, 1.0);

	frag_color = part * alpha * fade;
	frag_color.a = part.a;
}
