#version 430 core

uniform float time;
uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
//uniform mat4 ProjectionMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL; // direction
layout (location = 2) in vec3 COLOR; // force
layout (location = 3) in vec3 TANGENT; // radius, start, stop

out vec3 wpos;
out float fade;

void main()
{
	float s = step(TANGENT.y, time) - step(TANGENT.z, time);
	float t = s * (time - TANGENT.y) / (TANGENT.z - TANGENT.y);
	vec4 pos = vec4(POSITION + NORMAL*pow(t, 2.0), 1.0);

	wpos = vec3(ModelViewMatrix * pos);
	fade = smoothstep(0.0, 0.1, t) - smoothstep(0.5, 1.0, t);

	float size = 1.0 - (length(wpos) / 128.f);
	gl_PointSize = TANGENT.x * size * s;
	gl_Position = ModelViewProjectionMatrix * pos;
}
