#version 330 core

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;   // cone_angle, cone_cutoff_angle, radius
layout (location = 2) in vec3 COLOR;    // rgb*intensity
layout (location = 4) in vec3 TEXCOORD; // spot direction

out vec3 gs_spot_dir;
out vec3 gs_spot_params; // cone_angle, cone_cutoff_angle, radius
out vec3 gs_spot_color;  // rgb*intensity

void main()
{
	gs_spot_dir = normalize(TEXCOORD);
	gs_spot_params = NORMAL;
	gs_spot_color = COLOR;
	gl_Position = vec4(POSITION, 1.0);
}
