#version 330 core

uniform sampler2D particle;
uniform sampler2D normal_depth;
uniform sampler2D depth;
uniform vec2 viewport;

in vec2 uv;
in vec3 wpos;
in vec4 color;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	//float d = texture(normal_depth, uv_pos).w;
	float d = (texture(depth, uv).x - 0.5)*2.0;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float alpha = clamp(wpos.z - pos.z, 0.0, 1.0);

	frag_color = texture(particle, uv) * color * alpha;
	frag_color.a = 0.0;
}
