#version 330 core

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec3 color;

layout (location = 0) out vec4 frag_color;


void main()
{
	vec2 uv = gl_FragCoord.xy * viewport;
	vec4 ds = texture(diffuse_specular, uv);
	float emissive = texture(normal_depth, uv).w;

	vec3 lit = ds.rgb*color + ds.rgb*emissive;
	frag_color = vec4(lit, 0.0);
}
