uniform vec4 Diffuse;
uniform vec4 Ambient;
uniform vec4 Specular;
uniform vec4 LightColor;
uniform float SpecularPower;
uniform float LightIntensity;
uniform float Time;
uniform float Sync;

uniform sampler2D diffuseMap;
uniform sampler2D bumpMap;
varying vec2 Texcoord;

varying vec3 LightDirection;
varying vec3 ViewDirection;
varying vec3 Normal;


void main(void)
{
   if (!gl_FrontFacing)
   {
		Normal = Normal * -1;
   }
   vec3 nLightDirection = normalize(LightDirection);
   vec3 nNormal = normalize( (texture2D(bumpMap, Texcoord).xyz * 2.0) - 1.0);
      
   float NDotL = dot( nNormal, nLightDirection );
   
   vec3 Reflection = normalize(((2.0 * nNormal) * NDotL) - nLightDirection);
   vec3 nViewDirection = normalize(ViewDirection);
   float RDotV = max(0.0, dot(Reflection, nViewDirection));
   
   vec4 diffuseColor = texture2D(diffuseMap, Texcoord);
   vec4 DiffuseColor = diffuseColor * Diffuse * NDotL * LightIntensity * LightColor;
   vec4 AmbientColor = Ambient * diffuseColor;
   vec4 SpecularColor = Specular * pow(RDotV, SpecularPower);
   
   gl_FragColor = DiffuseColor + AmbientColor + SpecularColor;
}