uniform vec3 fvLightPosition;
uniform vec3 fvEyePosition;
uniform float Time;
uniform vec2 Distort;
uniform vec2 DistortSpeed;


varying vec2 Texcoord;

varying vec3 Normal;
varying vec3 LightDirection;
varying vec3 ViewDirection;

//attribute vec3 rm_Binormal;
//attribute vec3 rm_Tangent;

void main(void)
{
   gl_Vertex.y = gl_Vertex.y + sin(Time * DistortSpeed.x + gl_Vertex.x)*Distort.x;
   gl_Vertex.x = gl_Vertex.x + sin(Time * DistortSpeed.y + gl_Vertex.y)*Distort.y;
   gl_Position = ftransform();
   
   Texcoord = gl_MultiTexCoord0.xy;
   vec3 tangent;
   vec3 binormal;
   
vec3 c1 = cross( gl_Normal, vec3(0.0, 0.0, 1.0) ); 
vec3 c2 = cross( gl_Normal, vec3(0.0, 1.0, 0.0) ); 

if( length(c1)>length(c2) )
{
	tangent = c1;	
}
else
{
	tangent = c2;	
}

tangent = normalize(tangent);

binormal = cross(gl_Normal, tangent); 
binormal = normalize(binormal);   
       
   vec4 objectPosition = gl_ModelViewMatrix * gl_Vertex;
 
   vec3 nNormal = gl_NormalMatrix * gl_Normal;
   vec3 nBinormal = gl_NormalMatrix * binormal;
   vec3 nTangent = gl_NormalMatrix * tangent;
   
   vec3 nLightDirection = (gl_ModelViewMatrix * vec4(fvLightPosition, 1)).xyz - objectPosition.xyz;
   //vec3 nLightDirection = fvLightPosition - objectPosition.xyz;
   vec3 nViewDirection = fvEyePosition - objectPosition.xyz;
   
   ViewDirection.x = dot(nTangent, nViewDirection);
   ViewDirection.y = dot(nBinormal, nViewDirection);   
   ViewDirection.z = dot(nNormal, nViewDirection);   
   
   LightDirection.x = dot(nTangent, nLightDirection);
   LightDirection.y = dot(nBinormal, nLightDirection);   
   LightDirection.z = dot(nNormal, nLightDirection);    
   
   
   Normal = gl_NormalMatrix * gl_Normal;
}