class Players:
    players = {}
    own_name = ""

    def __init__(self, player_list = None, own_name = None):
        self.own_name = own_name
        if (player_list == None):
            return
        print "Creating player list from scratch..."
        self.update(player_list)            
        for player in player_list:
            self.players[player['name']]['resources'] = {}
            self.players[player['name']]['resources']['R'] = 0
            self.players[player['name']]['resources']['C'] = 0
            self.players[player['name']]['resources']['E'] = 0        

    def update(self, player_list):
        for player in player_list:
            if (not player['name'] in self.players):
                self.players[player['name']] = self.sanitize_player(player)
            else:
                self.update_player(player)


    def update_player(self, player):
        newinfo = self.sanitize_player(player)
        self.players[player['name']]['position'] = newinfo['position']
        self.players[player['name']]['weapons'] = newinfo['weapons']
        self.players[player['name']]['health'] = newinfo['health']
        self.players[player['name']]['score'] = newinfo['score']        
        #print "Updated player information: {0}".format(self.players)

    def increment_resource(self, player_name, resource, value=1):
        self.players[player_name]['resources'][resource] += value

    def decrement_resource(self, player_name, resource, value=1):
        self.players[player_name]['resources'][resource] -= value

    def resources_needed_to_level(self, player_name, weapon):
        res = 0
        if weapon == 'laser':
            res = self.players[player_name]['resources']['R']
        elif weapon == 'droid':
            res = self.players[player_name]['resources']['C']
        elif weapon == 'mortar': 
            res = self.players[player_name]['resources']['E']
        level = self.players[player_name]['weapons'][weapon]
        if 1 == level:
            return 4 - res
        elif 2 == level:
            return 5 - res
        else:
            return 0

    def upgradable_weapons(self, player_name):
        weapons = []
        for weapon in self.players[player_name]['weapons']:
            level = self.players[player_name]['weapons'][weapon]
            if 1 == level or 2 == level:
                if (0 >= self.resources_needed_to_level(player_name, weapon)):
                    weapons.append(weapon)
        return weapons

    def sanitize_player(self, player):
        if ("position" in player):
            player['position'] = self.parse_position(player)
        else:
            player['position'] = None
            
        player['weapons'] = {'laser':0, 'mortar':0, 'droid':0}
        if('primary-weapon' in player and 'secondary-weapon' in player):
            for weapon in (player['primary-weapon'], player['secondary-weapon']):
                player['weapons'][weapon['name']] = weapon['level']

        return player

    def parse_position(self, player):
        if (player == None):
            return None
        
        pos_j, pos_k = player['position'].split(",")
        return [int(pos_j), int(pos_k)]

    def me(self):
        for name, player in self.players.iteritems():
            if (name == self.own_name):
                return player

        return None

    def enemies(self):
        return [player for name, player in self.players.iteritems() if name != self.own_name]
    
    def allplayers(self):
        return [player for name, player in self.players.iteritems()]

    def playerPositions(self):
        return [player['position'] for name, player in self.players.iteritems()]

    def playerPositionsWithoutMe(self):
        return [player['position'] for name, player in self.players.iteritems() if name != self.own_name]
