from astar import AStar, AStarNode
from math import sqrt
 
class AStarHexGrid(AStar):
    def heuristic(self, node, start, end):
    	# Estimate best possible distance between two grid locations (Pythagoras should work for hex grid as well)
        return sqrt((end.j - node.j)**2 + (end.k - node.k)**2)
 
class AStarHexGridNode(AStarNode):
    def __init__(self, j, k):
        self.j, self.k = j, k
        super(AStarHexGridNode, self).__init__()
 
    def move_cost(self, other):
    	# Return 1 as cost for all moves (since all grid moves have the same cost)
    	return 1
        #diagonal = abs(self.x - other.x) == 1 and abs(self.y - other.y) == 1
        #return 14 if diagonal else 10

    def __repr__(self):
        return "{0}x{1}".format(self.j, self.k)

    def __str__(self):
        return "{0}x{1}".format(self.j, self.k)