package skyport.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import skyport.Coordinate;
import skyport.constants.ProtocolConstants;
import skyport.enums.Direction;
import skyport.enums.WeaponType;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonMessage {

	private ObjectMapper mapper;
	private JsonFactory jsonFactory;

	public JsonMessage() {
		mapper = new ObjectMapper();
		jsonFactory = mapper.getFactory();
	}

	public Map<String, Object> getMap(String jsonString)
			throws JsonParseException, IOException {

		Map<String, Object> map = new HashMap<String, Object>();
		JsonParser parser = jsonFactory.createParser(jsonString);
		parser.nextToken(); // "{"

		while (parser.nextToken() != JsonToken.END_OBJECT) {
			String fieldName = parser.getCurrentName();
			parser.nextToken();

			if (fieldName != null) {
				switch (fieldName) {
				case "status":
					map.put(fieldName, parser.getBooleanValue());
					break;
				case "turn":
					map.put(fieldName, parser.getIntValue());
					break;
				case "players":
					List<PlayerBean> players = new ArrayList<PlayerBean>();

					while (parser.nextToken() != JsonToken.END_ARRAY) {
						players.add(parser.readValueAs(PlayerBean.class));
					}

					map.put(fieldName, players);
					break;
				case "map":
					map.put(fieldName, parser.readValueAs(MapBean.class));
					break;
				case "sequence":
					List<String> directions = new ArrayList<String>();
					
					while (parser.nextToken() != JsonToken.END_ARRAY) {
						directions.add(parser.getText());
					}
					
					map.put(fieldName, directions);
					break;
				default:
					map.put(fieldName, parser.getText());
					break;
				}
			}
		}

		parser.close();

		return map;
	}

	public String handshake(String aiName) throws JsonProcessingException {
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "connect");
		data.put("revision", ProtocolConstants.REVISION);
		data.put("name", aiName);

		return mapper.writeValueAsString(data);
	}

	public String loadout() throws JsonProcessingException {
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "loadout");
		data.put("primary-weapon", "droid");
		data.put("secondary-weapon", "mortar");

		return mapper.writeValueAsString(data);
	}

	public String move(Direction dir) throws JsonProcessingException {
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "action");
		data.put("type", "move");
		data.put("direction", dir.toString());

		return mapper.writeValueAsString(data);
	}

	public String mine() throws JsonProcessingException {
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "action");
		data.put("type", "mine");

		return mapper.writeValueAsString(data);
	}

	public String passTurn() throws JsonProcessingException {
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "action");
		data.put("type", "pass");

		return mapper.writeValueAsString(data);
	}

	public String laserAttack(Direction dir) throws JsonProcessingException {
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "action");
		data.put("type", "laser");
		data.put("direction", dir.toString());

		return mapper.writeValueAsString(data);
	}

	public String mortarAttack(Coordinate relativePosition)
			throws JsonProcessingException {

		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "action");
		data.put("type", "mortar");
		data.put("coordinates", relativePosition.getString());

		return mapper.writeValueAsString(data);
	}

	public String droidAttack(List<Direction> sequence)
			throws JsonProcessingException {

		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "action");
		data.put("type", "droid");

		String[] stringSequence = new String[sequence.size()];
		Iterator<Direction> it = sequence.iterator();
		
		for (int i = 0; i < stringSequence.length; ++i) {
			stringSequence[i] = it.next().toString();
		}

		data.put("sequence", stringSequence);

		return mapper.writeValueAsString(data);
	}

	public String upgrade(WeaponType weapon) throws JsonProcessingException {
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("message", "action");
		data.put("type", "upgrade");
		data.put("weapon", weapon.toString());

		return mapper.writeValueAsString(data);
	}
}
