package skyport.enums;

import java.util.HashMap;
import java.util.Map;

public class WeaponTypeFactory {

	private static final WeaponTypeFactory instance = new WeaponTypeFactory();

	private Map<String, WeaponType> map;

	private WeaponTypeFactory() {
		map = new HashMap<String, WeaponType>();

		for (WeaponType weapon : WeaponType.values()) {
			map.put(weapon.toString(), weapon);
		}
	}

	public WeaponType getByString(final String string) {
		return map.get(string);
	}

	public static WeaponTypeFactory getInstance() {
		return instance;
	}
}
