package skyport.enums;

import java.util.HashMap;
import java.util.Map;

public class DirectionFactory {

	private static final DirectionFactory instance = new DirectionFactory();

	private Map<String, Direction> map;

	private DirectionFactory() {
		map = new HashMap<String, Direction>();

		for (Direction direction : Direction.values()) {
			map.put(direction.toString(), direction);
		}
	}

	public Direction getByString(final String string) {
		return map.get(string);
	}

	public static DirectionFactory getInstance() {
		return instance;
	}
}
