package skyport.connection;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class TcpClient {

	private BufferedReader in;
	private PrintWriter out;
	private Socket socket;

	public TcpClient(final Socket socket) throws IOException {
		this.socket = socket;
		InputStream is = socket.getInputStream();
		in = new BufferedReader(new InputStreamReader(is));
		out = new PrintWriter(socket.getOutputStream(), true);
	}

	public String getAddressAndPort() {
		String ip = socket.getInetAddress().getHostAddress();
		return ip + ":" + socket.getPort();
	}

	public void send(final String message) {
		out.println(message);
	}

	public String receive() throws IOException {
		return in.readLine();
	}

	public void close() throws IOException {
		out.close();
		in.close();
		socket.close();
	}
}
