package skyport.ais;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;

import skyport.Coordinate;
import skyport.SkyportException;
import skyport.enums.Direction;
import skyport.enums.Tile;
import skyport.json.PlayerBean;

public class IdleAi extends Ai implements Runnable {

	private static final int NUMBER_OF_AI = 2;
	private static final String NAME = "idleAI";
	private static int index = 0;

	public IdleAi() {
		super(getAiName());
	}

	@Override
	public void run() {
		try {
			start();
		} catch (IOException | SkyportException e) {
			System.out.println(e.getMessage());
		}
	}

	@Override
	protected void processTurn() throws JsonProcessingException {
		PlayerBean currentPlayer = game.getCurrentPlayer();

		if (aiName.equals(currentPlayer.getName())) {
			Coordinate pos = currentPlayer.getPosition();
			Tile tile = game.getTilemap().getTileAt(pos);

			if (tile != null && tile == Tile.SPAWN) {
				Direction dir = getSafeDirectionFrom(pos);

				if (dir != null) {
					client.send(message.move(dir));
				}
			}
		}
	}

	private static synchronized String getAiName() {
		String ainame = NAME + index;
		++index;

		return ainame;
	}

	public static void main(final String[] args) {
		for (int i = 0; i < NUMBER_OF_AI; ++i) {
			(new Thread(new IdleAi())).start();
		}
	}
}
