/*
 * Decompiled with CFR 0.152.
 */
package skyport.enums;

import java.util.HashMap;
import java.util.Map;
import skyport.enums.Tile;

public class TileFactory {
    private static final TileFactory instance = new TileFactory();
    private Map<Character, Tile> map = new HashMap<Character, Tile>();

    private TileFactory() {
        Tile[] tileArray = Tile.values();
        int n = tileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tile tile = tileArray[n2];
            this.map.put(Character.valueOf(tile.toChar()), tile);
            ++n2;
        }
    }

    public Tile getByChar(char c) {
        return this.map.get(Character.valueOf(c));
    }

    public Tile[][] convertTo2DTileArray(char[][] data) {
        Tile[][] tiles = new Tile[data.length][data[0].length];
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                tiles[i][j] = this.getByChar(data[i][j]);
                ++j;
            }
            ++i;
        }
        return tiles;
    }

    public static TileFactory getInstance() {
        return instance;
    }
}

