/*
 * Decompiled with CFR 0.152.
 */
package skyport.enums;

public enum Tile {
    GRASS('G'),
    VOID('V'),
    SPAWN('S'),
    EXPLODIUM('E'),
    RUBIDIUM('R'),
    SCRAP('C'),
    ROCK('O');

    private final char type;

    private Tile(char type) {
        this.type = type;
    }

    public char toChar() {
        return this.type;
    }

    public boolean isTraversable() {
        switch (this) {
            case VOID: 
            case SPAWN: 
            case ROCK: {
                return false;
            }
        }
        return true;
    }

    public boolean isMineable() {
        switch (this) {
            case EXPLODIUM: 
            case RUBIDIUM: 
            case SCRAP: {
                return true;
            }
        }
        return false;
    }

    public boolean blocksLaser() {
        return this == ROCK;
    }

    public boolean absorbsExplosiveDamage() {
        switch (this) {
            case VOID: 
            case ROCK: {
                return true;
            }
        }
        return false;
    }
}

