/*
 * Decompiled with CFR 0.152.
 */
package skyport.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class TcpClient {
    private BufferedReader in;
    private PrintWriter out;
    private Socket socket;

    public TcpClient(Socket socket) throws IOException {
        this.socket = socket;
        InputStream is = socket.getInputStream();
        this.in = new BufferedReader(new InputStreamReader(is));
        this.out = new PrintWriter(socket.getOutputStream(), true);
    }

    public String getAddressAndPort() {
        String ip = this.socket.getInetAddress().getHostAddress();
        return String.valueOf(ip) + ":" + this.socket.getPort();
    }

    public void send(String message) {
        this.out.println(message);
    }

    public String receive() throws IOException {
        return this.in.readLine();
    }

    public void close() throws IOException {
        this.out.close();
        this.in.close();
        this.socket.close();
    }
}

