/*
 * Decompiled with CFR 0.152.
 */
package skyport;

import skyport.Coordinate;
import skyport.enums.Tile;
import skyport.enums.TileFactory;
import skyport.json.MapBean;

public class Tilemap {
    private MapBean mapData = null;
    private Tile[][] tiles = null;

    public void setMapData(MapBean mapData) {
        this.mapData = mapData;
        this.tiles = TileFactory.getInstance().convertTo2DTileArray(mapData.getData());
    }

    public Tile[][] getTiles() {
        return this.tiles;
    }

    public int getJLength() {
        return this.mapData.getJlength();
    }

    public int getKLength() {
        return this.mapData.getKlength();
    }

    public Tile getTileAt(Coordinate coordinate) {
        if (this.legalCoordinate(coordinate)) {
            return this.tiles[coordinate.getX()][coordinate.getY()];
        }
        return null;
    }

    public boolean legalCoordinate(Coordinate coordinate) {
        int x = coordinate.getX();
        int y = coordinate.getY();
        return x >= 0 && y >= 0 && x < this.mapData.getJlength() && y < this.mapData.getKlength();
    }
}

