/*
 * Decompiled with CFR 0.152.
 */
package skyport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import skyport.Coordinate;
import skyport.PlayerResources;
import skyport.enums.Tile;
import skyport.json.PlayerBean;

public class Resources {
    private int[][] resourceCount;
    private Map<String, PlayerResources> playerResources = new HashMap<String, PlayerResources>();

    public Resources(Tile[][] tileMap, List<PlayerBean> players) {
        for (PlayerBean player : players) {
            String playerName = player.getName();
            this.playerResources.put(playerName, new PlayerResources());
        }
        int jlength = tileMap.length;
        int klength = tileMap[0].length;
        this.resourceCount = new int[jlength][klength];
        int i = 0;
        while (i < jlength) {
            int j = 0;
            while (j < klength) {
                if (tileMap[i][j].isMineable()) {
                    this.resourceCount[i][j] = 2;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getResourceCountAt(Coordinate coord) {
        return this.resourceCount[coord.getX()][coord.getY()];
    }

    public void decrementResourceCountAt(Coordinate coord) {
        int[] nArray = this.resourceCount[coord.getX()];
        int n = coord.getY();
        nArray[n] = nArray[n] - 1;
    }

    public PlayerResources getPlayerResources(String playerName) {
        return this.playerResources.get(playerName);
    }
}

