/*
 * Decompiled with CFR 0.152.
 */
package skyport;

import java.util.Iterator;
import java.util.List;
import skyport.Coordinate;
import skyport.Resources;
import skyport.Tilemap;
import skyport.algorithms.astar.Node;
import skyport.algorithms.astar.Nodemap;
import skyport.enums.Tile;
import skyport.json.MapBean;
import skyport.json.PlayerBean;

public class Game {
    private int turn = 0;
    private List<PlayerBean> players = null;
    private Resources resources = null;
    private Tilemap tilemap = new Tilemap();
    private Nodemap nodemap = null;

    public int getTurn() {
        return this.turn;
    }

    public void setTurn(int turn) {
        this.turn = turn;
    }

    public List<PlayerBean> getPlayers() {
        return this.players;
    }

    public void setPlayers(List<PlayerBean> players) {
        this.players = players;
    }

    public Tilemap getTilemap() {
        return this.tilemap;
    }

    public void setTilemap(Tilemap map) {
        this.tilemap = map;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Nodemap getNodemap() {
        return this.nodemap;
    }

    public void updateMap(MapBean mapBean) {
        this.tilemap.setMapData(mapBean);
    }

    public void initialize(MapBean mapBean, List<PlayerBean> players) {
        this.tilemap.setMapData(mapBean);
        Tile[][] tiles = this.tilemap.getTiles();
        this.nodemap = new Nodemap(this.tilemap);
        this.resources = new Resources(tiles, players);
    }

    public PlayerBean getCurrentPlayer() {
        return this.players.get(0);
    }

    public PlayerBean getPlayerByName(String playerName) {
        PlayerBean player = null;
        for (PlayerBean currentPlayer : this.players) {
            if (!currentPlayer.getName().equals(playerName)) continue;
            player = currentPlayer;
            break;
        }
        return player;
    }

    public boolean opponentAt(Coordinate pos) {
        boolean opponentAt = false;
        Iterator<PlayerBean> it = this.players.iterator();
        it.next();
        while (it.hasNext() && !opponentAt) {
            PlayerBean player = it.next();
            opponentAt = pos.equals(player.getPosition());
        }
        return opponentAt;
    }

    public Coordinate getCoordinateForPlayer(int index) {
        return this.players.get(index).getPosition();
    }

    public PlayerBean getClosestPlayerFrom(Coordinate from) {
        PlayerBean closestPlayer = null;
        int distance = Integer.MAX_VALUE;
        int lowestHp = Integer.MAX_VALUE;
        Iterator<PlayerBean> it = this.players.iterator();
        it.next();
        while (it.hasNext()) {
            PlayerBean player = it.next();
            Coordinate to = player.getPosition();
            List<Node> nodes = this.nodemap.getRoute(from, to);
            if (nodes == null) continue;
            int steps = nodes.size();
            int hp = player.getHealth();
            if (steps >= distance && (steps != distance || hp >= lowestHp)) continue;
            closestPlayer = player;
            distance = steps;
            lowestHp = hp;
        }
        return closestPlayer;
    }

    public Coordinate getCoordinateToClosestTileFrom(Coordinate from, Tile tile) {
        Coordinate result = null;
        boolean score = false;
        int x = from.getX();
        int y = from.getY();
        int maxRange = Math.max(this.tilemap.getJLength(), this.tilemap.getKLength());
        int range = 0;
        while (range < maxRange) {
            int x1 = x - range;
            int x2 = x + range;
            int currentX = x1;
            while (currentX <= x2 && !score) {
                int diffX = x - currentX;
                int y1 = y - range - (diffX > 0 ? 0 : diffX);
                int y2 = y + range - (diffX < 0 ? 0 : diffX);
                int currentY = y1;
                while (currentY <= y2 && !score) {
                    Coordinate pos = new Coordinate(currentX, currentY);
                    if (this.tilemap.getTileAt(pos) == tile) {
                        result = pos;
                        score = true;
                    }
                    ++currentY;
                }
                ++currentX;
            }
            ++range;
        }
        return result;
    }
}

