"""
AwesomeBot av Marky
AI Programming TG13 - Python 2.7
"""

import sys,socket,random
from math import *
sys.path.append("../api/python/")
import skyport

assert(len(sys.argv) == 2)

botname = sys.argv[1]
weapon1 = "mortar"
weapon1Level = 1
weapon2 = "laser"
weapon2Level = 1
robidium = 0
explosium = 0
scrapmetal = 0
mepos = (0,0)

#Operasjoner for aa sende data og skrive ut feilmeldinger ------------------------------------------
def sendData(data):
    if sock.sendall(data+"\n") != None:
        error("Could not send data")

def handshake():
    fancyprint("Got handshake!")

def error(text):
    print "ERROR: " + text

def fancyprint(text):
    print "//AwesomeBot\\-> " + text

#Operasjoner for "spillet" -------------------------------------------------------------------------
def gamestart(turn,map_obj,players):
    sender.send_loadout(weapon1,weapon2)

def gamestate(turn,map,players):
    global robidium
    global explosium
    global scrapmetal
    global weapon1Level
    global weapon2Level
    global mepos
    if players[0]["name"] == botname:
        count = 0
        mined = 0
        weaponUpgradable = (weapon1Level < 3 or weapon2Level < 3)
        mepos = selfPos(players)
        while count < 3:
            enemyClose = closestEnemyPos(players)
            miningClose = closestMiningPos(map)
            
            if distance(mepos,enemyClose) > distance(mepos,miningClose) and not (inWeaponsRange(mepos,enemyClose,weapon1,weapon1Level) or inWeaponsRange(mepos,enemyClose,weapon2,weapon2Level)) and not isMineableArea(map,mepos[0],mepos[1]):
                moveDir = getDirection(miningClose[0],miningClose[1],players)
                moveTo = getLocation(mepos[0],mepos[1],moveDir)
                fancyprint("Moving closer to minerals...")
                if isRockOrVoid(map,moveTo[0],moveTo[1]):
                    moveDir = findMoveableSpot(mepos,miningClose,players,map)
                mepos = getLocation(mepos[0],mepos[1],moveDir)
                sender.send_move(moveDir)
            else:
                if inWeaponsRange(mepos,enemyClose,weapon1,weapon1Level) and not isRockOrVoid(map,enemyClose[0],enemyClose[1]):
                    attackFunc(weapon1,enemyClose,players)
                    break
                elif inWeaponsRange(mepos,enemyClose,weapon2,weapon2Level) and not isRockOrVoid(map,enemyClose[0],enemyClose[1]):
                    attackFunc(weapon2,enemyClose,players)
                    break
                else:
                    if isMineableArea(map,mepos[0],mepos[1]) and mined < 2:
                        fancyprint("Mining here @ " + str(mepos[0]) + "," + str(mepos[1]))
                        if map["data"][mepos[0]][mepos[1]] == "R":
                            robidium += 1
                        elif map["data"][mepos[0]][mepos[1]] == "E":
                            explosium += 1
                        elif map["data"][mepos[0]][mepos[1]] == "C":
                            scrapmetal += 1
                        mined += 1
                        sender.mine()
                    elif robidium >= 4 + (weapon1Level-1 if weapon1=="laser" else (weapon2Level-1 if weapon2 =="laser" else 0)) and (weapon1 == "laser" or weapon2 == "laser") and weaponUpgradable:
                        fancyprint("Upgrading laser...")
                        sender.upgrade("laser")
                        robidium -= 4 + (weapon1Level-1 if weapon1=="laser" else (weapon2Level-1 if weapon2 =="laser" else 0))
                        if weapon1 == "laser":
                            weapon1Level+=1
                        else:
                            weapon2Level+=1
                    elif explosium >= 4 + (weapon1Level-1 if weapon1=="mortar" else (weapon2Level-1 if weapon2 =="mortar" else 0)) and (weapon1 == "mortar" or weapon2 == "mortar") and weaponUpgradable:
                        fancyprint("Upgrading mortar...")
                        sender.upgrade("mortar")
                        explosium -= 4 + (weapon1Level-1 if weapon1=="mortar" else (weapon2Level-1 if weapon2 =="mortar" else 0))
                        if weapon1 == "mortar":
                            weapon1Level+=1
                        else:
                            weapon2Level+=1
                    elif scrapmetal >= 4 + (weapon1Level-1 if weapon1=="droid" else (weapon2Level-1 if weapon2 =="droid" else 0)) and (weapon1 == "droid" or weapon2 == "droid") and weaponUpgradable:
                        fancypring("Upgrading droid...")
                        sender.upgrade("droid")
                        scrapmetal -= 4 + (1 if weapon1Level > 1 or weapon2Level > 1 else 0)
                        if weapon1 == "droid":
                            weapon1Level+=1
                        else:
                            weapon2Level+=1
                    else:
                        moveDir = getDirection(enemyClose[0],enemyClose[1],players)
                        moveTo = getLocation(mepos[0],mepos[1],moveDir)
                        if isRockOrVoid(map,moveTo[0],moveTo[1]):
                            fancyprint("Somethings in my way! Recaulculating position...")
                            moveDir = findMoveableSpot(mepos,enemyClose,players,map)
                        fancyprint("moving " + moveDir)
                        mepos = getLocation(mepos[0],mepos[1],moveDir)
                        sender.send_move(moveDir)
                            
            count += 1
            
def action(action_type,who,other_data):
    fancyprint(str(who) + " did " + str(action))

def endturn():
    fancyprint("Endturn baby!")

#Hjelpemetoder -------------------------------------------------------------------------------------
def attackFunc(weaponType,enemy,players):
    global mepos
    if weaponType == "laser":
        fancyprint("Imma firing mah lazar!")
        fireDir = getDirection(enemy[0],enemy[1],players)
        fireLoc = [enemy[0]-mepos[0],enemy[1]-mepos[1]]
        if fireLoc[0]==fireLoc[1] and fireLoc[0] > 0:
            fireDir = "down"
        elif fireLoc[0]==fireLoc[1] and fireLoc[0] < 0:
            fireDir = "up"
        sender.attack_laser(fireDir)
    elif weaponType == "mortar":
        fancyprint("Fire in tha hole!")
        sender.attack_mortar(enemy[0]-mepos[0],enemy[1]-mepos[1]) 
    elif weaponType == "droid": #todo
        fancypring("Maybe these are the droids you're loooking for bitch!")
        sender.attack_droid(getDirection(enemy[0],enemy[1],players)) #tar en sequence av tall. hvordan? todo if time....
    else:
        error("Invalid weapon...")


def findMoveableSpot(me,topos,players,map):
    movDir = randomDirection()
    newLocation = getLocation(me[0],me[1],movDir)
    while isRockOrVoid(map,newLocation[0],newLocation[1]):
        movDir = randomDirection()
        newLocation = getLocation(me[0],me[1],movDir)
    return movDir

def distance(i,j):
    return sqrt(((j[1]-i[1])**2)+((j[0]-i[0])**2))

#Sjekker om det er et tomrom eller om det er stein (sjekker ogsaa for spawn-rute siden vi ikke kan bevege oss inn igjen)
def isRockOrVoid(map,x,y):
    try:
        return "O"==map["data"][x][y] or "V"==map["data"][x][y] or "S"==map["data"][x][y]
    except IndexError:
        return True;

def isMineableArea(map,j,k):
    return "R"==map["data"][j][k] or "E"==map["data"][j][k] or "C"==map["data"][j][k]

def closestEnemyPos(players):
    global mepos
    closest = (1000,1000)
    for p in players:
            ppos = [int(num) for num in p["position"].split(",")]
            if ppos != mepos and ppos != selfPos(players):
                if distance(mepos,ppos) < distance(closest,mepos):
                    closest = ppos
    return closest

#finne naermeste mulige miningplass 
def closestMiningPos(map):
    global mepos
    closest = (1000,1000)
    mapJ = map["j-length"]
    mapK = map["k-length"]
    for j in range(0,mapJ):
        for k in range(0,mapK):
            if map["data"][j][k] == "R" or map["data"][j][k] == "E" or map["data"][j][k] == "C":
                if distance(mepos,closest) > distance(mepos,(j,k)):
                    closest = (j,k)
    return closest

def inWeaponsRange(mepos,target,weapon,weaponLevel):
    compDist = distance(mepos,target)
    fancyprint("distance to enemy: " + str(compDist))
    if weapon == "mortar":
        return True if compDist <= 2.0+float(weaponLevel-1) and compDist > 1.5 else False #fix, saa vi ikke skader oss selv?
    elif weapon == "droid":
        return True if compDist <= 3.0+float(weaponLevel-1) else False
    elif weapon == "laser":
        #sjekker maa legges til her for aa sjekke om det er diagonalt eller rett opp eller ned... hvis ikke returner false
        isUpOrDown = [mepos[0]-target[0],mepos[1]-target[1]]
        if (mepos[0] == target[0] or mepos[1] == target[1]) or (isUpOrDown[0] == isUpOrDown[1]): 
            return True if compDist <= 5.0+float(weaponLevel-1) else False
        else:
            return False

def selfPos(players):
    for p in players:
        if p["name"] == botname:
            return [int(num) for num in p["position"].split(",")]
    return (0,0)

def getDirection(j,k,players):
    global mepos
    fancyprint("me: " + str(mepos[0]) + "," + str(mepos[1]) + " and other: " + str(j) + "," + str(k))
    
    if mepos[0]-j <= 0 and mepos[1]-k > 0:
        return "left-up"
    elif mepos[0]-j < 0 and mepos[1]-k <= 0:
        return "left-down"
    elif mepos[0]-j > 0 and mepos[1]-k == 0:
        return "right-up"
    elif mepos[0]-j >= 0 and mepos[1]-k < 0:
        return "right-down"
    elif mepos[0]-j > 0 and mepos[1]-k > 0:
        return "up"
    elif mepos[0]-j < 0 and mepos[1]-k < 0:
        return "down"
    else:
        fancyprint("Decided to go random!") 
        return randomDirection()

def getLocation(j,k,pos):
    if pos == "up":
        return (j-1,k-1)
    elif pos == "down":
        return (j+1,k+1)
    elif pos == "right-up":
        return (j-1,k)
    elif pos == "left-up":
        return (j,k-1)
    elif pos == "right-down":
        return (j,k+1)
    elif pos == "left-down":
        return (j+1,k)
    else:
        return (j,k)

#hjelpemetode planlagt til bruk for aa ikke gaa helt oppi fienden naar den er i spawn
def mirrorPos(pos):
    if pos == "up":
        return "down"
    elif pos == "down":
        return "up"
    elif pos == "right-up":
        return "left-down"
    elif pos == "right-down":
        return "left-up"
    elif pos == "left-up":
        return "right-down"
    else:
        return "right-up"

#just in case we need to move random
def randomDirection():
    return random.choice(["up","down","right-up","right-down","left-up","left-down"])

#funksjon for aa motta alt ----------------------------------------------------------------------------
def recvAll():
    global matchOngoing
    try:
        dataline = ""
        newchar = ' '
        while newchar != '\n':
            newchar = sock.recv(1) 
            dataline += newchar
            if not newchar:
                matchOngoing = False
                break
        return dataline
    except socket.error:
        matchOngoing = False

#Innstillinger for kjoering --------------------------------------------------------------------------
fancyprint(botname + " is the name")
try:
    sock = socket.socket(socket.AF_INET,socket.SOCK_STREAM)
    sock.connect(('127.0.0.1',54321))
except socket.error:
    fancyprint("Could not connect...")
    sys.exit(0)

recv = skyport.SkyportReceiver()
recv.handler_error = error
recv.handler_handshake_successful = handshake
recv.handler_gamestart = gamestart
recv.handler_gamestate = gamestate
recv.handler_action = action
recv.handler_endturn = endturn
sender = skyport.SkyportTransmitter(sendData)
matchOngoing = True

#foer start sender vi et handshake
sender.send_handshake(botname)

#selve kjoeringen
while matchOngoing:
    try:
        #dataline = sock.recv(2048) 
        dataline = recvAll()
        if dataline == None:
            break
        dataline = dataline.rstrip('\n') 
        #fancyprint("Reciveved: " + dataline)
        recv.parse_line(dataline)
    except socket.timeout:
        fancyprint("Disconnected...")
        sys.exit(0)
fancyprint("Host closed, or match ended...")
