package aborysa.PowerShot.Map;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

import org.json.*;

import aborysa.PowerShot.AI.Bot;
public class Loader {
	
	public static Map LoadMap(JSONObject mapArray){
		Map map;
		try{
			int width = mapArray.getInt("k-length");
			int height = mapArray.getInt("j-length");
			System.out.println(width + ", " + height);
			String[] mapValues = new String[width * height];
			for (int j = 0; j < height; j++){
				for (int k = 0; k < width; k++){
					mapValues[(j*width) + k] = (String)((JSONArray)mapArray.getJSONArray("data").get(j)).get(k);
				}
			}
			map = new Map(width, height, mapValues);
			
			}catch(ArrayIndexOutOfBoundsException e){
				System.out.println("Array index out of bounds, missing information!");
				return null;
			}catch(JSONException e){
				System.out.println("Map object was not correct");
				return null;
			}
		System.out.println("Map loaded");
		return map;
	}
	public static ArrayList<Bot> LoadBots(JSONArray playerArray){
		
		ArrayList<Bot> botMap;
		try{
			int botCount = playerArray.length();
			botMap = new ArrayList<Bot>(botCount); 
			for (int i = 0; i < botCount; i++){
				JSONObject pBot = (JSONObject) playerArray.get(i);
				String name = pBot.getString("name");
				JSONObject pW = (JSONObject) pBot.get("primary-weapon");
				JSONObject sW = (JSONObject) pBot.get("secondary-weapon");
				String pWN = pW.getString("name");
				int pWL = pW.getInt("level");
				String sWN  = sW.getString("name");
				int sWL = sW.getInt("level");
				int score = pBot.getInt("score");
				int hp = pBot.getInt("health");
				int jPos=0;
				int kPos=0; 
				for (int k = 0; k<pBot.getString("position").length();k++){
					if (pBot.getString("position").substring(k, k+1).equals(",")){
						jPos = Integer.parseInt(pBot.getString("position").substring(0, k));
						kPos = Integer.parseInt(pBot.getString("position").substring(k+2, pBot.getString("position").length()));
						break;
					}
				}
				botMap.add(new Bot(name,hp,pWN,pWL,sWN,sWL,score,kPos,jPos));
				
			}	
			
			}catch(ArrayIndexOutOfBoundsException e){
				System.out.println("Array index out of bounds, missing information!");
				return null;
			}catch(JSONException e){
				System.out.println("Bots  was not correct(first message?): " + e.toString());
				return null;
			}
	
		return botMap;
	}
}
