package aborysa.PowerShot.AI;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import aborysa.PowerShot.PathFinding.*;
import aborysa.PowerShot.Map.*;
import aborysa.PowerShot.net.*;
import org.json.*;
/*
 *AI:
AI attack logic:

1. Check wheter can be hit:
	if can be hit se if targets are killable
		if can kill check wheter safe(true -> kill)
	if not check for safe spots(safe after/before attack) + attack spots
		if find both goto and attack most trethning player, else attack weakest
	if only one goto most benefitial spot, and do most benefitial action in score(own score or less of other score)

benefit of attack action = gain score + all(damage of player * (player score / own score)) + all(kill of player(-) * (player score / own score)) + (possible lose score)

AI main logic:
	find most benefitial action

 */

public class Controller{
	ClientHandle client;
	public String directions[] = {"up","down","right-up","right-down","left-up","left-down"};
	public String primaryWeapon;
	public String secondaryWeapon;
	public int PL = 1;
	public int SL = 1;
	public Map map;
	public Bot[] bots;
	public ArrayList<Bot> botMap = new ArrayList<Bot>();
	public MapAnalyzer mapAnalyzer;
	public int k;
	public int j;
	public int E = 0;
	public int R = 0;
	public int C = 0;
	public int AIbotIndex = 0;
	public JSONObject message;
	boolean firstTime = true;
	boolean connected = false;
	public String superBotName;
	final int[] LaserDamage = {16, 18, 22};
	final int[] DroidDamage = {22, 24, 26};
	final int DroidAoEDamage = 10;
	final int[] GranatDamage = {20,20,25};
	final int GranatAoeDamage = 18;
	
	
	public int[] benefitRes(){
		int benefitPW;
		int benefitSW;
		int resP = 0;
		int resS = 0;
		int total = 0;
		int bestPK = 0;
		int bestPL = 0;
		int bestPJ = 0;
		int bestSJ = 0;
		int bestSK = 0;
		int bestSL = 0;
		int bestK = 0;
		int bestJ = 0;
		String PW = primaryWeapon;
		String SW = secondaryWeapon;
		String resPT = "G";
		String resST = "G";
		
		if (primaryWeapon == "laser"){
			resP = mapAnalyzer.Rubidium;
			resPT = "R";
		}else if(primaryWeapon == "mortar"){
			resP = mapAnalyzer.Explodium;
			resPT = "E";
		}else {
			resP = mapAnalyzer.Scrap;
			resPT = "C";
		}
		if (secondaryWeapon == "laser"){
			resS = mapAnalyzer.Rubidium;
			resST = "R";
		}else if(secondaryWeapon == "mortar"){
			resS = mapAnalyzer.Explodium;
			resST = "E";
		}
		else {
			resS = mapAnalyzer.Scrap;
			resST = "C";
		}
		System.out.println("Ammount of " + resPT + ": " + resP + ", ammounf of " + resST + ": " + resS);
		if (resP > 3+PL){
			
			int sResJ = 0;
			int sResK = 0;
			int length = 999999;
			for(int j = 0; j< map.height;j++){
				for(int k = 0; k< map.width;k++){
					if (map.getTile(j, k).equals(resPT)){
						String[] testPath = findPath(this.k, this.j, k, j, 1);
						if(testPath != null){
						if (testPath.length < length){
							length = testPath.length;
							sResJ = j;
							sResK = k;
						}
						}
					}
				}
			}
			bestPK = sResK;
			bestPJ = sResJ;
			bestPL = length;
			benefitPW = 60 / bestPL;
		}else{
			benefitPW = 0;
		}
		if(resS > 3+SL){
			
			int sResJ = 0;
			int sResK = 0;
			int length = 99999999;
			for(int j = 0; j< map.height;j++){
				for(int k = 0; k< map.width;k++){
					if (map.getTile(j, k).equals(resST)){
						String[] testPath = findPath(this.k, this.j, k, j, 1);
						if(testPath != null){
						if (testPath.length < length){
							length = testPath.length;
							sResJ = j;
							sResK = k;
						}
						}
					}
				}
			}
			bestSK = sResK;
			bestSJ = sResJ;
			bestSL = length;
			benefitSW = 60/length;
		}else{
			benefitSW = 0;
		}
		if(benefitPW >= benefitSW){
			bestK = bestPK;
			bestJ = bestPJ;
			total = benefitPW;
		}else{
			bestK = bestSK;
			bestJ = bestSJ;
			total = benefitSW;
		}
		int[] data = {total,bestK,bestJ};
		return data;
	}
	
	public int[] totalDGranat(){
		int mostDamage = 0;
		int targetK = 0;
		int targetJ = 0;
		
		ArrayList<Integer> targets = new ArrayList<Integer>();
		ArrayList<Integer> secTargets = new ArrayList<Integer>();
		int level = 1;
		if (primaryWeapon == "mortar" || secondaryWeapon == "mortar"){
			if (primaryWeapon == "mortar"){level = PL;}else{level = SL;} 
				for(int i = 0; i< botMap.size();i++){

					if ( ( (botMap.get(i).j - j) < 1 + level) || ( (botMap.get(i).k - k) < 1 + level)){
						int tempDamage = 0;
						int totalSecDamage = 0;
						int tTD = 0;
						Bot temp = botMap.get(i);
						tTD = temp.hp - GranatDamage[level];
						if (tTD <= 0){
							tempDamage = temp.hp + 20;
						}else{
							tempDamage = GranatDamage[level];
						}
						for(int l = 0; l < botMap.size();i++){

							if ( (Math.abs(botMap.get(l).j - temp.j) <= 1) && (Math.abs(botMap.get(l).k - temp.k)<= 1)){
								if (botMap.get(l).hp - GranatAoeDamage <= 0 ){
									totalSecDamage += botMap.get(l).hp + 20;
								}else{
									totalSecDamage += GranatAoeDamage;
								}
							} 
						}
						tempDamage += totalSecDamage;
						if (tempDamage > mostDamage){
							mostDamage = tempDamage;
							targetK = temp.k;
							targetJ = temp.j;
						}
					} 
				}
			}
		int[] infoTable = {mostDamage,targetK,targetJ};
		return infoTable;
	}
	public String[] shortest(){
		String[] shortestPath = null;
		for(int i = 0; i< botMap.size();i++) {
			String[] tempPath = findPath(k,j,botMap.get(i).k,botMap.get(i).j,1);
			if ((shortestPath == null)){
				shortestPath =tempPath;
			}else if(tempPath.length < shortestPath.length){
				shortestPath = tempPath;
			}
		}
		return shortestPath;
		
	}
	public int[] totalDLaser(){
		int damage = 0;
		int[] damageA = new int[directions.length];
		String direction = "";
		int appendDirection = 0;
		int level=0;
		if (primaryWeapon == "laser"){
			level = PL;
		}else if (secondaryWeapon == "laser"){
			level = SL;
		}
			for(int i=0; i< botMap.size();i++){
				if(i == AIbotIndex){
					continue;
				}
				Bot tempBot = botMap.get(i);
				boolean append = false;
				int tempDir = 0;
				int signJ = (int) Math.signum(tempBot.j-j);
				int signK = (int )Math.signum(tempBot.k - k);
				if ( (signJ < 0) && (-4 - level <= tempBot.j-j) && ( tempBot.k == k)){
					append = true;
					tempDir = 2;
				}
				if ( (signJ > 0) && (4 + level >= tempBot.j-j) && ( tempBot.k == k)){
					append = true;
					tempDir = 5;
				}
				if ( (signK < 0) && (-4 - level <= tempBot.k-k) && ( tempBot.j == j)){
					append = true;
					tempDir = 4;
				}
				if ( (signK > 0) && (4 + level >= tempBot.k-k) && ( tempBot.j == j)){
					append = true;
					tempDir = 3;
				}
				if ( (signJ + signK > 0) && (4 + level >= tempBot.j-j) ){
					append = true;
					tempDir = 1;
				}
				if ( (signJ + signK < 0) && (-4 - level <= tempBot.j-j) ){
					append = true;
					tempDir = 0;
				}
				if (append){
					if (!inSPath("O",k,j,botMap.get(i).k,botMap.get(i).j)){
						int tempD = tempBot.hp - LaserDamage[level];
						if (tempD <= 0){
							tempD = tempBot.hp + 20;
						}
						damageA[tempDir] +=tempD;
					}
				}
			}
			for(int i = 0; i< damageA.length;i++){
				int biggestIndex = 0;
				if (damageA[i] > damage){
					damage = damageA[i];
					appendDirection = i;
				}
			}
			int[] data = {appendDirection,damage};
 		return data;		
	}
	public String[] totalDDroid(){
		int damage = 0;
		int level = 1;
		String[] data = null;
		
		if (primaryWeapon == "droid"){
			level = PL;
		}else if(secondaryWeapon == "droid"){
			level = SL;
		}else{
			return null;
		}
		for(int i =0; i<botMap.size();i++){

			Bot tempBot = botMap.get(i);
			String[] tempPath;
			if ((Math.abs(tempBot.k - k) <= level + 2) || (Math.abs(tempBot.j - j) <= level + 2)){
				tempPath = PathFinder.findPath(map,k, j, tempBot.k, tempBot.j,2,2+level);
				if (tempPath != null){
					int tempDamage;
					if (tempBot.hp - DroidDamage[level] <= 0){
						tempDamage = 20 + tempBot.hp;
					}
					else{
						tempDamage = DroidDamage[level];
					}
					for(int l = 0; l< botMap.size();l++){

						int maxKJ = Math.max(Math.abs(botMap.get(l).k - tempBot.k),Math.abs(botMap.get(l).j - tempBot.j));
						if(maxKJ < 1){
							if(botMap.get(l).hp - DroidAoEDamage <= 0){
								tempDamage += botMap.get(l).hp + 20;
							}else{
								tempDamage += DroidAoEDamage;
							}
						}
					}
					if(tempDamage > damage){
						damage = tempDamage;
						data = tempPath;
						data[0] = String.valueOf(damage);
					}
				}
			} 
			
		}	
		return data;		
	}
	public Controller(ClientHandle client){
		this.client = client;	
		connected = client.isConnected();
		superBotName =client.name;
	}
	/*public Bot[] getBots(){
		Bot[] bots = new Bot[botMap.size()];
		for(int i=0; i< botMap.size();i++){
			bots[i] = botMap.get(i);
		}
		return bots;
	}*/
	public void chooseWeapon(String PW, String SW){
		primaryWeapon = PW;
		secondaryWeapon = SW;
		client.sendLoadOut(primaryWeapon,secondaryWeapon);
	}
	
	public void readMessage(){

		
		JSONObject message = new JSONObject(client.receive());
		try{
			while( ! (message.get("message").equals("gamestate")) ){
				System.out.println("No gamestate! -------------------");
				message = new JSONObject(client.receive());
			}
			if (message.get("message").equals("gamestate")){
				if(!firstTime){
					JSONObject mapD = (JSONObject) message.get("map");
					map = Loader.LoadMap(mapD);
					mapAnalyzer = new MapAnalyzer(map);
					JSONArray players =  (JSONArray) message.get("players");
					botMap = Loader.LoadBots(players);
					for(int i=0; i< botMap.size();i++){
						System.out.println(botMap.get(i).name);
						if (botMap.get(i).name.equals(superBotName.toString())){
							k = botMap.get(i).k;
							j = botMap.get(i).j;
							botMap.remove(i);
							break;
						}
					}
				}else{
					JSONObject mapD = (JSONObject) message.get("map");
					map = Loader.LoadMap(mapD);
					mapAnalyzer = new MapAnalyzer(map);
					JSONArray players =  (JSONArray) message.get("players");
					botMap = Loader.LoadBots(players);
					firstTime = false;
				}
			}
		}catch(JSONException e){
			System.out.println("Got error message!");
		}
		
	}
	
	public void waitForTurn(){
		JSONObject message = new JSONObject(client.receive());
		try{
			if (message.get("message") == "endturn"){
				message = new JSONObject(client.receive());
			}
		}catch(JSONException e){
			
		}
	}
	public boolean useMortar(int j, int k){
		if ((primaryWeapon == "mortar")||(secondaryWeapon == "mortar")){
			client.sendAction("mortar", "coordinates", "" + j +"," + k);
			return true;
		}
		return false;
	}
	
	public boolean useLaser(String direction){
		if ((primaryWeapon == "laser")||(secondaryWeapon == "laser")){
			for (String i : directions){
				if (i == direction){
					client.sendAction("laser", "direction", direction);
					return true;
				}
			}
		}
		return false;		
	}
	
	public boolean useDroid(String[] sequ){
		if ((primaryWeapon == "droid")||(secondaryWeapon == "droid")){
				String[] path = new String[sequ.length-1];
				JSONArray message = new JSONArray();
				for(int i=0; i< path.length;i++){
					path[i] = sequ[i+1];
					message.put(path[i]);
				}	
			
				client.sendAction("droid", "sequence", message);
				return true;
			
		}
		return false;
	}
	public boolean checkValidMove(String direciton){
		if ((direciton == "up") && (map.getTile(k-1, j-1) != "V") && (map.getTile(k-1, j-1) != "O") && (map.getTile(k-1, j-1) != "S")){
			return true;
		}
		if ((direciton == "down") && (map.getTile(k-1, j-1) != "V") && (map.getTile(k-1, j-1) != "O") && (map.getTile(k-1, j-1) != "S")){
			return true;
		}
		if ((direciton == "left-up") && (map.getTile(k-1, j-1) != "V") && (map.getTile(k-1, j-1) != "O") && (map.getTile(k-1, j-1) != "S")){
			return true;
		}
		if ((direciton == "left-down") && (map.getTile(k-1, j-1) != "V") && (map.getTile(k-1, j-1) != "O") && (map.getTile(k-1, j-1) != "S")){
			return true;
		}
		if ((direciton == "right-up") && (map.getTile(k-1, j-1) != "V") && (map.getTile(k-1, j-1) != "O") && (map.getTile(k-1, j-1) != "S")){
			return true;
		}
		if ((direciton == "right-down") && (map.getTile(k-1, j-1) != "V") && (map.getTile(k-1, j-1) != "O") && (map.getTile(k-1, j-1) != "S")){
			return true;
		}
		return false;
	}
	
	public boolean safeFromLaser(){return safeFromLaser(k,j);}
	
	public boolean safeFromMortar(){return safeFromMortar(k,j);}

	public boolean safeFromDroid(){return safeFromDroid(k,j);}
	
	public boolean inPath(String tile, int s_k, int s_j, int e_k,int e_j){
		for (int k = 0; k < (Math.abs(s_k-e_k));k++){
			for (int j = 0; j < (Math.abs(s_j-e_j));j++){
				if (map.getTile((int) (s_k + k * Math.signum(s_k-e_k)),(int)( s_j + j * Math.signum(s_j-e_j))) == tile){
					return true;
				}
			}
		}
		return false;
	}

	public boolean inSPath(String tile, int s_k, int s_j, int e_k,int e_j){
		if (((s_k == e_k) && (s_j != e_j)) ||((s_k - e_k == (s_j - e_j)) || ((s_j == e_j) && (s_k != e_k))  ))
			for (int k = 0; k < (Math.abs(s_k-e_k));k++){
				for (int j = 0; j < (Math.abs(s_j-e_j));j++){
					if (map.getTile((int) (s_k + k * Math.signum(s_k-e_k)),(int)( s_j + j * Math.signum(s_j-e_j))) == tile){
						return true;
					}
				}
			}
		return false;
	}
	public String[] findPath(int s_k, int s_j, int e_k,int e_j, int type){
		System.out.println(map.width);
		String[] path = PathFinder.findPath(map,s_k, s_j, e_k, e_j,type,500);
		return path;
	}
	public String[] makePath(){
		String[] path = null;
		return path;
	}
	public void mine(){
		if (map.getTile(j, k) == "R") R++;
		
		if (map.getTile(j, k) == "E") E++;
		
		if (map.getTile(j, k) == "C") C++;
		client.sendAction("mine", "", "");
	}
	public void upgrade(String type){
		client.sendAction("upgrade","weapon",type);
	}
	public boolean safeFromLaser(int k, int j){
		for(int i=0;i< botMap.size();i++){

			if (botMap.get(i).primaryWeapon == "laser"){
				if (((Math.abs(k - bots[i].k) <= 4+botMap.get(i).pWL) && (j==botMap.get(i).j)) || ((Math.abs(k-botMap.get(i).k) == Math.abs(k-botMap.get(i).j) ) && Math.abs(k-botMap.get(i).k) <=4+botMap.get(i).pWL)){
					return inSPath("O",k,j,botMap.get(i).k,botMap.get(i).j);
				}
				if ((Math.abs(j - botMap.get(i).j) <= 4+botMap.get(i).pWL) && (j==botMap.get(i).k)){
					return inSPath("O",k,j,botMap.get(i).k,botMap.get(i).j);
				}
				
			}
			if (botMap.get(i).secondaryWeapon == "laser"){
				if (((Math.abs(k - bots[i].k) <= 4+botMap.get(i).pWL) && (j==botMap.get(i).j)) || ((Math.abs(k-botMap.get(i).k) == Math.abs(k-botMap.get(i).j) ) && Math.abs(k-botMap.get(i).k) <=4+botMap.get(i).pWL)){
					return inSPath("O",k,j,botMap.get(i).k,botMap.get(i).j);
				}
				if ((Math.abs(j - botMap.get(i).j) <= 4+botMap.get(i).pWL) && (j==botMap.get(i).k)){
					return inSPath("O",k,j,botMap.get(i).k,botMap.get(i).j);
				}
				
			}
		}
		return true;
	}
	public boolean safeFromMortar(int k, int j){
		for(int i=0;i< bots.length;i++){
			if (bots[i].primaryWeapon == "mortar"){
				if (Math.abs(k - bots[i].k) <= 4+bots[i].pWL){
					return false;
				}
			}
		}
		return true;
	}
	public boolean safeFromDroid(int k, int j){
		for(int i=0;i< bots.length;i++){
			if (bots[i].primaryWeapon == "droid"){
				String[] testPath = PathFinder.findPath(map, k, j, bots[i].k, bots[i].j,1, 4+bots[i].pWL);
				if (testPath !=null){
					return false;
				}
				if (Math.abs(k - bots[i].k) <= 4+bots[i].pWL){
					return false;
				}
			}
		}
		return true;
	}

	
	public boolean move(String direction){
		for (String i : directions){
			if (i == direction){
				client.sendAction("move", "direction", direction);
				return true;
			}
		}
		return false;
	}
	
}
