/*
 * Decompiled with CFR 0.152.
 */
package aborysa.PowerShot.net;

import aborysa.PowerShot.net.Client;
import java.io.IOException;
import java.net.UnknownHostException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientHandle {
    Client client;
    int port;
    String addr;
    public String name;
    String[] str;
    boolean connected = false;

    public ClientHandle(String addr, int port, String name) {
        this.port = port;
        this.addr = addr;
        this.name = name;
        this.connect();
    }

    public boolean isConnected() {
        return this.connected;
    }

    private boolean connect() {
        try {
            this.client = new Client(this.addr, this.port);
            this.sendHand();
            System.out.println("Waiting for hand");
            String message = this.receive();
            JSONObject status = new JSONObject(message);
            String str = "connect";
            if (status.getBoolean("status")) {
                System.out.println("Connected!");
                this.connected = true;
            } else {
                System.out.println("Did not connect correctly!");
                this.connected = false;
            }
            return this.connected;
        }
        catch (UnknownHostException e) {
            System.out.println(e);
            return false;
        }
        catch (IOException e) {
            System.out.println(e);
            return false;
        }
        catch (JSONException e) {
            System.out.println(e);
            return false;
        }
    }

    private void sendHand() {
        JSONObject message = new JSONObject().put("message", "connect").put("revision", 1).put("name", this.name);
        this.client.SendData(message.toString());
    }

    public void sendJSONObject(JSONObject obj) {
        this.client.SendData(obj.toString());
    }

    public void sendLoadOut(String p, String s) {
        System.out.println("SENDING LOADOUT!");
        JSONObject message = new JSONObject().put("message", "loadout").put("primary-weapon", p).put("secondary-weapon", s);
        this.client.SendData(message.toString());
    }

    public void sendAction(String actionType, String actionKey, Object actionValue) {
        JSONObject message = new JSONObject();
        message.put("message", "action").put("type", actionType).put(actionKey, actionValue.toString()).put("from", this.name);
        this.client.SendData(message.toString());
    }

    public void sendAction(String actionType, String actionKey, JSONArray actionValue) {
        JSONObject message = new JSONObject();
        message.put("message", "action").put("type", actionType).put(actionKey, actionValue).put("from", this.name);
        this.client.SendData(message.toString());
    }

    public String receive() {
        return this.client.receive();
    }
}

