#ifndef __PLAYER_H__
#define __PLAYER_H__

#include <jansson.h>

#define LASER       0
#define MORTAR      4
#define DROID       8

typedef struct player {
    char *name;
    int weapons[2];
    int j, k;
    float hp;
    float score;
    struct player *next;
} player_t;

extern player_t *players;
extern player_t *me;
extern int player_count;

player_t *get_player(const char *name);
player_t *get_player_by_index(int index, player_t *skip);
int update_player_from_json(int initial, json_t *json);
char *weapon_to_string(int weapon);

#define weapon_level(weapon) ((weapon) & 0x3)
#define weapon_type(weapon)  ((weapon) & 0xc)

#endif
