#include <assert.h>

#include "map.h"

int map_j = -1, map_k = -1, map_size = 0;
char *map = 0;

void update_map_from_json(int initial, json_t *json)
{
    if (initial) {
        map_j = json_integer_value(json_object_get(json, "j-length"));
        map_k = json_integer_value(json_object_get(json, "k-length"));
        map_size = map_j * map_k;
        map = malloc(sizeof(char) * map_size);
    }

    json_t *matrix = json_object_get(json, "data");
    for (int j = 0; j < map_j; j++) {
        json_t *row = json_array_get(matrix, j);
        for (int k = 0; k < map_k; k++) {
            json_t *cell = json_array_get(row, k);
            map_set(j, k, json_string_value(cell)[0]);
        }
    }
}
