#include "player.h"
#include "map.h"
#include "bfs.h"
#include "main.h"

float weapon_weights[9];

int weapon_sel_bfs_cb(int coords, int *camefrom, void *state)
{
    int this_camefrom = camefrom[coords];
    int *distances = (int *)state;
    distances[coords] = distances[this_camefrom] + 1;

    int weapon = -1;
    if (map[coords] == 'R') {
        weapon = LASER;
    } else if (map[coords] == 'E') {
        weapon = MORTAR;
    } else if (map[coords] == 'C') {
        weapon = DROID;
    }

    if (weapon != -1) {
        weapon_weights[weapon] += 1.0 / distances[coords];
        printf("Found resource %c (%s) at distance %d, weight is now %f\n",
            map[coords], weapon_to_string(weapon + 1),
            distances[coords], weapon_weights[weapon]);
    }

    return 0;
}

int get_weapon_selection()
{
    /* BFS from each spawn point and weigh each resource by proximity. */
    /* TODO: Do something cooler than just selecting the most-weighing. */

    for (int i = 0; i < 9; i++) weapon_weights[i] = -1;
    weapon_weights[LASER] = 0;
    weapon_weights[MORTAR] = 0;
    weapon_weights[DROID] = 0;
    for (int coords = 0; coords < map_size; coords++) {
        if (map[coords] == 'S') {
            int *camefrom = calloc(map_size, sizeof(int));
            int *distance = calloc(map_size, sizeof(int));
            printf("Starting BFS from spawn j %d k %d\n",
                map_j_val(coords), map_k_val(coords));
            bfs(coords, camefrom, 0, weapon_sel_bfs_cb, distance);
            free(camefrom);
            free(distance);
        }
    }
    
    debug("Laser weight %f\n", weapon_weights[LASER]);
    debug("Mortar weight %f\n", weapon_weights[MORTAR]);
    debug("Droid weight %f\n", weapon_weights[DROID]);

    /* FIXME: This is a temporary hack to always get a laser. */
    weapon_weights[LASER] = 9999999;
    int primary_weapon = 0, secondary_weapon = 0;
    int max_i = 0;
    float max_val = 0;
    for (int i = 0; i < 9; i++) {
        if (weapon_weights[i] > max_val) {
            max_i = i;
            max_val = weapon_weights[i];
        }
    }
    weapon_weights[max_i] = -1;
    primary_weapon = max_i + 1;
    debug("Primary weapon %s\n", weapon_to_string(primary_weapon));
    max_i = 0;
    max_val = 0;
    for (int i = 0; i < 9; i++) {
        if (weapon_weights[i] > max_val) {
            max_i = i;
            max_val = weapon_weights[i];
        }
    }
    secondary_weapon = max_i + 1;
    debug("Secondary weapon %s\n", weapon_to_string(secondary_weapon));

    return primary_weapon << 8 | secondary_weapon;
}
