import pygame.midi
import time

#flag_copy      = 0b0000100 #4
#flag_clear     = 0b0001000 #8
#flag_plain     = 0b0001100 #8+4=12
#colour_amber   = flag_plain+16*3+3
#colour_green   = flag_plain+16*3+0
#colour_red     = flag_plain+16*0+3

def gencol(r,g,instant=0):
    r = 3 if r>3 else (0 if r<0 else r)#clamp to 0..3
    g = 3 if g>3 else (0 if g<0 else g)#clamp to 0..3
    return (g<<4)+r+4*bool(instant)

def addrBtoM(i,v):
    m = [0,0,v]
    if i >= 72:
        m[0] = 176
        m[1] = i+32
    else:
        m[0] = 144
        x = i/8#row
        y = i%8#columna
        if x<8: m[1] = x*16+y
        else:   m[1] = y*16+9
    return m
    
def addrMtoB(m):
    if  m[0] == 176:
        return [m[1]-32,m[2]]
    else:
        x = m[1]/16#row
        y = m[1]%16#column
        if y<8: return [x*8+y,m[2]]
        else:   return [x+64, m[2]]
            
class LpMidi(object):
    def __init__(self):
        pygame.init()
        pygame.midi.init()
        self.midi_in_id = -1
        self.midi_out_id = -1
        self.got_device = False
        self.buffer = 0
        self.statusbufferA = [0]*80
        self.statusbufferB = [0]*80
        
    def open(self):
        for i in range( pygame.midi.get_count() ):
            r = pygame.midi.get_device_info(i)
            (interf, name, input, output, opened) = r
            if name == "Launchpad":
                if input:
                    midi_in_id = i
                if output:
                    midi_out_id = i
        if( (midi_in_id != -1) and (midi_out_id != -1) ):
            self.got_device = True
            self.midi_in = pygame.midi.Input(midi_in_id)
            self.midi_out = pygame.midi.Output(midi_out_id)
            self.reset()
            self.flip() #initialise buffering
        return self.got_device
    
    def flip(self,display=-1):
        m = [176,0,0]
        disp = self.buffer
        upd  = 1-self.buffer
        m[2] = 32 + disp + 4*upd
        self.write(m)
        self.buffer = 1-self.buffer
        
    def bufferwrite(self,buff):
        if (len(buff)%2): #if we get a dumb odd buffer
            buff.append(0) #pad it
        for i in range(len(buff)/2):
            self.write([146, buff[i*2],buff[i*2+1]])
        self.flip()
        if(self.buffer==0):
            self.statusbufferB = list(buff) #copy the buffer into status
        else:
            self.statusbufferA = list(buff)
    def diffbufferwrite(self,b):
        # make buffer exactly 80 to match self.status
        b = list(b)
        b.extend([0]*(80-len(b)))
        b = b[:80]
        
        if (self.buffer == 0):
            status = self.statusbufferA
        else:
            status = self.statusbufferB
        
        for i in range(80):
            pix = b[i]
            statpix = status[i]
            if(bool(pix-statpix)):
                m = [0,0,b[i]]
                if (i < 72): #still on notes
                    m[0] = 144
                    if (i <64): #on grid
                        m[1] = (i%8)+(i/8)*16
                    else:
                        m[1] = 8+(i-64)*16
                else: # top control row
                    m[0] = 176
                    m[1] = 32+i#i = 72..79 so n = 104..
                    
                self.write(m)
        self.flip()
    
    def reset(self, br=0):
        if br:
            self.midi_out.write_short(176,0,124+br)
            self.statusbuffer = [0]*80
        else:
            self.midi_out.write_short(176,0,0)
            self.statusbuffer = [0]*80
    
    def write(self,m):
        self.midi_out.write_short(m[0],m[1],m[2])
        addr = None
        #update status buffer
        if (144 == m[0]): #is note event
            x = m[1]%16
            y = m[1]/16
            if(x<8): #is part of grid
                addr = x+y*8
            else: #part of right control column
                addr = 8+y
        if (176 == m[0]): #top control row
            if(m[1]>= 104 and m[1] <= 111): #is relevant control
                addr = m[1]-32 #magic value is 104-72 (min value - base address)
        if(addr != None): #we need to update status
            if (self.buffer == 0):
                status = self.statusbufferA
            else:
                status = self.statusbufferB
            status[addr] = m[2]
    
    def poll(self):
        return self.midi_in.poll()
    
    def read(self,n):
        return self.midi_in.read(n)
        
    def close(self):
        self.midi_in.close()
        self.midi_out.close()
        pygame.midi.quit()
        pygame.quit()