#!/usr/bin/python

misc_start = True
misc_start = False

## ----------------------------------------------------------------------------
## ----------------------------------------------------------------------------
##
##           ______              _        _             _ _
##          |  ____|            | |      | |           | | |
##          | |__ _ __ __ _  ___| |_ __ _| |___    __ _| | |
##          |  __| '__/ _` |/ __| __/ _` | / __|  / _` | | |
##          | |  | | | (_| | (__| || (_| | \__ \ | (_| | | |
##          |_|  |_|  \__,_|\___|\__\__,_|_|___/  \__,_|_|_|
##  _   _                                      _
## | | | |                                    | |
## | |_| |__   ___  __      ____ _ _   _    __| | _____      ___ __
## | __| '_ \ / _ \ \ \ /\ / / _` | | | |  / _` |/ _ \ \ /\ / / '_ \
## | |_| | | |  __/  \ V  V / (_| | |_| | | (_| | (_) \ V  V /| | | |
##  \__|_| |_|\___|   \_/\_/ \__,_|\__, |  \__,_|\___/ \_/\_/ |_| |_|
##                                  __/ |
##                                 |___/
##
## ----------------------------------------------------------------------------
##
##   An FPGA demo by doz from crtc, music by mr_lou, font by tunk.
##
##       Presented at Sundown 2013, 2nd place in Wild Compo.
##
## ----------------------------------------------------------------------------
## ----------------------------------------------------------------------------
##
## The demo was running on my custom FPGA board, which I designed in order
## to create an Amstrad CPC emulator. It's not yet available to anyone else
## so there's not really any point releasing a binary version, so I'm making
## the source VHDL available and the script to create the data file.
## 
## The source is (c) 2013 Ranulf Doswell
## 
## If you have an questions, please e-mail doz@ranulf.net
##
## ----------------------------------------------------------------------------
## ----------------------------------------------------------------------------

import math
import sys
import frac_helper

from frac_helper import outputter
from frac_helper import helper

#musfile = "music/echoes.ym_tmp"
musfile = "music/echoes-verylong.ym.cut"

try:	txtfile = sys.argv[1]
except:	txtfile = None

try:	binfile = sys.argv[2]
except:	binfile = None

try:	asmfile = sys.argv[3]
except:	asmfile = None

###############################################################################

class ftree:
	def __init__(self,helper):
		self.helper = helper
		self.f = h.create("tree",125,-100,250,215,1)
		self.c = [self.f.choice(i) for i in xrange(1,7)]
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = False
		self.ofs = 0

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		if self.scrolling == True:
			self.ofs = self.ofs+1
		self.frame = self.frame + 1
		i=self.frame*0.8
		a1=-0.5240+0.0500*math.sin(0.015*i)
		a2=-0.6980+0.1000*math.sin(0.009*i+0.1)
		a3= 0.6980+0.0700*math.sin(0.011*i+0.2)
		a4= 0.3490+0.0300*math.sin(0.007*i+0.3)
		a5= 0.0000+0.0125*math.sin(0.013*i+0.4)
	
		# http://paulbourke.net/fractals/ifs_tree_b/
		self.c[0].transform_rot(0.0500, 0.6000,-a5*0.1, 0.0000, 0.0000, 0.0000)
		self.c[1].transform_rot(0.0500,-0.5000, 0.0000, 0.0000,     a5, 1.0000)
		self.c[2].transform_rot(0.6000, 0.5000,     a3,     a3, 0.0000, 0.6000)
		self.c[3].transform_rot(0.5000, 0.4500,     a4,     a4, 0.0000, 1.1000)
		self.c[4].transform_rot(0.5000, 0.5500,     a1,     a1, 0.0000, 1.0000)
		self.c[5].transform_rot(0.5500, 0.4000,     a2,     a2, 0.0000, 0.7000)
		self.f.resize(125,-100,250-self.ofs,215)

###############################################################################

class fman:
	def __init__(self,helper,ofs):
		self.helper = helper
		self.f = h.create("man",10,10,160,0)
		self.c = [self.f.choice(i) for i in [1,1,1,1, 2,2, 6,6, 4,4, 4,4,4, 6,6,6]]
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = True
		self.animating = True
		self.ofs = ofs
		self.ydir = 0
		self.yofs = 0
		self.doupdate = True

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		if self.doupdate == False:
			return
		if self.animating == True:
			self.frame = self.frame + 1
		if self.scrolling == True:
			self.ofs = self.ofs+1
		self.yofs = self.yofs + self.ydir

		sz=0.1
		sc=90/10.0
	
		wid=5.00
		hgt=2.50
	
		a1a=math.pi* 0.51*math.sin(0.041*self.frame+1.1) #*float(f)
		a2a=math.pi*-0.51*math.sin(0.041*self.frame+1.1) #*float(f)
		l1a=math.pi* 0.31*math.sin(0.041*self.frame+0.3) #*float(f)
		l2a=math.pi*-0.31*math.sin(0.041*self.frame+0.3) #*float(f)
		h=math.pi* 0.17
		f=math.pi*-0.125
		f2=math.pi*0.5
	
		la=2.0			# length of arm
		lja=la-0.3		# length of arm joint
		lae=1.2			# length of arm extent
		wa=1.0			# width of arm
		ta=4.0			# top of arm
	
		ll=1.7			# length of leg
		ljl=ll-0.3		# length of leg joint
		lle=1.5			# length of leg extent
		ljle=lle-0.3		# length of leg extent joint
		llf=1.5			# length of foot extent
		wl=1.0			# width of leg
		tl=7.0			# top of leg
	
		lerp=0.7
	
		# arms
		a1x=-lja*math.sin(a1a)
		a1y= lja*math.cos(a1a)
		a1b=a1a-h
	
		a2x=-lja*math.sin(a2a)
		a2y= lja*math.cos(a2a)
		a2b=a2a-h
	
		# legs
		l1x=-ljl*math.sin(l1a)
		l1y= ljl*math.cos(l1a)
		l1b=l1a-f
		l1x2=l1x-ljle*math.sin(l1b)
		l1y2=l1y+ljle*math.cos(l1b)
		l1c=l1b-f2
		l1c=(l1b-f2)*0.5+math.pi*-0.25
		l1c=(l1b-f2)*lerp+math.pi*-0.5*(1-lerp)
		l1y3=l1y2+llf*math.cos(l1c)-wl*math.sin(l1c)
	
		l2x=-ljl*math.sin(l2a)
		l2y= ljl*math.cos(l2a)
		l2b=l2a-f
		l2x2=l2x-ljle*math.sin(l2b)
		l2y2=l2y+ljle*math.cos(l2b)
		l2c=(l2b-f2)*lerp+math.pi*-0.5*(1-lerp)
		l2y3=l2y2+llf*math.cos(l2c)-wl*math.sin(l2c)
	
		if l2y3>l1y3: my3=l2y3
		else: my3=l1y3
	
		ydisp = 4.0-my3
	
		self.c[ 0].transform(wid*sz, 0,0, hgt*sz,   0,  0)			# head
		self.c[ 1].transform(0,hgt*sz, wid*sz, 0,-1.5,1.5)			# head
		self.c[ 2].transform(-wid*sz, 0,0, -hgt*sz,   0,3.0)		# head
		self.c[ 3].transform(0,-hgt*sz, -wid*sz, 0.0,1.5,1.5)		# head

		self.c[ 4].transform(1.00*sz, 0,0, 4.00*sz,   0,3.0)		# neck
		self.c[ 5].transform(2.00*sz, 0,0, 4.00*sz,   0,3.5)		# body

		self.c[ 6].transform_rot(wa*sz, la*sz,  a1a, a1a, 0,ta)		# arm
		self.c[ 7].transform_rot(wa*sz, lae*sz, a1b, a1b,  a1x,ta+a1y)		# hand
	
		self.c[ 8].transform_rot(wa*sz, la*sz,  a2a, a2a, 0,ta)		# arm
		self.c[ 9].transform_rot(wa*sz, lae*sz, a2b, a2b,  a2x,ta+a2y)		# hand
	
		self.c[10].transform_rot(wl*sz, ll*sz,  l1a, l1a, 0,tl)		# leg top
		self.c[11].transform_rot(wl*sz, lle*sz, l1b, l1b,  l1x,tl+l1y)		# leg mid
		self.c[12].transform_rot(wl*sz, llf*sz, l1c, l1c,  l1x2,tl+l1y2)	# leg foot
	
		self.c[13].transform_rot(wl*sz, ll*sz,  l2a, l2a, 0,tl)		# leg top
		self.c[14].transform_rot(wl*sz, lle*sz, l2b, l2b,  l2x,tl+l2y)		# leg mid
		self.c[15].transform_rot(wl*sz, llf*sz, l2c, l2c,  l2x2,tl+l2y2)	# leg foot
		self.f.resize(sc,sc,50+self.ofs,105+ydisp*sc+self.yofs)
	
###############################################################################

class ffloor:
	def __init__(self,helper,yofs=0):
		self.helper = helper
		self.f = h.create("floor",125,-100,140,215,1)
		self.c = [self.f.choice(i) for i in xrange(1,5)]
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = False
		self.scrollup = False
		self.yofs = yofs
#		self.update()
	
		# http://paulbourke.net/fractals/ifs_tree_b/
		self.c[0].transform_rot(0.5000, 0.5000, 0.00  , 0.10  ,-0.9000, 0.0000)
		self.c[1].transform_rot(0.6000,-0.3000, 1.14  , 1.14  , 0.1000,-0.1000)
		self.c[2].transform_rot(0.6000,-0.5000, 3.00  , 2.90  , 1.0000, 0.1500)
		self.c[3].transform_rot(0.2000,-0.4600,-1.30  ,-1.62  , 2.2500, 0.2000)

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		#print "floor update scroll"+str(self.scrolling)+" up "+str(self.scrollup)
		if self.scrolling == True:
			self.frame = self.frame + 1
		if self.scrollup and self.yofs>0:
			self.yofs = self.yofs - 0.1
		w=500
		self.f.resize(w,-5,-self.frame+340-w/2,200+self.yofs)

###############################################################################

class fksnow:
	def __init__(self,helper):
		self.helper = helper
		self.f = h.create("ksnow",125,-100,250,215,2)
		self.c = [self.f.choice(i) for i in xrange(1,7)]
		self.c.append(self.f.choice(7,3))
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = True
		self.ofs = 200
		self.size = 125
		self.shrinking = False
		self.rotating = True

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		if self.scrolling == True:
			self.ofs = self.ofs-0.5
			if self.frame == 300:
				self.shrinking = True
			if self.frame == 600:
				self.scrolling = False
		if self.shrinking and self.size>5:
			self.size = self.size - 0.5
		self.frame = self.frame + 1
		i=self.frame*0.85
		i2=self.frame*1.15
		a1=math.pi*0.5*math.sin(i2*0.007)
		if self.frame > 300 and abs(a1) < 0.01:
			self.rotating = False
		if self.rotating == False:
			a1 = 0
		a2=-1.5*a1
		a2=1.2*math.sin(0.023*i+0.1)*a1
		s=math.sin(0.013*i+0.05)/3.0
		#s=1.0/3

		r3 = math.sqrt(3.0)
		a=math.pi/6.0+a1

		for i in xrange(0,6):
			pa=math.pi*i/3.0+a1
			self.c[i].transform_rot(s,s, a2, a2, math.sin(pa)/r3, math.cos(pa)/r3)
		self.c[6].transform_rot(1.0/r3, 1.0/r3, a,a, 0,0)
		self.f.resize(self.size,self.size,250,100-self.ofs)

###############################################################################

class fksnow2:
	def __init__(self,helper):
		self.helper = helper
		self.f = h.create("ksnow",1,-1,250,215,4)
		self.c = [self.f.choice(i) for i in xrange(1,7)]
		self.c.append(self.f.choice(7,3))
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = False
		self.ofs = 0
		self.size = 125
		self.shrinking = True
		self.rotating = True

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		if self.scrolling == True:
#			self.ofs = self.ofs-0.5
			if self.frame == 300:
				self.shrinking = True
			if self.frame == 600:
				self.scrolling = False
		if self.shrinking and self.size>5:
			self.size = self.size - 0.5
		self.frame = self.frame + 1
		i=self.frame*0.85
		i2=self.frame*1.15
		a1=math.pi*0.5*math.sin(i2*0.007)
		if self.frame > 300 and abs(a1) < 0.01:
			self.rotating = False
		if self.rotating == False:
			a1 = 0
		a2=-1.5*a1
		a2=1.2*math.sin(0.023*i+0.1)*a1
		s=math.sin(0.013*i+0.05)/3.0
		#s=1.0/3

		a1=0
		a2=0
		s=1.0/3

		r3 = math.sqrt(3.0)
		a=math.pi/6.0+a1

		for i in xrange(0,6):
			pa=math.pi*i/3.0+a1
			self.c[i].transform_rot(s,s, a2, a2, math.sin(pa)/r3, math.cos(pa)/r3)
		self.c[6].transform_rot(1.0/r3, 1.0/r3, a,a, 0,0)
		self.f.resize(self.size,self.size,180,170-self.ofs+self.size*0.75)

###############################################################################

class ftri:
	def __init__(self,helper):
		self.helper = helper
		self.f = h.create("tri")
		self.c = [self.f.choice(i) for i in xrange(4,7)]
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = True
#		self.update()

		self.c[0].transform(0.5,0.0,0.0,0.5, 0.25,0.0)
		self.c[1].transform(0.5,0.0,0.0,0.5, 0.0 ,0.5)
		self.c[2].transform(0.5,0.0,0.0,0.5, 0.5 ,0.5)

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		if self.scrolling == True:
			self.frame = self.frame + 1
		w=500
		self.f.resize(320,200,360-self.frame,0)
#		self.f.resize(w,-5,-self.frame+360-w/2,200)

###############################################################################

class ffern:
	def __init__(self,helper,sz=15):
		self.helper = helper
		self.f = h.create("fern",5,-5,350,200,1)
		self.c = [self.f.choice(i) for i in xrange(1,5)]
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = True
#		self.update()
		self.sz=sz
	
		self.c[1].prob = 0.01
		self.c[0].prob = 0.07
		self.c[2].prob = 0.07
		self.c[3].prob = 0.85

		self.c[1].transform(0.00,0.00, 0.00,0.16,0.0,0.0)
		self.c[0].transform(0.20,-0.26,0.23,0.22,0.0,1.6)
		self.c[2].transform(-0.15,0.28,0.26,0.24,0.0,.44)
		self.c[3].transform(0.85,0.04,-0.04,0.85,0.0,1.6)

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		if self.scrolling == True:
			self.frame = self.frame + 1
		w=500
		self.f.resize(self.sz,-self.sz,400-self.frame,200)

###############################################################################

class fkline:
	def __init__(self,helper,yofs=0):
		self.helper = helper
		self.f = h.create("kline",360,-288,0,182,1)
		self.c = [self.f.choice(i) for i in xrange(1,5)]
		self.frame = 0
		self.f.update_callback=self.update
		self.scrolling = False
		self.scrollup = False
		self.yofs = yofs
#		self.update()
	
		# http://paulbourke.net/fractals/ifs_tree_b/
		self.c[0].transform(0.333000,  0.000000,  0.000000,  0.333000,  0.000000,  0.000000)
		self.c[1].transform(0.167000, -0.289000,  0.289000,  0.167000,  0.333000,  0.000000)
		self.c[2].transform(0.167000,  0.289000, -0.289000,  0.167000,  0.500000,  0.289000)
		self.c[3].transform(0.333000,  0.000000,  0.000000,  0.333000,  0.667000,  0.000000)


	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		self.f.resize(360,-288,0,182+self.yofs)
		return

###############################################################################

class fmandel:
	def __init__(self,helper,yofs=0):
		self.helper = helper
		self.f = h.create("mandel",280,-160,150,35) # http://paulbourke.net/fractals/ifs_mandel/
		self.c = [self.f.choice(i) for i in xrange(5,7)]
		self.frame = 0
		self.f.update_callback=self.update
		self.yofs = yofs
	
		# http://paulbourke.net/fractals/ifs_tree_b/
		self.c[0].transform(0.2020,-0.8050,-0.6890,-0.3420,-0.3730,-0.6530)
		self.c[1].transform(0.1380,0.6650,-0.5020,-0.2220,0.6600,-0.2770)

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		self.frame = self.frame + 1
		i=self.frame*0.85
		a1=math.pi*0.5*math.sin(i*0.07)
		a2=math.pi*0.5*math.sin(i*0.05)
		a3=math.pi*0.4*math.sin(i*0.03)

		self.c[0].transform(0.2020+0.05*math.sin(a1),-0.8050,-0.6890+0.05*math.sin(a3),-0.3420,-0.3730,-0.6530)
		self.c[1].transform(0.1380,0.6650+0.09*math.sin(a2+0.5),-0.5020,-0.2220,0.6600,-0.2770)

#		self.f.resize(360,-288,0,182+self.yofs)
		return

###############################################################################

class fpent:
	def __init__(self,helper,yofs=0):
		self.helper = helper
		self.f = h.create("pentagon",165,-120,100,185)
		self.c = [self.f.choice(i) for i in xrange(1,6)]
		self.frame = 0
		self.f.update_callback=self.update
		self.yofs = yofs
	
		self.c[0].transform(0.382000,  0.000000,  0.000000,  0.382000,  0.000000,  0.000000)
		self.c[1].transform(0.382000,  0.000000,  0.000000,  0.382000,  0.618000,  0.000000)
		self.c[2].transform(0.382000,  0.000000,  0.000000,  0.382000,  0.309000,  0.951000)
		self.c[3].transform(0.382000,  0.000000,  0.000000,  0.382000, -0.191000,  0.588000)
		self.c[4].transform(0.382000,  0.000000,  0.000000,  0.382000,  0.809000,  0.588000)

		self.a = 0.0
		self.aa = 0.00

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		self.frame = self.frame+1
		a=0.02 * self.frame

		self.a = self.a + self.aa
		self.aa = self.aa + 0.00007
		a = self.a

		self.c[0].transform_rot(0.382000,  0.382000, a,a,  0.000000,  0.000000)
		self.c[1].transform_rot(0.382000,  0.382000, a,a,  0.618000,  0.000000)
		self.c[2].transform_rot(0.382000,  0.382000, a,a,  0.309000,  0.951000)
		self.c[3].transform_rot(0.382000,  0.382000, a,a, -0.191000,  0.588000)
		self.c[4].transform_rot(0.382000,  0.382000, a,a,  0.809000,  0.588000)

		return
		i=self.frame*0.85
		a1=math.pi*0.5*math.sin(i*0.07)

		self.c[0].transform(0.2020+0.5*math.sin(a1),-0.8050,-0.6890,-0.3420,-0.3730,-0.6530)
		self.c[1].transform(0.1380,0.6650+0.5*math.sin(a1),-0.5020,-0.2220,0.6600,-0.2770)

#		self.f.resize(360,-288,0,182+self.yofs)
		return

###############################################################################

class fdragon:
	def __init__(self,helper,yofs=0):
		self.helper = helper
		self.f = h.create("ifs_dragon",20,20,180,20) # http://paulbourke.net/fractals/ifs_dragon
		self.c = [self.f.choice(i) for i in xrange(1,4)]
		self.frame = 0
		self.f.update_callback=self.update
		self.yofs = yofs
	
		self.c[0].prob = 80
		self.c[1].prob = 5
		self.c[2].prob = 5

		self.c[0].transform(0.824074,0.281428,-0.212346,0.864198,-1.882290,-0.110606)
		self.c[1].transform(0.088272,0.520988,-0.463889,-0.377778,0.785360,8.095795)
		self.c[2].transform(0.088272,0.520988,-0.463889,-0.377778,0.785360,8.095795)

		self.a = 0.0
		self.aa = 0.00

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		self.frame = self.frame + 1
		i=self.frame*0.85
		a1=math.pi*0.3*math.sin(i*0.07)
		a2=math.pi*0.5*math.sin(i*0.05)
		a3=math.pi*0.4*math.sin(i*0.03)
		a4=math.pi*0.7*math.sin(i*0.05)
		a5=math.pi*0.37*math.sin(i*0.02)
		a6=math.pi*0.0001*self.frame*math.sin(i*0.08)
		a7=math.pi*0.0003*self.frame*math.sin(i*0.08)


		self.c[0].transform(0.824074+0.05*math.sin(a1),0.281428,-0.212346+0.05*math.sin(a2),0.864198,-1.882290,-0.110606+0.37*math.sin(a7+0.5))
		self.c[1].transform(0.088272,0.520988+0.09*math.sin(a3+0.7),-0.463889,-0.377778,0.785360+0.03*math.sin(a5+0.5),8.095795)
		self.c[2].transform(0.088272,0.520988,-0.463889+0.03*math.sin(a4+0.5),-0.377778,0.785360,8.095795+0.07*math.sin(a6+0.5))


###############################################################################

class fcrtc:
	def __init__(self,helper,yofs=0):
		self.helper = helper
		self.f = h.create("crtc",220/7.0,180/7.0,0,20)
		self.c = []
		self.frame = 0
		self.f.update_callback=self.update
		self.yofs = yofs
	
		sz=0.15
		sz=0.1
		sz=0.125
		sz=0.14

		self.c.append(self.f.choice(2).transform(sz, 0,0, sz, 1,0))
		self.c.append(self.f.choice(2).transform(sz, 0,0, sz, 2,0))
		self.c.append(self.f.choice(2).transform(sz, 0,0, sz, 0,1))
		self.c.append(self.f.choice(2).transform(sz, 0,0, sz, 0,2))
		self.c.append(self.f.choice(2).transform(sz, 0,0, sz, 1,2))
		self.c.append(self.f.choice(2).transform(sz, 0,0, sz, 2,2))

		self.c.append(self.f.choice(4).transform(sz, 0,0, sz, 5,0))
		self.c.append(self.f.choice(4).transform(sz, 0,0, sz, 6,0))
		self.c.append(self.f.choice(4).transform(sz, 0,0, sz, 4,1))
		self.c.append(self.f.choice(4).transform(sz, 0,0, sz, 4,2))

		self.c.append(self.f.choice(3).transform(sz, 0,0, sz, 0,4))
		self.c.append(self.f.choice(3).transform(sz, 0,0, sz, 1,4))
		self.c.append(self.f.choice(3).transform(sz, 0,0, sz, 2,4))
		self.c.append(self.f.choice(3).transform(sz, 0,0, sz, 1,5))
		self.c.append(self.f.choice(3).transform(sz, 0,0, sz, 1,6))

		self.c.append(self.f.choice(6).transform(sz, 0,0, sz, 5,4))
		self.c.append(self.f.choice(6).transform(sz, 0,0, sz, 6,4))
		self.c.append(self.f.choice(6).transform(sz, 0,0, sz, 4,5))
		self.c.append(self.f.choice(6).transform(sz, 0,0, sz, 4,6))
		self.c.append(self.f.choice(6).transform(sz, 0,0, sz, 5,6))
		self.c.append(self.f.choice(6).transform(sz, 0,0, sz, 6,6))

	def remove(self):
		self.helper.remove(self.f)

	def update(self):
		self.frame = self.frame + 1
		i=self.frame*0.85

###############################################################################

o = outputter(txtfile, binfile)
o.music(musfile)
for y in xrange(0,26):
	o.text(0,y,chr(32)*46)
s="Fractals all the way down"
l=len(s)
x=int((45-l)/2)
o.text(x,0,s)

###############################################################################

dumped = False
h = helper(o)
h.drawadd(15)


if False:
#	koch=fkline(h)
	koch=fksnow2(h)
#	fern4=ffern(h,30)
	frame = 1
	h.drawadd(31)
	h.update()
	for rawframecounter in xrange(0,60*5*60):
		frame = frame + 1
#		koch.f.resize(100/math.sqrt(3),100/math.sqrt(3),180,150)
#		koch.f.resize(400,400,180,800/math.sqrt(3))
#		koch.f.resize(100,100,180,100)
#		koch.f.resize(200,200,180,400/math.sqrt(3)-50)

		koch.f.resize(200,200,180,270)
#		koch.f.resize(100,100,180,100)
#		koch.f.resize(50,50,180,100)
		o.frame(frame)
		h.update()

join = 1000

dofern = join+600
dotri = dofern+600

#dofern = 9999
#dotri = join+600

domisc = dotri+1500
docredits = domisc+2100
restart = docredits+1200

print "Credits start at frame %d (%d seconds)"%(docredits,docredits/60)
print "Restarts demo at frame %d (%d seconds)"%(restart,restart/60)
print

start = 1000
if misc_start:
	start = domisc

frame = start-1

if start<domisc:
	if start > 300:
		f=ffloor(h)
	if start > 750:
		t=ftree(h)
		t.frame = start-750

frame = start-1
for rawframecounter in xrange(0,2*7000+restart):
	frame = frame + 1
	sys.stderr.write("Frame%6d  \r"%frame)
	if frame<=1:
		ks=fksnow(h)
		f=ffloor(h,20)

	if frame==300:
		f.scrollup = True
	if frame>650 and frame<700:
		h.drawadd(int(7-(700-frame)/7))
	if frame==700:
		ks.remove()
	if frame==750:
		t=ftree(h)
	if frame>750 and frame<join:
		h.drawadd(int(1+(frame-750)*15.0/250))
#	if frame==700:
#		h.drawadd(7)
	else:
		h.drawadd(15)

	if frame==join:
		print t.frame
		m=fman(h, -200)
	if frame==join+1 and dumped == False:
		o.dumpasm(asmfile)
		dumped = True

	if frame==join+270:
		m.scrolling = False
		m.animating = False
	if frame==join+350:
		m.animating = True
		f.scrolling = True
		t.scrolling = True
	if frame==join+700:
		t.remove()


	if frame==dofern:
		fern1=ffern(h,5)

	if frame==dofern+100:
		fern2=ffern(h,10)

	if frame==dofern+200:
		fern3=ffern(h,15)

	if frame==dofern+300:
		fern4=ffern(h,20)

	if frame==dofern+800:
		fern1.remove()
		fern2.remove()
		fern3.remove()
		fern4.remove()

	if frame==dotri:
		t2=ftri(h)
		h.drawadd(1)

	if frame==dotri+220:
		m.scrolling = False
		m.animating = False
		f.scrolling = False
		t2.scrolling = False

	if frame==dotri+320:
		m.scrolling = True
		m.animating = True
		f.scrolling = True
		t2.scrolling = True
		m.ydir = -2.5 #(200.0/160.0)

	if frame==dotri+320+100:
		m.ydir = 0
		m.scrolling = False
		m.animating = False
		f.scrolling = False
		t2.scrolling = False

	if frame==dotri+500:
		t2.remove()
		t.remove()
		f.remove()

#		h = helper(o)
#		h.update()
#		m=fman(h, -200)

		m.doupdate = False
		m.f.resize(40,40,180,0)
		m.scrolling = False
		m.animating = False

	if frame==dotri+550:
		m.f.resize(35,35,180,0)

	if frame==dotri+600:
		m.f.resize(30,30,180,0)

	if frame==dotri+650:
		m.f.resize(25,25,180,0)

	if frame==dotri+700:
		m.f.resize(20,20,180,0)
		#koch.f.resize(1,1,400,200)
#		koch=fksnow2(h)
#		h.drawadd(31)

	if frame==dotri+775:
		m.f.resize(10,10,180,20)
		koch=fkline(h)
		koch.yofs=20
#		koch.f.resize(200,200,180,270)

	if frame==dotri+880:
		m.f.resize(5,5,180,50+30)
		koch.yofs=30
#		koch.f.resize(100,100,180,135)

	if frame==dotri+1000:
		m.f.resize(2.5,2.5,180,75+40)
		koch.yofs=40

	if frame==dotri+1100:
		m.f.resize(1.25,1.25,180,87.5+50)
		koch.yofs=50

	if frame==dotri+1200:
		m.remove()
		koch.remove()
		koch=fksnow2(h)

	if frame==domisc-1:
		koch.remove()

	if frame==domisc:
		h = helper(o)
		m = fmandel(h)

	if frame==domisc+250:
		m.remove()
		h = helper(o)
		m = fpent(h)

	if frame==domisc+1500:
		m.remove()
		m = fdragon(h)

	if frame==docredits:
		m.remove()
		m = fcrtc(h)

	if frame==restart:
		m.remove()
		h = helper(o)
		frame=0

	if frame== join+25:
		o.text(0,3,"A new demo from CRTC")
	if frame== join+550:
		o.text(0,3,"                    ")

	if frame== join+400:
		o.text(21,4,"Iterated Function Systems")
	if frame== join+450:
		o.text(27,5,"Running in realtime")
	if frame== join+500:
		o.text(27,6,"    ... on an FPGA!")

	if frame== join+600:
		o.text(21,4,"                         ")
	if frame== join+660:
		o.text(27,5,"                   ")
	if frame== join+770:
		o.text(27,6,"                   ")

	if frame== join+900:
		o.text(0,2,"Code and \"art~ by doz")
	if frame== join+950:
		o.text(0,3,"Music by mr_lou     ")
	if frame== join+1000:
		o.text(0,4,"Font by tunk        ")

	if frame== join+1100:
		o.text(0,2,"                      ")
	if frame== join+1150:
		o.text(0,3,"                    ")
	if frame== join+1200:
		o.text(0,4,"                    ")

	if frame==dotri+220:
		o.text(0,4,"Crikey, this big!")
	if frame==dotri+270:
		o.text(8,6,"Let's charge!")

	if frame==dotri+420:
		o.text(0,4,"                 ")
	if frame==dotri+420:
		o.text(8,6,"             ")

	if frame==dotri+550:
		o.text(0,2,"Oh my!")
		o.text(0,3,"It's empty up here!")
	if frame==domisc:
		o.text(0,2,"      ")
		o.text(0,3,"                   ")

	if frame==domisc:
		o.text(0,5,"Last minute filler?")
	if frame==domisc+50:
		o.text(13,6,"Check!")
	if frame==domisc+200:
		o.text(0,5,"                   ")
		o.text(13,6,"      ")

	if frame==domisc+500:
		o.text(0,11,"So, this was all very last minute...")
	if frame==domisc+700:
		o.text(0,11,"After working on this for months, yet again,")
		o.text(0,12,"I left the actual demo to the last minute!")
	if frame==domisc+900:
		o.text(0,11,"When I turned up to Sundown, I had about    ")
		o.text(0,12,"10 seconds of demo material but some ideas. ")
	if frame==domisc+1100:
		o.text(0,11,"I've not quite managed to realise all those ")
		o.text(0,12,"ideas given how much of a rush job I made...")
	if frame==domisc+1300:
		o.text(0,11,"But hopefully there's enough here for you   ")
		o.text(0,12,"to enjoy!                                   ")
	if frame==domisc+1500:
		o.text(0,11,"                                            ")
		o.text(0,12,"                                            ")

	if frame==domisc+1600:
		o.text(0,11,"Many thanks to Ruairi for organising Sundown")
		o.text(0,12,"and to everyone who helped out!             ")
	if frame==domisc+1800:
		o.text(0,11,"                                            ")
		o.text(0,12,"                                AMIIIIIIGA! ")
	if frame==domisc+1850:
		o.text(0,12,"                        MITTWOCH!           ")
	if frame==domisc+1900:
		o.text(0,12,"No way!      The real party is on the beach!")
#	if frame==domisc+1900:
#		o.text(0,11,"                                            ")
	if frame==domisc+1999:
		o.text(0,11,"                                            ")
		o.text(0,12,"                                            ")

	if frame==400:
		o.text(0,5,"Hey!")
		o.text(5,6,"Isn't that my planet!")
	if frame==500:
		o.text(0,5,"    ")
		o.text(5,6,"                     ")

	if frame==600:
		o.text(0,11,"And from small seeds...")
	if frame==1200:
		o.text(0,11,"                       ")

	cr=3
	if frame==docredits+cr*0:
		o.text(30, 2,"CRTC would love")
	if frame==docredits+cr*10:
		o.text(30, 3,"to send massive")
	if frame==docredits+cr*20:
		o.text(30, 4,"greetings to:  ")
	if frame==docredits+cr*30:
		o.text(30, 6,"RC55 --- for an")
	if frame==docredits+cr*40:
		o.text(30, 7," awesome party!")
	if frame==docredits+cr*50:
		o.text(30, 9,"dotwaffle      ")
	if frame==docredits+cr*60:
		o.text(30,10,"danbee         ")
		o.text(30, 2,"               ")
	if frame==docredits+cr*70:
		o.text(30,11,"m0d            ")
		o.text(30, 3,"               ")
	if frame==docredits+cr*80:
		o.text(30, 2,"h0ffman        ")
		o.text(30, 4,"               ")
	if frame==docredits+cr*90:
		o.text(30, 3,"SaVannaH       ")
		o.text(30, 5,"               ")
	if frame==docredits+cr*100:
		o.text(30, 4,"gasman         ")
		o.text(30, 6,"               ")
	if frame==docredits+cr*110:
		o.text(30, 5,"optimus        ")
		o.text(30, 7,"               ")
	if frame==docredits+cr*120:
		o.text(30, 6,"psonice        ")
		o.text(30, 8,"               ")
	if frame==docredits+cr*130:
		o.text(30, 7,"stavs          ")
		o.text(30, 9,"               ")
	if frame==docredits+cr*140:
		o.text(30, 8,"LNX            ")
		o.text(30,10,"               ")
	if frame==docredits+cr*150:
		o.text(30, 9,"subi           ")
		o.text(30,11,"               ")
	if frame==docredits+cr*160:
		o.text(30,10,"alegend45      ")
		o.text(30, 2,"               ")
	if frame==docredits+cr*170:
		o.text(30,11,"mr_lou         ")
		o.text(30, 3,"               ")
	if frame==docredits+cr*180:
		o.text(30, 2,"cgi            ")
		o.text(30, 4,"               ")
	if frame==docredits+cr*190:
		o.text(30, 3,"evilpaul       ")
		o.text(30, 5,"               ")
	if frame==docredits+cr*200:
		o.text(30, 4,"DFox           ")
		o.text(30, 6,"               ")
	if frame==docredits+cr*210:
		o.text(30, 5,"ne7            ")
		o.text(30, 7,"               ")
	if frame==docredits+cr*220:
		o.text(30, 6,"kris           ")
		o.text(30, 8,"               ")
	if frame==docredits+cr*230:
		o.text(30, 7,"topy44         ")
		o.text(30, 9,"               ")
	if frame==docredits+cr*240:
		o.text(30, 8,"zeb            ")
		o.text(30,10,"               ")
	if frame==docredits+cr*250:
		o.text(30, 9,"fell           ")
		o.text(30,11,"               ")
	if frame==docredits+cr*260:
		o.text(30, 2,"               ")
	if frame==docredits+cr*270:
		o.text(30,11,"all at cpcwiki ")
		o.text(30, 3,"               ")
	if frame==docredits+cr*280:
		o.text(30, 4,"               ")
	if frame==docredits+cr*290:
		o.text(30, 5,"               ")
	if frame==docredits+cr*300:
		o.text(30, 6,"               ")
	if frame==docredits+cr*310:
		o.text(30, 7,"               ")
	if frame==docredits+cr*320:
		o.text(30, 8,"               ")
	if frame==docredits+cr*330:
		o.text(30, 9,"               ")
	if frame==docredits+cr*340:
		o.text(30,10,"               ")
	if frame==docredits+cr*350:
		o.text(30,11,"               ")

	o.frame(frame)
	h.update()

o.close()
sys.exit(0)



h.drawadd(15)
f=ffern(h)
#t=ftree(h)
#f=ffloor(h)
#m=fman(h, -200)
h.update()
o.dumpasm(asmfile)
o.frame(1)

for frame in xrange(2,60*100):
	sys.stderr.write("Frame%6d  \r"%frame)
	if False:
		if frame==270:
			m.scrolling = False
			m.animating = False
		if frame==350:
			m.animating = True
			f.scrolling = True
			t.scrolling = True
		if frame==700:
			t.remove()
	o.frame(frame)
	h.update()

o.close()
sys.exit(0)
