/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.util.AnimatorBase;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class PGL {
    protected static final int AWT = 0;
    protected static final int NEWT = 1;
    protected static final int SIZEOF_SHORT = 2;
    protected static final int SIZEOF_INT = 4;
    protected static final int SIZEOF_FLOAT = 4;
    protected static final int SIZEOF_BYTE = 1;
    protected static final int SIZEOF_INDEX = 2;
    protected static final int INDEX_TYPE = 5123;
    protected static final int DEFAULT_IN_VERTICES = 64;
    protected static final int DEFAULT_IN_EDGES = 128;
    protected static final int DEFAULT_IN_TEXTURES = 64;
    protected static final int DEFAULT_TESS_VERTICES = 64;
    protected static final int DEFAULT_TESS_INDICES = 128;
    protected static final int MAX_LIGHTS = 8;
    protected static final int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    protected static final int MAX_VERTEX_INDEX1 = 32768;
    protected static final int FLUSH_VERTEX_COUNT = 32768;
    protected static final int MAX_FONT_TEX_SIZE = 1024;
    protected static final float MIN_CAPS_JOINS_WEIGHT = 2.0f;
    protected static final int MAX_CAPS_JOINS_LENGTH = 5000;
    protected static final int MIN_ARRAYCOPY_SIZE = 2;
    protected static final boolean MIPMAPS_ENABLED = true;
    protected static float FLOAT_EPS = Float.MIN_VALUE;
    protected static boolean BIG_ENDIAN;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int LESS = 513;
    public static final int LEQUAL = 515;
    public static final int CCW = 2305;
    public static final int CW = 2304;
    public static final int CULL_FACE = 2884;
    public static final int FRONT = 1028;
    public static final int BACK = 1029;
    public static final int FRONT_AND_BACK = 1032;
    public static final int VIEWPORT = 2978;
    public static final int SCISSOR_TEST = 3089;
    public static final int DEPTH_TEST = 2929;
    public static final int DEPTH_WRITEMASK = 2930;
    public static final int COLOR_BUFFER_BIT = 16384;
    public static final int DEPTH_BUFFER_BIT = 256;
    public static final int STENCIL_BUFFER_BIT = 1024;
    public static final int FUNC_ADD = 32774;
    public static final int FUNC_MIN = 32775;
    public static final int FUNC_MAX = 32776;
    public static final int FUNC_REVERSE_SUBTRACT = 32779;
    public static final int TEXTURE_2D = 3553;
    public static final int TEXTURE_RECTANGLE = 34037;
    public static final int TEXTURE_BINDING_2D = 32873;
    public static final int TEXTURE_BINDING_RECTANGLE = 34038;
    public static final int RGB = 6407;
    public static final int RGBA = 6408;
    public static final int ALPHA = 6406;
    public static final int UNSIGNED_INT = 5125;
    public static final int UNSIGNED_BYTE = 5121;
    public static final int UNSIGNED_SHORT = 5123;
    public static final int FLOAT = 5126;
    public static final int NEAREST = 9728;
    public static final int LINEAR = 9729;
    public static final int LINEAR_MIPMAP_NEAREST = 9985;
    public static final int LINEAR_MIPMAP_LINEAR = 9987;
    public static final int TEXTURE_MAX_ANISOTROPY = 34046;
    public static final int MAX_TEXTURE_MAX_ANISOTROPY = 34047;
    public static final int CLAMP_TO_EDGE = 33071;
    public static final int REPEAT = 10497;
    public static final int RGBA8 = 32856;
    public static final int DEPTH24_STENCIL8 = 35056;
    public static final int DEPTH_COMPONENT = 6402;
    public static final int DEPTH_COMPONENT16 = 33189;
    public static final int DEPTH_COMPONENT24 = 33190;
    public static final int DEPTH_COMPONENT32 = 33191;
    public static final int STENCIL_INDEX = 6401;
    public static final int STENCIL_INDEX1 = 36166;
    public static final int STENCIL_INDEX4 = 36167;
    public static final int STENCIL_INDEX8 = 36168;
    public static final int ARRAY_BUFFER = 34962;
    public static final int ELEMENT_ARRAY_BUFFER = 34963;
    public static final int SAMPLES = 32937;
    public static final int FRAMEBUFFER_COMPLETE = 36053;
    public static final int FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
    public static final int FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
    public static final int FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
    public static final int FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int STATIC_DRAW = 35044;
    public static final int DYNAMIC_DRAW = 35048;
    public static final int STREAM_DRAW = 35040;
    public static final int READ_ONLY = 35000;
    public static final int WRITE_ONLY = 35001;
    public static final int READ_WRITE = 35002;
    public static final int TRIANGLE_FAN = 6;
    public static final int TRIANGLE_STRIP = 5;
    public static final int TRIANGLES = 4;
    public static final int VENDOR = 7936;
    public static final int RENDERER = 7937;
    public static final int VERSION = 7938;
    public static final int EXTENSIONS = 7939;
    public static final int SHADING_LANGUAGE_VERSION = 35724;
    public static final int MAX_TEXTURE_SIZE = 3379;
    public static final int MAX_SAMPLES = 36183;
    public static final int ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int DEPTH_BITS = 3414;
    public static final int STENCIL_BITS = 3415;
    public static final int TESS_WINDING_NONZERO = 100131;
    public static final int TESS_WINDING_ODD = 100130;
    public static final int TEXTURE0 = 33984;
    public static final int TEXTURE1 = 33985;
    public static final int TEXTURE2 = 33986;
    public static final int TEXTURE3 = 33987;
    public static final int TEXTURE_MIN_FILTER = 10241;
    public static final int TEXTURE_MAG_FILTER = 10240;
    public static final int TEXTURE_WRAP_S = 10242;
    public static final int TEXTURE_WRAP_T = 10243;
    public static final int BLEND = 3042;
    public static final int ONE = 1;
    public static final int ZERO = 0;
    public static final int SRC_ALPHA = 770;
    public static final int DST_ALPHA = 772;
    public static final int ONE_MINUS_SRC_ALPHA = 771;
    public static final int ONE_MINUS_DST_COLOR = 775;
    public static final int ONE_MINUS_SRC_COLOR = 769;
    public static final int DST_COLOR = 774;
    public static final int SRC_COLOR = 768;
    public static final int FRAMEBUFFER = 36160;
    public static final int COLOR_ATTACHMENT0 = 36064;
    public static final int COLOR_ATTACHMENT1 = 36065;
    public static final int COLOR_ATTACHMENT2 = 36066;
    public static final int COLOR_ATTACHMENT3 = 36067;
    public static final int RENDERBUFFER = 36161;
    public static final int DEPTH_ATTACHMENT = 36096;
    public static final int STENCIL_ATTACHMENT = 36128;
    public static final int READ_FRAMEBUFFER = 36008;
    public static final int DRAW_FRAMEBUFFER = 36009;
    public static final int VERTEX_SHADER = 35633;
    public static final int FRAGMENT_SHADER = 35632;
    public static final int INFO_LOG_LENGTH = 35716;
    public static final int SHADER_SOURCE_LENGTH = 35720;
    public static final int COMPILE_STATUS = 35713;
    public static final int LINK_STATUS = 35714;
    public static final int VALIDATE_STATUS = 35715;
    public static final int MULTISAMPLE = 32925;
    public static final int POINT_SMOOTH = 2832;
    public static final int LINE_SMOOTH = 2848;
    public static final int POLYGON_SMOOTH = 2881;
    public static GL gl;
    public static GLU glu;
    public static GLContext context;
    public static Canvas canvas;
    public static GLProfile profile;
    protected static GLCapabilitiesImmutable capabilities;
    protected static GLDrawable drawable;
    protected static GL2ES2 gl2;
    protected static GL2 gl2x;
    protected PGraphicsOpenGL pg;
    protected boolean initialized;
    protected boolean firstFrame;
    protected static int toolkit;
    protected static boolean useAnimator;
    protected static boolean enable_screen_FBO_macosx;
    protected static boolean enable_screen_FBO_windows;
    protected static boolean enable_screen_FBO_linux;
    protected static boolean enable_screen_FBO_other;
    protected static int request_depth_bits;
    protected static int request_stencil_bits;
    protected static int request_alpha_bits;
    protected static GLCanvas canvasAWT;
    protected static NewtCanvasAWT canvasNEWT;
    protected static GLWindow window;
    protected static PGLListener listener;
    protected static PGLAnimator animator;
    protected float targetFramerate = 60.0f;
    protected boolean setFramerate = false;
    protected static boolean[] texturingTargets;
    protected static int[] boundTextures;
    protected static FBObject backFBO;
    protected static FBObject sinkFBO;
    protected static FBObject frontFBO;
    protected static FBObject.TextureAttachment backTex;
    protected static FBObject.TextureAttachment frontTex;
    protected static boolean loadedTex2DShader;
    protected static int tex2DShaderProgram;
    protected static int tex2DVertShader;
    protected static int tex2DFragShader;
    protected static GLContext tex2DShaderContext;
    protected static int tex2DVertLoc;
    protected static int tex2DTCoordLoc;
    protected static boolean loadedTexRectShader;
    protected static int texRectShaderProgram;
    protected static int texRectVertShader;
    protected static int texRectFragShader;
    protected static GLContext texRectShaderContext;
    protected static int texRectVertLoc;
    protected static int texRectTCoordLoc;
    protected static float[] texCoords;
    protected static FloatBuffer texData;
    protected static String texVertShaderSource;
    protected static String tex2DFragShaderSource;
    protected static String texRectFragShaderSource;
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;

    public PGL(PGraphicsOpenGL pg) {
        this.pg = pg;
        if (glu == null) {
            glu = new GLU();
        }
        this.initialized = false;
    }

    protected void setFrameRate(float framerate) {
        if (this.targetFramerate != framerate) {
            if (60.0f < framerate) {
                gl.setSwapInterval(0);
            } else if (30.0f < framerate) {
                gl.setSwapInterval(1);
            } else {
                gl.setSwapInterval(2);
            }
            if (60.0f < framerate && this.targetFramerate <= 60.0f || framerate <= 60.0f && 60.0f < this.targetFramerate) {
                this.initialized = false;
            }
            this.targetFramerate = framerate;
            this.setFramerate = true;
        }
    }

    protected void initSurface(int antialias) {
        if (profile == null) {
            profile = GLProfile.getDefault();
        } else {
            if (canvasAWT != null) {
                if (useAnimator) {
                    animator.stop();
                    animator.remove((GLAutoDrawable)canvasAWT);
                }
                canvasAWT.removeGLEventListener((GLEventListener)listener);
                this.pg.parent.removeListeners((Component)canvasAWT);
                this.pg.parent.remove((Component)canvasAWT);
            } else if (canvasNEWT != null) {
                if (useAnimator) {
                    animator.stop();
                    animator.remove((GLAutoDrawable)window);
                }
                window.removeGLEventListener((GLEventListener)listener);
                this.pg.parent.remove((Component)canvasNEWT);
            }
            frontFBO = null;
            backFBO = null;
            sinkFBO = null;
            this.setFramerate = false;
        }
        GLCapabilities caps = new GLCapabilities(profile);
        if (1 < antialias) {
            caps.setSampleBuffers(true);
            caps.setNumSamples(antialias);
        } else {
            caps.setSampleBuffers(false);
        }
        if (PApplet.platform == 2) {
            caps.setFBO(enable_screen_FBO_macosx);
        } else if (PApplet.platform == 1) {
            caps.setFBO(enable_screen_FBO_windows);
        } else if (PApplet.platform == 3) {
            caps.setFBO(enable_screen_FBO_linux);
        } else {
            caps.setFBO(enable_screen_FBO_other);
        }
        caps.setDepthBits(request_depth_bits);
        caps.setStencilBits(request_stencil_bits);
        caps.setAlphaBits(request_alpha_bits);
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        if (toolkit == 0) {
            canvasAWT = new GLCanvas((GLCapabilitiesImmutable)caps);
            canvasAWT.setBounds(0, 0, this.pg.width, this.pg.height);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)canvasAWT, "Center");
            this.pg.parent.removeListeners(this.pg.parent);
            this.pg.parent.addListeners((Component)canvasAWT);
            capabilities = canvasAWT.getChosenGLCapabilities();
            canvas = canvasAWT;
            canvasNEWT = null;
            listener = new PGLListener();
            canvasAWT.addGLEventListener((GLEventListener)listener);
            if (useAnimator) {
                animator = new PGLAnimator((GLAutoDrawable)canvasAWT);
                animator.start();
            }
        } else if (toolkit == 1) {
            window = GLWindow.create((GLCapabilitiesImmutable)caps);
            canvasNEWT = new NewtCanvasAWT((Window)window);
            canvasNEWT.setBounds(0, 0, this.pg.width, this.pg.height);
            canvasNEWT.setBackground(Color.GRAY);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)canvasNEWT, "Center");
            NEWTMouseAdapter mouseListener = new NEWTMouseAdapter();
            window.addMouseListener((MouseListener)mouseListener);
            NEWTKeyAdapter keyListener = new NEWTKeyAdapter();
            window.addKeyListener((KeyListener)keyListener);
            capabilities = window.getChosenGLCapabilities();
            canvas = canvasNEWT;
            canvasAWT = null;
            listener = new PGLListener();
            window.addGLEventListener((GLEventListener)listener);
            if (useAnimator) {
                animator = new PGLAnimator((GLAutoDrawable)window);
                animator.start();
            }
        }
        this.firstFrame = true;
        this.initialized = true;
    }

    protected void update() {
        if (!this.setFramerate) {
            this.setFrameRate(this.targetFramerate);
        }
    }

    protected int getReadFramebuffer() {
        if (capabilities.isFBO()) {
            return context.getDefaultReadFramebuffer();
        }
        return 0;
    }

    protected int getDrawFramebuffer() {
        if (capabilities.isFBO()) {
            return context.getDefaultDrawFramebuffer();
        }
        return 0;
    }

    protected int getDefaultDrawBuffer() {
        if (capabilities.isFBO()) {
            return 36064;
        }
        if (capabilities.getDoubleBuffered()) {
            return 1029;
        }
        return 1028;
    }

    protected int getDefaultReadBuffer() {
        if (capabilities.isFBO()) {
            return 36064;
        }
        if (capabilities.getDoubleBuffered()) {
            return 1029;
        }
        return 1028;
    }

    protected boolean isFBOBacked() {
        return capabilities.isFBO();
    }

    protected boolean isMultisampled() {
        return 0 < capabilities.getNumSamples();
    }

    protected int getDepthBits() {
        return capabilities.getDepthBits();
    }

    protected int getStencilBits() {
        return capabilities.getStencilBits();
    }

    protected Texture wrapBackTexture() {
        Texture tex = new Texture(this.pg.parent);
        tex.init(backTex.getName(), 3553, 6408, backTex.getWidth(), backTex.getHeight(), PGL.backTex.minFilter, PGL.backTex.magFilter, PGL.backTex.wrapS, PGL.backTex.wrapT);
        tex.invertedY(true);
        tex.colorBufferOf(this.pg);
        this.pg.setCache(this.pg, tex);
        return tex;
    }

    protected Texture wrapFrontTexture() {
        Texture tex = new Texture(this.pg.parent);
        tex.init(backTex.getName(), 3553, 6408, frontTex.getWidth(), frontTex.getHeight(), PGL.frontTex.minFilter, PGL.frontTex.magFilter, PGL.frontTex.wrapS, PGL.frontTex.wrapT);
        tex.invertedY(true);
        tex.colorBufferOf(this.pg);
        return tex;
    }

    int getBackTextureName() {
        return backTex.getName();
    }

    int getFrontTextureName() {
        return frontTex.getName();
    }

    protected void bindFrontTexture() {
        if (!this.texturingIsEnabled(3553)) {
            this.enableTexturing(3553);
        }
        gl.glBindTexture(3553, frontTex.getName());
    }

    protected void unbindFrontTexture() {
        if (this.textureIsBound(3553, frontTex.getName())) {
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                gl.glBindTexture(3553, 0);
                this.disableTexturing(3553);
            } else {
                gl.glBindTexture(3553, 0);
            }
        }
    }

    protected void syncBackTexture() {
        if (0 < capabilities.getNumSamples()) {
            backFBO.syncSamplingSink(gl);
            backFBO.bind(gl);
        }
    }

    protected int qualityToSamples(int quality) {
        if (quality <= 1) {
            return 1;
        }
        int n = 2 * (quality / 2);
        return n;
    }

    protected void beginDraw(boolean clear0) {
    }

    protected void endDraw(boolean clear) {
        if (!clear && this.isFBOBacked() && !this.isMultisampled()) {
            frontFBO.bind(gl);
            gl.glDisable(3042);
            this.drawTexture(3553, backTex.getName(), backTex.getWidth(), backTex.getHeight(), 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            backFBO.bind(gl);
        }
    }

    protected boolean canDraw() {
        return this.initialized && this.pg.parent.isDisplayable();
    }

    protected void requestDraw() {
        if (this.initialized) {
            try {
                if (useAnimator) {
                    animator.requestDisplay();
                } else if (toolkit == 0) {
                    canvasAWT.display();
                } else if (toolkit == 1) {
                    window.display();
                }
            }
            catch (GLException e) {
                Throwable tr = e.getCause();
                if (tr instanceof RuntimeException) {
                    throw (RuntimeException)tr;
                }
                throw new RuntimeException(tr);
            }
        }
    }

    public String getString(int name) {
        return gl.glGetString(name);
    }

    public void getIntegerv(int name, int[] values, int offset) {
        gl.glGetIntegerv(name, values, offset);
    }

    public void getFloatv(int name, float[] values, int offset) {
        gl.glGetFloatv(name, values, offset);
    }

    public void getBooleanv(int name, boolean[] values, int offset) {
        if (-1 < name) {
            byte[] bvalues = new byte[values.length];
            gl.glGetBooleanv(name, bvalues, offset);
            for (int i = 0; i < values.length; ++i) {
                values[i] = bvalues[i] != 0;
            }
        } else {
            Arrays.fill(values, false);
        }
    }

    public void enable(int cap) {
        if (-1 < cap) {
            gl.glEnable(cap);
        }
    }

    public void disable(int cap) {
        if (-1 < cap) {
            gl.glDisable(cap);
        }
    }

    public void flush() {
        gl.glFlush();
    }

    public void finish() {
        gl.glFinish();
    }

    public int getError() {
        return gl.glGetError();
    }

    public String errorString(int err) {
        return glu.gluErrorString(err);
    }

    public void frontFace(int mode) {
        gl.glFrontFace(mode);
    }

    public void cullFace(int mode) {
        gl.glCullFace(mode);
    }

    public void depthMask(boolean flag) {
        gl.glDepthMask(flag);
    }

    public void depthFunc(int func) {
        gl.glDepthFunc(func);
    }

    public void genTextures(int n, int[] ids, int offset) {
        gl.glGenTextures(n, ids, offset);
    }

    public void deleteTextures(int n, int[] ids, int offset) {
        gl.glDeleteTextures(n, ids, offset);
    }

    public void activeTexture(int unit) {
        gl.glActiveTexture(unit);
    }

    public void bindTexture(int target, int id) {
        gl.glBindTexture(target, id);
        if (target == 3553) {
            PGL.boundTextures[0] = id;
        } else if (target == 34037) {
            PGL.boundTextures[1] = id;
        }
    }

    public void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data) {
        gl.glTexImage2D(target, level, internalFormat, width, height, border, format, type, data);
    }

    public void texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, Buffer data) {
        gl.glTexSubImage2D(target, level, xOffset, yOffset, width, height, format, type, data);
    }

    public void texParameteri(int target, int param, int value) {
        gl.glTexParameteri(target, param, value);
    }

    public void texParameterf(int target, int param, float value) {
        gl.glTexParameterf(target, param, value);
    }

    public void getTexParameteriv(int target, int param, int[] values, int offset) {
        gl.glGetTexParameteriv(target, param, values, offset);
    }

    public void generateMipmap(int target) {
        gl.glGenerateMipmap(target);
    }

    public void genBuffers(int n, int[] ids, int offset) {
        gl.glGenBuffers(n, ids, offset);
    }

    public void deleteBuffers(int n, int[] ids, int offset) {
        gl.glDeleteBuffers(n, ids, offset);
    }

    public void bindBuffer(int target, int id) {
        gl.glBindBuffer(target, id);
    }

    public void bufferData(int target, int size, Buffer data, int usage) {
        gl.glBufferData(target, (long)size, data, usage);
    }

    public void bufferSubData(int target, int offset, int size, Buffer data) {
        gl.glBufferSubData(target, (long)offset, (long)size, data);
    }

    public void drawArrays(int mode, int first, int count) {
        gl.glDrawArrays(mode, first, count);
    }

    public void drawElements(int mode, int count, int type, int offset) {
        gl.glDrawElements(mode, count, type, (long)offset);
    }

    public void enableVertexAttribArray(int loc) {
        gl2.glEnableVertexAttribArray(loc);
    }

    public void disableVertexAttribArray(int loc) {
        gl2.glDisableVertexAttribArray(loc);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, int offset) {
        gl2.glVertexAttribPointer(loc, size, type, normalized, stride, (long)offset);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, Buffer data) {
        gl2.glVertexAttribPointer(loc, size, type, normalized, stride, data);
    }

    public ByteBuffer mapBuffer(int target, int access) {
        return gl2.glMapBuffer(target, access);
    }

    public ByteBuffer mapBufferRange(int target, int offset, int length, int access) {
        if (gl2x != null) {
            return gl2x.glMapBufferRange(target, (long)offset, (long)length, access);
        }
        return null;
    }

    public void unmapBuffer(int target) {
        gl2.glUnmapBuffer(target);
    }

    public void genFramebuffers(int n, int[] ids, int offset) {
        gl.glGenFramebuffers(n, ids, offset);
    }

    public void deleteFramebuffers(int n, int[] ids, int offset) {
        gl.glDeleteFramebuffers(n, ids, offset);
    }

    public void genRenderbuffers(int n, int[] ids, int offset) {
        gl.glGenRenderbuffers(n, ids, offset);
    }

    public void deleteRenderbuffers(int n, int[] ids, int offset) {
        gl.glDeleteRenderbuffers(n, ids, offset);
    }

    public void bindFramebuffer(int target, int id) {
        gl.glBindFramebuffer(target, id);
    }

    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        if (gl2x != null) {
            gl2x.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        }
    }

    public void framebufferTexture2D(int target, int attachment, int texTarget, int texId, int level) {
        gl.glFramebufferTexture2D(target, attachment, texTarget, texId, level);
    }

    public void bindRenderbuffer(int target, int id) {
        gl.glBindRenderbuffer(target, id);
    }

    public void renderbufferStorageMultisample(int target, int samples, int format, int width, int height) {
        if (gl2x != null) {
            gl2x.glRenderbufferStorageMultisample(target, samples, format, width, height);
        }
    }

    public void renderbufferStorage(int target, int format, int width, int height) {
        gl.glRenderbufferStorage(target, format, width, height);
    }

    public void framebufferRenderbuffer(int target, int attachment, int rendbufTarget, int rendbufId) {
        gl.glFramebufferRenderbuffer(target, attachment, rendbufTarget, rendbufId);
    }

    public int checkFramebufferStatus(int target) {
        return gl.glCheckFramebufferStatus(target);
    }

    public int createProgram() {
        return gl2.glCreateProgram();
    }

    public void deleteProgram(int id) {
        gl2.glDeleteProgram(id);
    }

    public int createShader(int type) {
        return gl2.glCreateShader(type);
    }

    public void deleteShader(int id) {
        gl2.glDeleteShader(id);
    }

    public void linkProgram(int prog) {
        gl2.glLinkProgram(prog);
    }

    public void validateProgram(int prog) {
        gl2.glValidateProgram(prog);
    }

    public void useProgram(int prog) {
        gl2.glUseProgram(prog);
    }

    public int getAttribLocation(int prog, String name) {
        return gl2.glGetAttribLocation(prog, name);
    }

    public int getUniformLocation(int prog, String name) {
        return gl2.glGetUniformLocation(prog, name);
    }

    public void uniform1i(int loc, int value) {
        gl2.glUniform1i(loc, value);
    }

    public void uniform2i(int loc, int value0, int value1) {
        gl2.glUniform2i(loc, value0, value1);
    }

    public void uniform3i(int loc, int value0, int value1, int value2) {
        gl2.glUniform3i(loc, value0, value1, value2);
    }

    public void uniform4i(int loc, int value0, int value1, int value2, int value3) {
        gl2.glUniform4i(loc, value0, value1, value2, value3);
    }

    public void uniform1f(int loc, float value) {
        gl2.glUniform1f(loc, value);
    }

    public void uniform2f(int loc, float value0, float value1) {
        gl2.glUniform2f(loc, value0, value1);
    }

    public void uniform3f(int loc, float value0, float value1, float value2) {
        gl2.glUniform3f(loc, value0, value1, value2);
    }

    public void uniform4f(int loc, float value0, float value1, float value2, float value3) {
        gl2.glUniform4f(loc, value0, value1, value2, value3);
    }

    public void uniform1iv(int loc, int count, int[] v, int offset) {
        gl2.glUniform1iv(loc, count, v, offset);
    }

    public void uniform2iv(int loc, int count, int[] v, int offset) {
        gl2.glUniform2iv(loc, count, v, offset);
    }

    public void uniform3iv(int loc, int count, int[] v, int offset) {
        gl2.glUniform3iv(loc, count, v, offset);
    }

    public void uniform4iv(int loc, int count, int[] v, int offset) {
        gl2.glUniform4iv(loc, count, v, offset);
    }

    public void uniform1fv(int loc, int count, float[] v, int offset) {
        gl2.glUniform1fv(loc, count, v, offset);
    }

    public void uniform2fv(int loc, int count, float[] v, int offset) {
        gl2.glUniform2fv(loc, count, v, offset);
    }

    public void uniform3fv(int loc, int count, float[] v, int offset) {
        gl2.glUniform3fv(loc, count, v, offset);
    }

    public void uniform4fv(int loc, int count, float[] v, int offset) {
        gl2.glUniform4fv(loc, count, v, offset);
    }

    public void uniformMatrix2fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        gl2.glUniformMatrix2fv(loc, count, transpose, mat, offset);
    }

    public void uniformMatrix3fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        gl2.glUniformMatrix3fv(loc, count, transpose, mat, offset);
    }

    public void uniformMatrix4fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        gl2.glUniformMatrix4fv(loc, count, transpose, mat, offset);
    }

    public void vertexAttrib1f(int loc, float value) {
        gl2.glVertexAttrib1f(loc, value);
    }

    public void vertexAttrib2f(int loc, float value0, float value1) {
        gl2.glVertexAttrib2f(loc, value0, value1);
    }

    public void vertexAttrib3f(int loc, float value0, float value1, float value2) {
        gl2.glVertexAttrib3f(loc, value0, value1, value2);
    }

    public void vertexAttrib4f(int loc, float value0, float value1, float value2, float value3) {
        gl2.glVertexAttrib4f(loc, value0, value1, value2, value3);
    }

    public void vertexAttrib1fv(int loc, float[] v, int offset) {
        gl2.glVertexAttrib1fv(loc, v, offset);
    }

    public void vertexAttrib2fv(int loc, float[] v, int offset) {
        gl2.glVertexAttrib2fv(loc, v, offset);
    }

    public void vertexAttrib3fv(int loc, float[] v, int offset) {
        gl2.glVertexAttrib3fv(loc, v, offset);
    }

    public void vertexAttrib4fv(int loc, float[] v, int offset) {
        gl2.glVertexAttrib4fv(loc, v, offset);
    }

    public void shaderSource(int id, String source) {
        gl2.glShaderSource(id, 1, new String[]{source}, (int[])null, 0);
    }

    public void compileShader(int id) {
        gl2.glCompileShader(id);
    }

    public void attachShader(int prog, int shader) {
        gl2.glAttachShader(prog, shader);
    }

    public void getShaderiv(int shader, int pname, int[] params, int offset) {
        gl2.glGetShaderiv(shader, pname, params, offset);
    }

    public String getShaderInfoLog(int shader) {
        int[] val = new int[]{0};
        gl2.glGetShaderiv(shader, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        gl2.glGetShaderInfoLog(shader, length, val, 0, log, 0);
        return new String(log);
    }

    public void getProgramiv(int prog, int pname, int[] params, int offset) {
        gl2.glGetProgramiv(prog, pname, params, offset);
    }

    public String getProgramInfoLog(int prog) {
        int[] val = new int[]{0};
        gl2.glGetShaderiv(prog, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        gl2.glGetProgramInfoLog(prog, length, val, 0, log, 0);
        return new String(log);
    }

    public void viewport(int x, int y, int width, int height) {
        gl.glViewport(x, y, width, height);
    }

    public void scissor(int x, int y, int w, int h) {
        gl.glScissor(x, y, w, h);
    }

    public void blendEquation(int eq) {
        gl.glBlendEquation(eq);
    }

    public void blendFunc(int srcFactor, int dstFactor) {
        gl.glBlendFunc(srcFactor, dstFactor);
    }

    public void readBuffer(int buf) {
        if (gl2x != null) {
            gl2x.glReadBuffer(buf);
        }
    }

    public void readPixels(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        gl.glReadPixels(x, y, width, height, format, type, buffer);
    }

    public void drawBuffer(int buf) {
        if (gl2x != null) {
            gl2x.glDrawBuffer(buf);
        }
    }

    public void clearDepth(float d) {
        gl.glClearDepthf(d);
    }

    public void clearStencil(int s) {
        gl.glClearStencil(s);
    }

    public void colorMask(boolean wr, boolean wg, boolean wb, boolean wa) {
        gl.glColorMask(wr, wg, wb, wa);
    }

    public void clearColor(float r, float g, float b, float a) {
        gl.glClearColor(r, g, b, a);
    }

    public void clear(int mask) {
        gl.glClear(mask);
    }

    protected Context createEmptyContext() {
        return new Context();
    }

    protected Context getCurrentContext() {
        return new Context(context);
    }

    protected Tessellator createTessellator(TessellatorCallback callback) {
        return new Tessellator(callback);
    }

    protected String tessError(int err) {
        return glu.gluErrorString(err);
    }

    protected boolean contextIsCurrent(Context other) {
        return other == null || other.current();
    }

    protected void enableTexturing(int target) {
        this.enable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = true;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = true;
        }
    }

    protected void disableTexturing(int target) {
        this.disable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = false;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = false;
        }
    }

    protected boolean texturingIsEnabled(int target) {
        if (target == 3553) {
            return texturingTargets[0];
        }
        if (target == 34037) {
            return texturingTargets[1];
        }
        return false;
    }

    protected boolean textureIsBound(int target, int id) {
        if (target == 3553) {
            return boundTextures[0] == id;
        }
        if (target == 34037) {
            return boundTextures[1] == id;
        }
        return false;
    }

    protected void initTexture(int target, int format, int width, int height) {
        int[] texels = new int[width * height];
        this.texSubImage2D(target, 0, 0, 0, width, height, format, 5121, IntBuffer.wrap(texels));
    }

    protected void copyToTexture(int target, int format, int id, int x, int y, int w, int h, IntBuffer buffer) {
        this.activeTexture(33984);
        boolean enabledTex = false;
        if (!this.texturingIsEnabled(target)) {
            this.enableTexturing(target);
            enabledTex = true;
        }
        this.bindTexture(target, id);
        this.texSubImage2D(target, 0, x, y, w, h, format, 5121, buffer);
        this.bindTexture(target, 0);
        if (enabledTex) {
            this.disableTexturing(target);
        }
    }

    protected void drawTexture(int target, int id, int width, int height, int X0, int Y0, int X1, int Y1) {
        this.drawTexture(target, id, width, height, X0, Y0, X1, Y1, X0, Y0, X1, Y1);
    }

    protected void drawTexture(int target, int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (target == 3553) {
            this.drawTexture2D(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        } else if (target == 34037) {
            this.drawTextureRect(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        }
    }

    protected void drawTexture2D(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!loadedTex2DShader || tex2DShaderContext.hashCode() != context.hashCode()) {
            tex2DVertShader = this.createShader(35633, texVertShaderSource);
            tex2DFragShader = this.createShader(35632, tex2DFragShaderSource);
            if (0 < tex2DVertShader && 0 < tex2DFragShader) {
                tex2DShaderProgram = this.createProgram(tex2DVertShader, tex2DFragShader);
            }
            if (0 < tex2DShaderProgram) {
                tex2DVertLoc = this.getAttribLocation(tex2DShaderProgram, "inVertex");
                tex2DTCoordLoc = this.getAttribLocation(tex2DShaderProgram, "inTexcoord");
            }
            loadedTex2DShader = true;
            tex2DShaderContext = context;
        }
        if (texData == null) {
            texData = PGL.allocateDirectFloatBuffer(texCoords.length);
        }
        if (0 < tex2DShaderProgram) {
            boolean[] depthTest = new boolean[1];
            this.getBooleanv(2929, depthTest, 0);
            this.disable(2929);
            boolean[] depthMask = new boolean[1];
            this.getBooleanv(2930, depthMask, 0);
            this.depthMask(false);
            this.useProgram(tex2DShaderProgram);
            this.enableVertexAttribArray(tex2DVertLoc);
            this.enableVertexAttribArray(tex2DTCoordLoc);
            PGL.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[2] = (float)texX0 / (float)width;
            PGL.texCoords[3] = (float)texY0 / (float)height;
            PGL.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[6] = (float)texX1 / (float)width;
            PGL.texCoords[7] = (float)texY0 / (float)height;
            PGL.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[10] = (float)texX0 / (float)width;
            PGL.texCoords[11] = (float)texY1 / (float)height;
            PGL.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[14] = (float)texX1 / (float)width;
            PGL.texCoords[15] = (float)texY1 / (float)height;
            texData.rewind();
            texData.put(texCoords);
            this.activeTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                enabledTex = true;
            }
            this.bindTexture(3553, id);
            this.bindBuffer(34962, 0);
            texData.position(0);
            this.vertexAttribPointer(tex2DVertLoc, 2, 5126, false, 16, texData);
            texData.position(2);
            this.vertexAttribPointer(tex2DTCoordLoc, 2, 5126, false, 16, texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(3553, 0);
            if (enabledTex) {
                this.disableTexturing(3553);
            }
            this.disableVertexAttribArray(tex2DVertLoc);
            this.disableVertexAttribArray(tex2DTCoordLoc);
            this.useProgram(0);
            if (depthTest[0]) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(depthMask[0]);
        }
    }

    protected void drawTextureRect(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!loadedTexRectShader || texRectShaderContext.hashCode() != context.hashCode()) {
            texRectVertShader = this.createShader(35633, texVertShaderSource);
            texRectFragShader = this.createShader(35632, texRectFragShaderSource);
            if (0 < texRectVertShader && 0 < texRectFragShader) {
                texRectShaderProgram = this.createProgram(texRectVertShader, texRectFragShader);
            }
            if (0 < texRectShaderProgram) {
                texRectVertLoc = this.getAttribLocation(texRectShaderProgram, "inVertex");
                texRectTCoordLoc = this.getAttribLocation(texRectShaderProgram, "inTexcoord");
            }
            loadedTexRectShader = true;
            texRectShaderContext = context;
        }
        if (texData == null) {
            texData = PGL.allocateDirectFloatBuffer(texCoords.length);
        }
        if (0 < texRectShaderProgram) {
            boolean[] depthTest = new boolean[1];
            this.getBooleanv(2929, depthTest, 0);
            this.disable(2929);
            boolean[] depthMask = new boolean[1];
            this.getBooleanv(2930, depthMask, 0);
            this.depthMask(false);
            this.useProgram(texRectShaderProgram);
            this.enableVertexAttribArray(texRectVertLoc);
            this.enableVertexAttribArray(texRectTCoordLoc);
            PGL.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[2] = texX0;
            PGL.texCoords[3] = texY0;
            PGL.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[6] = texX1;
            PGL.texCoords[7] = texY0;
            PGL.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[10] = texX0;
            PGL.texCoords[11] = texY1;
            PGL.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[14] = texX1;
            PGL.texCoords[15] = texY1;
            texData.rewind();
            texData.put(texCoords);
            this.activeTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(34037)) {
                this.enableTexturing(34037);
                enabledTex = true;
            }
            this.bindTexture(34037, id);
            this.bindBuffer(34962, 0);
            texData.position(0);
            this.vertexAttribPointer(texRectVertLoc, 2, 5126, false, 16, texData);
            texData.position(2);
            this.vertexAttribPointer(texRectTCoordLoc, 2, 5126, false, 16, texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(34037, 0);
            if (enabledTex) {
                this.disableTexturing(34037);
            }
            this.disableVertexAttribArray(texRectVertLoc);
            this.disableVertexAttribArray(texRectTCoordLoc);
            this.useProgram(0);
            if (depthTest[0]) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(depthMask[0]);
        }
    }

    protected int getColorValue(int scrX, int scrY) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6408, 5121, this.colorBuffer);
        return this.colorBuffer.get();
    }

    protected float getDepthValue(int scrX, int scrY) {
        if (this.depthBuffer == null) {
            this.depthBuffer = FloatBuffer.allocate(1);
        }
        this.depthBuffer.rewind();
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6402, 5126, this.depthBuffer);
        return this.depthBuffer.get(0);
    }

    protected byte getStencilValue(int scrX, int scrY) {
        if (this.stencilBuffer == null) {
            this.stencilBuffer = ByteBuffer.allocate(1);
        }
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6401, 5121, this.stencilBuffer);
        return this.stencilBuffer.get(0);
    }

    protected static int nextPowerOfTwo(int val) {
        int ret;
        for (ret = 1; ret < val; ret <<= 1) {
        }
        return ret;
    }

    protected static int nativeToJavaARGB(int color) {
        if (BIG_ENDIAN) {
            return color & 0xFF000000 | color >> 8 & 0xFFFFFF;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = temp & 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int nativeToJavaRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int javaToNativeARGB(int color) {
        if (BIG_ENDIAN) {
            return color >> 24 & 0xFF | color << 8 & 0xFFFFFF00;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] >> 24 & 0xFF | pixels[yindex] << 8 & 0xFFFFFF00;
                        pixels[yindex] = temp >> 24 & 0xFF | temp << 8 & 0xFFFFFF00;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = pixels[yindex] & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] >> 24 & 0xFF | pixels[index] << 8 & 0xFFFFFF00;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int javaToNativeRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                        pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected int createShader(int shaderType, String source) {
        int shader = this.createShader(shaderType);
        if (shader != 0) {
            this.shaderSource(shader, source);
            this.compileShader(shader);
            int[] compiled = new int[1];
            this.getShaderiv(shader, 35713, compiled, 0);
            if (compiled[0] == 0) {
                System.err.println("Could not compile shader " + shaderType + ":");
                System.err.println(this.getShaderInfoLog(shader));
                this.deleteShader(shader);
                shader = 0;
            }
        }
        return shader;
    }

    protected int createProgram(int vertexShader, int fragmentShader) {
        int program = this.createProgram();
        if (program != 0) {
            this.attachShader(program, vertexShader);
            this.attachShader(program, fragmentShader);
            this.linkProgram(program);
            int[] linked = new int[1];
            this.getProgramiv(program, 35714, linked, 0);
            if (linked[0] == 0) {
                System.err.println("Could not link program: ");
                System.err.println(this.getProgramInfoLog(program));
                this.deleteProgram(program);
                program = 0;
            }
        }
        return program;
    }

    protected boolean validateFramebuffer() {
        int status = this.checkFramebufferStatus(36160);
        if (status == 36053) {
            return true;
        }
        if (status == 36054) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36055) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36057) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36058) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_FORMATS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36061) {
            throw new RuntimeException("GL_FRAMEBUFFER_UNSUPPORTED" + Integer.toHexString(status));
        }
        throw new RuntimeException("unknown framebuffer error (" + Integer.toHexString(status) + ")");
    }

    protected static ByteBuffer allocateDirectByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 1).order(ByteOrder.nativeOrder());
    }

    protected static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    protected int[] getGLVersion() {
        String version = gl.glGetString(7938).trim();
        int[] res = new int[]{0, 0, 0};
        String[] parts = version.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            if (0 >= parts[i].indexOf(".")) continue;
            String[] nums = parts[i].split("\\.");
            try {
                res[0] = Integer.parseInt(nums[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (1 < nums.length) {
                try {
                    res[1] = Integer.parseInt(nums[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (2 >= nums.length) break;
            try {
                res[2] = Integer.parseInt(nums[2]);
            }
            catch (NumberFormatException e) {}
            break;
        }
        return res;
    }

    protected void nativeMouseEvent(MouseEvent nativeEvent, int peAction) {
        int modifiers = nativeEvent.getModifiers();
        int peModifiers = modifiers & 0xF;
        int peButton = 0;
        if ((modifiers & 0x20) != 0) {
            peButton = 37;
        } else if ((modifiers & 0x40) != 0) {
            peButton = 3;
        } else if ((modifiers & 0x80) != 0) {
            peButton = 39;
        }
        processing.event.MouseEvent me = new processing.event.MouseEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, nativeEvent.getX(), nativeEvent.getY(), peButton, nativeEvent.getClickCount());
        this.pg.parent.postEvent(me);
    }

    protected void nativeKeyEvent(KeyEvent nativeEvent, int peAction) {
        int peModifiers = nativeEvent.getModifiers() & 0xF;
        processing.event.KeyEvent ke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, nativeEvent.getKeyChar(), nativeEvent.getKeyCode());
        this.pg.parent.postEvent(ke);
    }

    static {
        float eps = 1.0f;
        while ((double)((float)(1.0 + (double)(eps /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = eps;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        toolkit = 1;
        useAnimator = false;
        enable_screen_FBO_macosx = true;
        enable_screen_FBO_windows = true;
        enable_screen_FBO_linux = true;
        enable_screen_FBO_other = true;
        request_depth_bits = 24;
        request_stencil_bits = 8;
        request_alpha_bits = 8;
        texturingTargets = new boolean[]{false, false};
        boundTextures = new int[]{0, 0};
        loadedTex2DShader = false;
        loadedTexRectShader = false;
        texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        texVertShaderSource = "attribute vec2 inVertex;attribute vec2 inTexcoord;varying vec2 vertTexcoord;void main() {  gl_Position = vec4(inVertex, 0, 1);  vertTexcoord = inTexcoord;}";
        tex2DFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2D textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2D(textureSampler, vertTexcoord.st);}";
        texRectFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2DRect textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2DRect(textureSampler, vertTexcoord.st);}";
    }

    protected static class PGLAnimator
    extends AnimatorBase {
        private static int count = 0;
        private Timer timer = null;
        private Task task = null;

        protected String getBaseName(String prefix) {
            return prefix + "PGLAnimator";
        }

        public PGLAnimator(GLAutoDrawable drawable) {
            if (drawable != null) {
                this.add(drawable);
            }
        }

        public void requestDisplay() {
            if (this.task != null) {
                this.task.shouldRun();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isStarted() {
            this.stateSync.lock();
            try {
                boolean bl = this.timer != null;
                return bl;
            }
            finally {
                this.stateSync.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isAnimating() {
            this.stateSync.lock();
            try {
                boolean bl = this.timer != null && this.task != null;
                return bl;
            }
            finally {
                this.stateSync.unlock();
            }
        }

        private void startTask() {
            if (null != this.task) {
                return;
            }
            this.task = new Task();
            this.fpsCounter.resetFPSCounter();
            this.timer.schedule((TimerTask)this.task, 0L, 1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean start() {
            if (this.timer != null) {
                return false;
            }
            this.stateSync.lock();
            try {
                this.timer = new Timer();
                this.startTask();
            }
            finally {
                this.stateSync.unlock();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean stop() {
            if (this.timer == null) {
                return false;
            }
            this.stateSync.lock();
            try {
                if (null != this.task) {
                    this.task.cancel();
                    this.task = null;
                }
                if (null != this.timer) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.animThread = null;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.stateSync.unlock();
            }
            return true;
        }

        public final boolean isPaused() {
            return false;
        }

        public synchronized boolean resume() {
            return false;
        }

        public synchronized boolean pause() {
            return false;
        }

        private class Task
        extends TimerTask {
            private boolean firstRun = true;
            private boolean shouldRun = false;

            private Task() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void shouldRun() {
                Task task = this;
                synchronized (task) {
                    this.shouldRun = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.firstRun) {
                    Thread.currentThread().setName("PGL-RenderQueue-" + count);
                    this.firstRun = false;
                    count++;
                }
                if (this.shouldRun) {
                    PGLAnimator.this.animThread = Thread.currentThread();
                    PGLAnimator.this.display();
                    Task task = this;
                    synchronized (task) {
                        this.shouldRun = false;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel() {
                Task task = this;
                synchronized (task) {
                    this.shouldRun = false;
                }
                return super.cancel();
            }
        }
    }

    class NEWTKeyAdapter
    extends KeyAdapter {
        NEWTKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            PGL.this.nativeKeyEvent(e, 1);
        }

        public void keyReleased(KeyEvent e) {
            PGL.this.nativeKeyEvent(e, 2);
        }

        public void keyTyped(KeyEvent e) {
            PGL.this.nativeKeyEvent(e, 3);
        }
    }

    class NEWTMouseAdapter
    extends MouseAdapter {
        NEWTMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 1);
        }

        public void mouseReleased(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 2);
        }

        public void mouseClicked(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 3);
        }

        public void mouseDragged(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 4);
        }

        public void mouseMoved(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 5);
        }

        public void mouseEntered(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 6);
        }

        public void mouseExited(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 7);
        }

        public void mouseWheelMoved(MouseEvent e) {
        }
    }

    protected class PGLListener
    implements GLEventListener {
        protected PGLListener() {
        }

        public void display(GLAutoDrawable glDrawable) {
            drawable = glDrawable;
            context = glDrawable.getContext();
            gl = context.getGL();
            gl2 = gl.getGL2ES2();
            try {
                gl2x = gl.getGL2();
            }
            catch (GLException e) {
                gl2x = null;
            }
            if (PGL.this.firstFrame) {
                gl.glClearDepthf(1.0f);
                gl.glClearStencil(0);
                gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gl.glClear(17664);
                PGL.this.firstFrame = false;
            }
            if (capabilities.isFBO()) {
                GLFBODrawable fboDrawable = null;
                if (toolkit == 0) {
                    GLCanvas glCanvas = (GLCanvas)glDrawable;
                    fboDrawable = (GLFBODrawable)glCanvas.getDelegatedDrawable();
                } else {
                    GLWindow glWindow = (GLWindow)glDrawable;
                    fboDrawable = (GLFBODrawable)glWindow.getDelegatedDrawable();
                }
                if (fboDrawable != null) {
                    backFBO = fboDrawable.getFBObject(1029);
                    if (0 < capabilities.getNumSamples()) {
                        if (frontFBO == null) {
                            frontFBO = new FBObject();
                            frontFBO.reset(gl, PGL.this.pg.width, PGL.this.pg.height);
                            frontFBO.attachTexture2D(gl, 0, true);
                            sinkFBO = backFBO.getSamplingSinkFBO();
                        } else {
                            FBObject temp = sinkFBO;
                            sinkFBO = frontFBO;
                            frontFBO = temp;
                            backFBO.setSamplingSink(sinkFBO);
                        }
                        backTex = (FBObject.TextureAttachment)sinkFBO.getColorbuffer(0);
                        frontTex = (FBObject.TextureAttachment)frontFBO.getColorbuffer(0);
                    } else {
                        frontFBO = fboDrawable.getFBObject(1028);
                        backTex = fboDrawable.getTextureBuffer(1029);
                        frontTex = fboDrawable.getTextureBuffer(1028);
                    }
                }
            }
            PGL.this.pg.parent.handleDraw();
        }

        public void dispose(GLAutoDrawable adrawable) {
        }

        public void init(GLAutoDrawable adrawable) {
            drawable = adrawable;
            context = adrawable.getContext();
            gl = context.getGL();
            String extensions = gl.glGetString(7939);
            if (-1 == extensions.indexOf("_framebuffer_object")) {
                throw new RuntimeException("No framebuffer objects available");
            }
            if (-1 == extensions.indexOf("_vertex_buffer_object")) {
                throw new RuntimeException("No vertex buffer objects available");
            }
            if (-1 == extensions.indexOf("_vertex_shader")) {
                throw new RuntimeException("No vertex shaders available");
            }
            if (-1 == extensions.indexOf("_fragment_shader")) {
                throw new RuntimeException("No fragment shaders available");
            }
        }

        public void reshape(GLAutoDrawable adrawable, int x, int y, int w, int h) {
            drawable = adrawable;
            context = adrawable.getContext();
        }
    }

    protected static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }

    protected class Tessellator {
        protected GLUtessellator tess;
        protected TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(TessellatorCallback callback) {
            this.callback = callback;
            this.tess = GLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100100, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100102, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100101, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100105, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100103, (GLUtessellatorCallback)this.gluCallback);
        }

        public void beginPolygon() {
            GLU.gluTessBeginPolygon((GLUtessellator)this.tess, null);
        }

        public void endPolygon() {
            GLU.gluTessEndPolygon((GLUtessellator)this.tess);
        }

        public void setWindingRule(int rule) {
            GLU.gluTessProperty((GLUtessellator)this.tess, (int)100140, (double)rule);
        }

        public void beginContour() {
            GLU.gluTessBeginContour((GLUtessellator)this.tess);
        }

        public void endContour() {
            GLU.gluTessEndContour((GLUtessellator)this.tess);
        }

        public void addVertex(double[] v) {
            GLU.gluTessVertex((GLUtessellator)this.tess, (double[])v, (int)0, (Object)v);
        }

        protected class GLUCallback
        extends GLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            public void begin(int type) {
                Tessellator.this.callback.begin(type);
            }

            public void end() {
                Tessellator.this.callback.end();
            }

            public void vertex(Object data) {
                Tessellator.this.callback.vertex(data);
            }

            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                Tessellator.this.callback.combine(coords, data, weight, outData);
            }

            public void error(int errnum) {
                Tessellator.this.callback.error(errnum);
            }
        }
    }

    protected class Context {
        protected int id;

        Context() {
            this.id = -1;
        }

        Context(GLContext context) {
            this.id = context != null ? context.hashCode() : -1;
        }

        boolean current() {
            return this.equal(context);
        }

        boolean equal(GLContext context) {
            if (this.id == -1 || context == null) {
                return true;
            }
            return this.id == context.hashCode();
        }

        int id() {
            return this.id;
        }
    }
}

