/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;

public class Outline
implements Cloneable,
Comparable<Outline> {
    private ArrayList<Vertex> vertices = new ArrayList(3);
    private boolean closed = false;
    private AABBox bbox = new AABBox();
    private boolean dirtyBBox = false;

    public final int getVertexCount() {
        return this.vertices.size();
    }

    public final void addVertex(Vertex vertex) throws NullPointerException {
        this.addVertex(this.vertices.size(), vertex);
    }

    public final void addVertex(int n, Vertex vertex) throws NullPointerException, IndexOutOfBoundsException {
        if (null == vertex) {
            throw new NullPointerException("vertex is null");
        }
        this.vertices.add(n, vertex);
        if (!this.dirtyBBox) {
            this.bbox.resize(vertex.getX(), vertex.getY(), vertex.getZ());
        }
    }

    public final void setVertex(int n, Vertex vertex) throws NullPointerException, IndexOutOfBoundsException {
        if (null == vertex) {
            throw new NullPointerException("vertex is null");
        }
        this.vertices.set(n, vertex);
        this.dirtyBBox = true;
    }

    public final Vertex getVertex(int n) {
        return this.vertices.get(n);
    }

    public int getVertexIndex(Vertex vertex) {
        return this.vertices.indexOf(vertex);
    }

    public final Vertex removeVertex(int n) throws IndexOutOfBoundsException {
        this.dirtyBBox = true;
        return this.vertices.remove(n);
    }

    public final boolean isEmpty() {
        return this.vertices.size() == 0;
    }

    public final Vertex getLastVertex() {
        if (this.isEmpty()) {
            return null;
        }
        return this.vertices.get(this.vertices.size() - 1);
    }

    public final ArrayList<Vertex> getVertices() {
        return this.vertices;
    }

    public final void setVertices(ArrayList<Vertex> arrayList) {
        this.vertices = arrayList;
        this.validateBoundingBox();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
        if (bl && !this.isEmpty()) {
            Vertex vertex = this.vertices.get(0);
            Vertex vertex2 = this.getLastVertex();
            if (!VectorUtil.checkEquality(vertex.getCoord(), vertex2.getCoord())) {
                Vertex vertex3 = vertex.clone();
                this.vertices.add(vertex3);
            }
        }
    }

    @Override
    public final int compareTo(Outline outline) {
        float f;
        float f2 = this.getBounds().getSize();
        if (f2 < (f = outline.getBounds().getSize())) {
            return -1;
        }
        if (f2 > f) {
            return 1;
        }
        return 0;
    }

    private final void validateBoundingBox() {
        this.dirtyBBox = false;
        this.bbox.reset();
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.bbox.resize(this.vertices.get(i).getCoord(), 0);
        }
    }

    public final AABBox getBounds() {
        if (this.dirtyBBox) {
            this.validateBoundingBox();
        }
        return this.bbox;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof Outline)) {
            return false;
        }
        Outline outline = (Outline)object;
        if (this.getVertexCount() != outline.getVertexCount()) {
            return false;
        }
        if (!this.getBounds().equals(outline.getBounds())) {
            return false;
        }
        for (int i = this.getVertexCount() - 1; i >= 0; --i) {
            if (((Object)this.getVertex(i)).equals(outline.getVertex(i))) continue;
            return false;
        }
        return true;
    }

    public Outline clone() {
        Outline outline;
        try {
            outline = (Outline)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        outline.bbox = this.bbox.clone();
        outline.vertices = new ArrayList(this.vertices.size());
        for (int i = 0; i < this.vertices.size(); ++i) {
            outline.vertices.add(this.vertices.get(i).clone());
        }
        return outline;
    }
}

