/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;

public class SecurityUtil {
    static final AccessControlContext localACC = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            return AccessController.getContext();
        }
    });
    static final Certificate[] localCerts = SecurityUtil.getCerts(SecurityUtil.class);

    public static final Certificate[] getCerts(final Class<?> clazz) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
        CodeSource codeSource = null != protectionDomain ? protectionDomain.getCodeSource() : null;
        Certificate[] certificateArray = null != codeSource ? codeSource.getCertificates() : null;
        return null != certificateArray && certificateArray.length > 0 ? certificateArray : null;
    }

    public static final boolean equals(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        if (certificateArray == certificateArray2) {
            return true;
        }
        if (certificateArray == null || certificateArray2 == null) {
            return false;
        }
        if (certificateArray.length != certificateArray2.length) {
            return false;
        }
        for (n = 0; n < certificateArray.length && certificateArray[n].equals(certificateArray2[n]); ++n) {
        }
        return n == certificateArray.length;
    }

    public static final boolean equalsLocalCert(Certificate[] certificateArray) {
        return SecurityUtil.equals(localCerts, certificateArray);
    }

    public static final boolean equalsLocalCert(Class<?> clazz) {
        return SecurityUtil.equalsLocalCert(SecurityUtil.getCerts(clazz));
    }

    public static final AccessControlContext getCommonAccessControlContext(Class<?> clazz) {
        if (SecurityUtil.equalsLocalCert(clazz)) {
            return localACC;
        }
        return null;
    }
}

