/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSPLT;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;

public class ChunkList {
    public static final int CHUNK_GROUP_0_IDHR = 0;
    public static final int CHUNK_GROUP_1_AFTERIDHR = 1;
    public static final int CHUNK_GROUP_2_PLTE = 2;
    public static final int CHUNK_GROUP_3_AFTERPLTE = 3;
    public static final int CHUNK_GROUP_4_IDAT = 4;
    public static final int CHUNK_GROUP_5_AFTERIDAT = 5;
    public static final int CHUNK_GROUP_6_END = 6;
    private List<PngChunk> chunks = new ArrayList<PngChunk>();
    private Set<PngChunk> queuedChunks = new LinkedHashSet<PngChunk>();
    final ImageInfo imageInfo;

    public ChunkList(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public void appendReadChunk(PngChunk pngChunk, int n) {
        pngChunk.setChunkGroup(n);
        this.chunks.add(pngChunk);
    }

    public List<PngChunk> getById(String string, boolean bl, boolean bl2) {
        ArrayList<PngChunk> arrayList = new ArrayList<PngChunk>();
        if (bl) {
            for (PngChunk pngChunk : this.queuedChunks) {
                if (!pngChunk.id.equals(string)) continue;
                arrayList.add(pngChunk);
            }
        }
        if (bl2) {
            for (PngChunk pngChunk : this.chunks) {
                if (!pngChunk.id.equals(string)) continue;
                arrayList.add(pngChunk);
            }
        }
        return arrayList;
    }

    public boolean removeChunk(PngChunk pngChunk) {
        return this.queuedChunks.remove(pngChunk);
    }

    public void queueChunk(PngChunk pngChunk, boolean bl, boolean bl2) {
        pngChunk.setPriority(bl2);
        if (bl) {
            List<PngChunk> list = this.getById(pngChunk.id, true, false);
            for (PngChunk pngChunk2 : list) {
                this.removeChunk(pngChunk2);
            }
        }
        this.queuedChunks.add(pngChunk);
    }

    private static boolean shouldWrite(PngChunk pngChunk, int n) {
        int n2;
        int n3;
        if (n == 2) {
            return pngChunk.id.equals("PLTE");
        }
        if (n % 2 == 0) {
            throw new RuntimeException("?");
        }
        if (pngChunk.mustGoBeforePLTE()) {
            n3 = 1;
            n2 = 1;
        } else if (pngChunk.mustGoBeforeIDAT()) {
            n3 = 3;
            n2 = pngChunk.mustGoAfterPLTE() ? 3 : 1;
        } else {
            n3 = 5;
            n2 = 1;
        }
        int n4 = n3;
        if (pngChunk.isWritePriority()) {
            n4 = n2;
        }
        if (ChunkHelper.isUnknown(pngChunk) && pngChunk.getChunkGroup() > 0) {
            n4 = pngChunk.getChunkGroup();
        }
        if (n == n4) {
            return true;
        }
        return n > n4 && n <= n3;
    }

    public int writeChunks(OutputStream outputStream, int n) {
        int n2 = 0;
        Iterator<PngChunk> iterator = this.queuedChunks.iterator();
        while (iterator.hasNext()) {
            PngChunk pngChunk = iterator.next();
            if (!ChunkList.shouldWrite(pngChunk, n)) continue;
            pngChunk.write(outputStream);
            this.chunks.add(pngChunk);
            pngChunk.setChunkGroup(n);
            iterator.remove();
            ++n2;
        }
        return n2;
    }

    public List<PngChunk> getChunks() {
        return new ArrayList<PngChunk>(this.chunks);
    }

    public List<String> getChunksUnkown() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PngChunk pngChunk : this.chunks) {
            if (!ChunkHelper.isUnknown(pngChunk)) continue;
            arrayList.add(pngChunk.id);
        }
        return arrayList;
    }

    public List<PngChunk> getQueuedChunks() {
        return new ArrayList<PngChunk>(this.queuedChunks);
    }

    public boolean setChunk(PngChunk pngChunk, boolean bl) {
        List<PngChunk> list = this.getMatching(pngChunk, false, true);
        if (!list.isEmpty()) {
            throw new PngjException("chunk " + pngChunk.id + " already set ");
        }
        list = this.getMatching(pngChunk, true, false);
        if (!list.isEmpty()) {
            if (bl) {
                for (PngChunk pngChunk2 : list) {
                    this.removeChunk(pngChunk2);
                }
                this.queueChunk(pngChunk, false, false);
                return true;
            }
            return false;
        }
        this.queueChunk(pngChunk, false, false);
        return true;
    }

    public PngChunk getChunk1(String string, String string2, boolean bl) {
        List<PngChunk> list = this.getChunks(string);
        if (list.isEmpty()) {
            return null;
        }
        if (string2 != null) {
            ArrayList<PngChunk> arrayList = new ArrayList<PngChunk>();
            for (PngChunk pngChunk : list) {
                if (pngChunk instanceof PngChunkTextVar && ((PngChunkTextVar)pngChunk).getKey().equals(string2)) {
                    arrayList.add(pngChunk);
                }
                if (!(pngChunk instanceof PngChunkSPLT) || !((PngChunkSPLT)pngChunk).getPalName().equals(string2)) continue;
                arrayList.add(pngChunk);
            }
            list = arrayList;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1 && bl) {
            throw new PngjException("unexpected multiple chunks id=" + string);
        }
        return list.get(list.size() - 1);
    }

    public PngChunk getChunk1(String string) {
        return this.getChunk1(string, null, true);
    }

    public List<PngChunk> getChunks(String string) {
        return this.getById(string, false, true);
    }

    private List<PngChunk> getMatching(PngChunk pngChunk, boolean bl, boolean bl2) {
        ArrayList<PngChunk> arrayList = new ArrayList<PngChunk>();
        if (bl) {
            for (PngChunk pngChunk2 : this.getQueuedChunks()) {
                if (!ChunkList.matches(pngChunk, pngChunk2)) continue;
                arrayList.add(pngChunk2);
            }
        }
        if (bl2) {
            for (PngChunk pngChunk2 : this.getChunks()) {
                if (!ChunkList.matches(pngChunk, pngChunk2)) continue;
                arrayList.add(pngChunk2);
            }
        }
        return arrayList;
    }

    public static boolean matches(PngChunk pngChunk, PngChunk pngChunk2) {
        if (pngChunk2 == null || pngChunk == null || !pngChunk2.id.equals(pngChunk.id)) {
            return false;
        }
        if (pngChunk2.getClass() != pngChunk.getClass()) {
            return false;
        }
        if (!pngChunk.allowsMultiple()) {
            return true;
        }
        if (pngChunk2 instanceof PngChunkTextVar) {
            return ((PngChunkTextVar)pngChunk2).getKey().equals(((PngChunkTextVar)pngChunk).getKey());
        }
        if (pngChunk2 instanceof PngChunkSPLT) {
            return ((PngChunkSPLT)pngChunk2).getPalName().equals(((PngChunkSPLT)pngChunk).getPalName());
        }
        return false;
    }

    public String toString() {
        return "ChunkList: processed: " + this.chunks.size() + " queue: " + this.queuedChunks.size();
    }

    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        stringBuilder.append("\n Processed:\n");
        for (PngChunk pngChunk : this.chunks) {
            stringBuilder.append(pngChunk).append(" G=" + pngChunk.getChunkGroup() + "\n");
        }
        if (!this.queuedChunks.isEmpty()) {
            stringBuilder.append(" Queued:\n");
            for (PngChunk pngChunk : this.chunks) {
                stringBuilder.append(pngChunk).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

