/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.util.LongIntHashMap;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.nio.IntBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;

public class EGLDisplayUtil {
    protected static final boolean DEBUG = Debug.debug("EGLDisplayUtil");
    static LongIntHashMap eglDisplayCounter = new LongIntHashMap();
    public static final EGLGraphicsDevice.EGLDisplayLifecycleCallback eglLifecycleCallback;

    public static int shutdown(boolean bl) {
        if (DEBUG || bl || eglDisplayCounter.size() > 0) {
            System.err.println("EGLDisplayUtil.EGLDisplays: Shutdown (open: " + eglDisplayCounter.size() + ")");
            if (DEBUG) {
                Thread.dumpStack();
            }
            if (eglDisplayCounter.size() > 0) {
                EGLDisplayUtil.dumpOpenDisplayConnections();
            }
        }
        return eglDisplayCounter.size();
    }

    public static void dumpOpenDisplayConnections() {
        System.err.println("EGLDisplayUtil: Open EGL Display Connections: " + eglDisplayCounter.size());
        int n = 0;
        for (LongIntHashMap.Entry entry : eglDisplayCounter) {
            System.err.println("EGLDisplayUtil: Open[" + n + "]: 0x" + Long.toHexString(entry.key) + ": refCnt " + entry.value);
            ++n;
        }
    }

    public static long eglGetDisplay(long l) {
        long l2 = EGL.eglGetDisplay(l);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglGetDisplay(): eglDisplay(" + EGLContext.toHexString(l) + "): " + EGLContext.toHexString(l2) + ", " + (0L != l2 ? "OK" : "Failed"));
        }
        return l2;
    }

    public static synchronized boolean eglInitialize(long l, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (0L == l) {
            return false;
        }
        int n = eglDisplayCounter.get(l) + 1;
        boolean bl = 1 == n ? EGL.eglInitialize(l, intBuffer, intBuffer2) : true;
        if (bl) {
            eglDisplayCounter.put(l, n);
        }
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglInitialize2(" + EGLContext.toHexString(l) + " ...): #" + n + " = " + bl);
        }
        return bl;
    }

    public static synchronized int eglGetDisplayAndInitialize(long l, long[] lArray, int[] nArray, IntBuffer intBuffer, IntBuffer intBuffer2) {
        lArray[0] = 0L;
        long l2 = EGLDisplayUtil.eglGetDisplay(l);
        if (0L == l2) {
            nArray[0] = EGL.eglGetError();
            return 12296;
        }
        if (!EGLDisplayUtil.eglInitialize(l2, intBuffer, intBuffer2)) {
            nArray[0] = EGL.eglGetError();
            return 12289;
        }
        lArray[0] = l2;
        return 12288;
    }

    public static synchronized long eglGetDisplayAndInitialize(long[] lArray) {
        long[] lArray2 = new long[1];
        int[] nArray = new int[1];
        int n = EGLDisplayUtil.eglGetDisplayAndInitialize(lArray[0], lArray2, nArray, null, null);
        if (12288 == n) {
            return lArray2[0];
        }
        if (0L != lArray[0]) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetAndInitDisplay failed with native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n) + "/" + EGLContext.toHexString(nArray[0]) + " - fallback!");
            }
            if (12288 == (n = EGLDisplayUtil.eglGetDisplayAndInitialize(0L, lArray2, nArray, null, null))) {
                lArray[0] = 0L;
                return lArray2[0];
            }
        }
        throw new GLException("Failed to created/initialize EGL display incl. fallback default: native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n) + "/" + EGLContext.toHexString(nArray[0]));
    }

    public static synchronized boolean eglTerminate(long l) {
        boolean bl;
        if (0L == l) {
            return false;
        }
        int n = eglDisplayCounter.get(l) - 1;
        if (0 == n) {
            bl = EGL.eglTerminate(l);
            eglDisplayCounter.remove(l);
        } else {
            if (0 < n) {
                eglDisplayCounter.put(l, n);
            }
            bl = true;
        }
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglTerminate(" + EGLContext.toHexString(l) + " ...): #" + n + " = " + bl);
        }
        return bl;
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(long l, String string, int n) {
        EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(l, 0L, string, n, eglLifecycleCallback);
        eGLGraphicsDevice.open();
        return eGLGraphicsDevice;
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(NativeSurface nativeSurface) {
        long l = NativeWindowFactory.TYPE_WINDOWS == NativeWindowFactory.getNativeWindowType(false) ? nativeSurface.getSurfaceHandle() : nativeSurface.getDisplayHandle();
        AbstractGraphicsDevice abstractGraphicsDevice = nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(l, 0L, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), eglLifecycleCallback);
        eGLGraphicsDevice.open();
        return eGLGraphicsDevice;
    }

    static {
        eglDisplayCounter.setKeyNotFoundValue(0);
        eglLifecycleCallback = new EGLGraphicsDevice.EGLDisplayLifecycleCallback(){

            @Override
            public long eglGetAndInitDisplay(long[] lArray) {
                return EGLDisplayUtil.eglGetDisplayAndInitialize(lArray);
            }

            @Override
            public void eglTerminate(long l) {
                EGLDisplayUtil.eglTerminate(l);
            }
        };
    }
}

