/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.opengl.GLRendererQuirks;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;

public class GLGraphicsConfigurationUtil {
    public static final String NV_coverage_sample = "NV_coverage_sample";
    public static final int WINDOW_BIT = 1;
    public static final int BITMAP_BIT = 2;
    public static final int PBUFFER_BIT = 4;
    public static final int FBO_BIT = 8;
    public static final int ALL_BITS = 15;

    public static final StringBuilder winAttributeBits2String(StringBuilder stringBuilder, int n) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = false;
        if (0 != (1 & n)) {
            stringBuilder.append("WINDOW");
            bl = true;
        }
        if (0 != (2 & n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("BITMAP");
            bl = true;
        }
        if (0 != (4 & n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("PBUFFER");
            bl = true;
        }
        if (0 != (8 & n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("FBO");
        }
        return stringBuilder;
    }

    public static final int getExclusiveWinAttributeBits(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        if (bl) {
            n |= 1;
        } else if (bl2) {
            n |= 8;
        } else if (bl3) {
            n |= 4;
        } else if (bl4) {
            n |= 2;
        }
        if (0 == n) {
            throw new InternalError("Empty bitmask");
        }
        return n;
    }

    public static final int getExclusiveWinAttributeBits(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isFBO(), gLCapabilitiesImmutable.isPBuffer(), gLCapabilitiesImmutable.isBitmap());
    }

    public static final GLCapabilities fixWinAttribBitsAndHwAccel(AbstractGraphicsDevice abstractGraphicsDevice, int n, GLCapabilities gLCapabilities) {
        gLCapabilities.setBitmap(0 != (2 & n));
        gLCapabilities.setPBuffer(0 != (4 & n));
        gLCapabilities.setFBO(0 != (8 & n));
        gLCapabilities.setOnscreen(0 != (1 & n));
        int n2 = GLContext.isHardwareRasterizer(abstractGraphicsDevice, gLCapabilities.getGLProfile());
        if (0 == n2 && gLCapabilities.getHardwareAccelerated()) {
            gLCapabilities.setHardwareAccelerated(false);
        }
        return gLCapabilities;
    }

    public static GLCapabilitiesImmutable fixGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        if (!gLCapabilitiesImmutable.isOnscreen()) {
            return GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, gLDrawableFactory, abstractGraphicsDevice);
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOnscreenGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (!gLCapabilitiesImmutable.isOnscreen() || gLCapabilitiesImmutable.isFBO() || gLCapabilitiesImmutable.isPBuffer() || gLCapabilitiesImmutable.isBitmap()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setBitmap(false);
            gLCapabilities.setPBuffer(false);
            gLCapabilities.setFBO(false);
            gLCapabilities.setOnscreen(true);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOffscreenBitOnly(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (gLCapabilitiesImmutable.isOnscreen()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOffscreenGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        }
        boolean bl4 = GLContext.isFBOAvailable(abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile());
        boolean bl5 = gLDrawableFactory.canCreateGLPbuffer(abstractGraphicsDevice);
        GLRendererQuirks gLRendererQuirks = gLDrawableFactory.getRendererQuirks(abstractGraphicsDevice);
        if (null != gLRendererQuirks) {
            boolean bl6 = bl3 = !gLRendererQuirks.exist(3);
            bl2 = !(gLCapabilitiesImmutable.getDoubleBuffered() && gLCapabilitiesImmutable.isPBuffer() && gLRendererQuirks.exist(0) || gLCapabilitiesImmutable.isBitmap() && gLRendererQuirks.exist(1));
        } else {
            bl3 = true;
            bl2 = true;
        }
        boolean bl7 = !(bl4 && gLCapabilitiesImmutable.isFBO() || bl5 && gLCapabilitiesImmutable.isPBuffer() || bl3 && gLCapabilitiesImmutable.isBitmap());
        boolean bl8 = bl4 && (bl7 || gLCapabilitiesImmutable.isFBO());
        boolean bl9 = !bl8 && bl5 && (bl7 || gLCapabilitiesImmutable.isPBuffer());
        boolean bl10 = bl = !bl8 && !bl9 && bl3 && (bl7 || gLCapabilitiesImmutable.isBitmap());
        if (gLCapabilitiesImmutable.isOnscreen() || bl8 != gLCapabilitiesImmutable.isFBO() || bl9 != gLCapabilitiesImmutable.isPBuffer() || bl != gLCapabilitiesImmutable.isBitmap() || !bl2 && gLCapabilitiesImmutable.getDoubleBuffered()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setFBO(bl8);
            gLCapabilities.setPBuffer(bl9);
            gLCapabilities.setBitmap(bl);
            if (!bl2) {
                gLCapabilities.setDoubleBuffered(false);
            }
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixGLPBufferGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (gLCapabilitiesImmutable.isOnscreen() || !gLCapabilitiesImmutable.isPBuffer() || gLCapabilitiesImmutable.isFBO()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setFBO(false);
            gLCapabilities.setPBuffer(true);
            gLCapabilities.setBitmap(false);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilities fixOpaqueGLCapabilities(GLCapabilities gLCapabilities, boolean bl) {
        if (gLCapabilities.isBackgroundOpaque() != bl) {
            int n = gLCapabilities.getAlphaBits();
            gLCapabilities.setBackgroundOpaque(bl);
            gLCapabilities.setAlphaBits(n);
        }
        return gLCapabilities;
    }

    public static GLCapabilitiesImmutable fixDoubleBufferedGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) {
        if (gLCapabilitiesImmutable.getDoubleBuffered() != bl) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(bl);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }
}

