/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkCHRM
extends PngChunk {
    private double whitex;
    private double whitey;
    private double redx;
    private double redy;
    private double greenx;
    private double greeny;
    private double bluex;
    private double bluey;

    public PngChunkCHRM(ImageInfo imageInfo) {
        super("cHRM", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public boolean mustGoBeforePLTE() {
        return true;
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(32, true);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.whitex), chunkRaw.data, 0);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.whitey), chunkRaw.data, 4);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.redx), chunkRaw.data, 8);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.redy), chunkRaw.data, 12);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.greenx), chunkRaw.data, 16);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.greeny), chunkRaw.data, 20);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.bluex), chunkRaw.data, 24);
        PngHelper.writeInt4tobytes(PngHelper.doubleToInt100000(this.bluey), chunkRaw.data, 28);
        return chunkRaw;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 32) {
            throw new PngjException("bad chunk " + chunkRaw);
        }
        this.whitex = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 0));
        this.whitey = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 4));
        this.redx = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 8));
        this.redy = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 12));
        this.greenx = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 16));
        this.greeny = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 20));
        this.bluex = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 24));
        this.bluey = PngHelper.intToDouble100000(PngHelper.readInt4fromBytes(chunkRaw.data, 28));
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkCHRM pngChunkCHRM = (PngChunkCHRM)pngChunk;
        this.whitex = pngChunkCHRM.whitex;
        this.whitey = pngChunkCHRM.whitex;
        this.redx = pngChunkCHRM.redx;
        this.redy = pngChunkCHRM.redy;
        this.greenx = pngChunkCHRM.greenx;
        this.greeny = pngChunkCHRM.greeny;
        this.bluex = pngChunkCHRM.bluex;
        this.bluey = pngChunkCHRM.bluey;
    }

    public void setChromaticities(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.whitex = d;
        this.redx = d3;
        this.greenx = d5;
        this.bluex = d7;
        this.whitey = d2;
        this.redy = d4;
        this.greeny = d6;
        this.bluey = d8;
    }

    public double[] getChromaticities() {
        return new double[]{this.whitex, this.whitey, this.redx, this.redy, this.greenx, this.greeny, this.bluex, this.bluey};
    }
}

