VectorParameter = {}
VectorParameter_mt = { __index = VectorParameter }
setmetatable(VectorParameter, Control_mt)

-- Constants
VectorParameter.kMargin = 10
VectorParameter.kHeight = 30
VectorParameter.valueOutline = ParameterList.kValueOutlineSmall

function VectorParameter.Create(root, parentObject, type, startValue, minValue, maxValue, dragScale, numElements, onChange)
	-- Create object
	local vectorParameter = Control.Create(root, parentObject)
	setmetatable(vectorParameter, VectorParameter_mt)
	
	-- Set attributes
	vectorParameter.type = type
	vectorParameter.value = startValue
	vectorParameter.minValue = minValue
	vectorParameter.maxValue = maxValue
	vectorParameter.dragScale = dragScale
	vectorParameter.numElements = numElements
	vectorParameter.onChange = onChange
	
	vectorParameter.kWidth = numElements*ScalarParameter.kWidth + (numElements-1)*VectorParameter.kMargin -- this is usually a constant value
	
	-- Create 
	vectorParameter.elements = {}
	
	for i=1,vectorParameter.numElements do
		vectorParameter.elements[i] = ScalarParameter.Create(root, vectorParameter, intruder.ZParameter_kTypeFloat, startValue[i], minValue, maxValue, dragScale,
			function(value)
				vectorParameter.value[i] = value
				vectorParameter.onChange(vectorParameter.value)
			end )	
	end
	
	return vectorParameter	
end

function VectorParameter:HandleEvent(window, rect, event)
	window:PushScissor(rect)
		local elementRect = GRect(0, 0, ScalarParameter.kWidth, ScalarParameter.kHeight)
		elementRect:MoveTo(rect.left, rect.top)
		
		for i=1,self.numElements do
			self.elements[i]:HandleEvent(window, elementRect, event)
			
			elementRect:Offset(ScalarParameter.kWidth + VectorParameter.kMargin, 0)
		end
	window:PopScissor()
end

function VectorParameter:Draw(window, rect)
	window:PushScissor(rect)
		local elementRect = GRect(0, 0, ScalarParameter.kWidth, ScalarParameter.kHeight)
		elementRect:MoveTo(rect.left, rect.top)
		
		for i=1,self.numElements do
			self.elements[i]:Draw(window, elementRect)
			
			elementRect:Offset(ScalarParameter.kWidth + VectorParameter.kMargin, 0)
		end
	window:PopScissor()
end