#version 150

out vec4 fragColor;

uniform sampler2DArray tile;
uniform samplerCube cube1;
uniform samplerCube cube2;
//uniform sampler2D background;
uniform vec2 screen;
uniform float blend;

in vec3 normal;
in vec3 uv;
in vec3 dir;
in float fade;

float getDepth()
{
    float z = gl_FragCoord.z;
    float n = 0.1;
    float f = 500;
    float depth = (2.0 * n) / (f + n - z * (f - n));
    return 1.0 - depth;
}

void main()
{
	vec3 ref = normalize(reflect(normalize(dir), normalize(normal)));
	vec4 tileLayer = texture(tile, uv);
	vec4 cubeLayer = (mix(texture(cube1, ref), texture(cube2, ref), blend) - 0.15) * 1.35;

    vec4 col = (tileLayer + cubeLayer * (1.0 - tileLayer.a)) * fade;
    //vec4 bgcol = texture(background, gl_FragCoord.xy / screen);
    
    float depth = getDepth();
    //fragColor = mix(bgcol, col * depth, fade);
    vec3 c = col.rgb * depth;
    fragColor = vec4(c.r, c.g, c.b, fade);
}
