#version 150

uniform sampler2D TerrainProps;
uniform sampler2D TurnMap;
uniform sampler2D HillMap;

uniform mat4 ViewM;
uniform mat4 ProjM;
uniform mat3 SkyM;
uniform float time;
uniform int row;
uniform float offset;

in vec4 in_Position;
in vec3 in_Normal;
in vec2 in_UV0;
in ivec4 In_Props; //CubeX, CubeY, VertX, VertY

out vec3 uv;
out vec3 normal;
out vec3 dir;
out float fade;

float getTurn(int x)
{
	return texelFetch(TurnMap, ivec2(x, 0), 0).r;
}

float getHill(int x)
{
	return texelFetch(HillMap, ivec2(x, 0), 0).r;
}

vec3 createNormal(int x, float y1, float y2)
{
	vec3 v1 = vec3(0.0, getHill(x-1) + y1, -float(x-1));
	vec3 v2 = vec3(0.0, getHill(x+1) + y2, -float(x+1));
	vec3 dir = normalize(v2 - v1);
	return normalize(cross(vec3(1.0, 0.0, 0.0), dir));
}

void main()
{
    
	vec4 props = texelFetch(TerrainProps, In_Props.xy, 0) * 255.0; // height, depth, tileid, unused
	if(in_Normal.y == 0.0)
		uv = vec3(in_UV0.x, in_UV0.y * props.y, props.z); // Extrude only on side faces
	else
		uv = vec3(in_UV0.x, in_UV0.y, props.z);

	// Fade in geometry
    // y
    const float frange1 = 25.0;
	float fade1 =  1.0;
	fade1 -= max(0.0, In_Props.w - 256.0 + frange1) / frange1;
	fade1 -= max(0.0f, frange1 - In_Props.w + offset) / frange1;
	// x
    const float frange2 = 20.0;
	float fade2 =  1.0;
	fade2 -= max(0.0, In_Props.z - 128.0 + frange2) / frange2;
	fade2 -= max(0.0f, frange2 - In_Props.z) / frange2;
    // pick one..
    fade = min(fade1, fade2);
    
    // y normals
	if(in_Normal.y == 1.0)
    {
        // Water plane
		if(props.z == 5)
        {
			normal = createNormal(
				In_Props.w,
				(sin((In_Props.w + row - 1) / 2.0 + time * 32.0)) / 25.0,
				(cos((In_Props.w + row + 1) / 1.5 + time * 16.0)) / 15.0
			);
		}
		else
			normal = createNormal(In_Props.w, 0.0, 0.0);
	}
	else normal = in_Normal;
    
	vec2 TurnHill = vec2(getTurn(In_Props.w), getHill(In_Props.w));	

	vec4 pos = vec4(
		in_Position.x + TurnHill.x,
		in_Position.y * props.y + props.x + TurnHill.y,
		in_Position.z, 
		1.0);
	pos = ViewM * pos;
	dir = SkyM * pos.xyz;
	gl_Position = ProjM * pos;
}
