#version 150

uniform sampler1D data;

in vec2 uv;
out vec4 fragColor;

void main()
{
    int p = int(uv.x * 8);
    vec4 c = texelFetch(data, p, 0);
    if(c.r < uv.y)
        fragColor = vec4(0.0);
    else
    {
        float v = 1.0 * sin(uv.y * 64);
        fragColor = vec4(v,v,v,1.0);
    }
}
