E2.p=E2.plugins.clamped_accumulate_modulator=function(a,b){this.desc="Every input <b>value</b> is accumulated in an internal buffer. The buffer value is not permitted to be smaller then <b>min</b> or larger than <b>max</b>.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"A small value to be accumulated in an internal buffer.",def:0},{name:"min",dt:a.datatypes.FLOAT,desc:"Minimum internal buffer value.",def:0},{name:"max",dt:a.datatypes.FLOAT,desc:"Maximum internal buffer value.",def:1},{name:"reset",dt:a.datatypes.FLOAT,desc:"Send a value to this slot to reset the accumulator to that value.",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The current value of the accumulation buffer.",def:0}],this.state={value:0}},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=b,this.state.value+=this.value,this.state.value=this.state.value<this.lo?this.lo:this.state.value>this.hi?this.hi:this.state.value),a.index===1&&(this.lo=b),a.index===2&&(this.hi=b),a.index===3&&(this.state.value=b<this.lo?this.lo:b>this.hi?this.hi:b)},E2.p.prototype.update_output=function(a){return this.state.value},E2.p.prototype.state_changed=function(a){a||(this.value=0,this.lo=0,this.hi=1)},E2.p=E2.plugins.screenspace_camera=function(a,b){this.desc="Create a screen space (2D) camera suitable for display of XY-planar data, like quads.",this.input_slots=[],this.output_slots=[{name:"camera",dt:a.datatypes.CAMERA,desc:"Screenspace camera."}],this.gl=a.renderer.context},E2.p.prototype.reset=function(){this.camera=new Camera(this.gl)},E2.p.prototype.update_output=function(a){return this.camera},E2.p=E2.plugins.input_proxy=function(a,b){this.desc="Create a new type-less slot to route data into the current graph from its parent. When connected to a slot, it will assume its type until disconnected. Renaming this plugin will rename the corresponding parent slot.",this.input_slots=[],this.output_slots=[],this.state={slot_id:b.add_slot(E2.slot_type.output,{name:"output",dt:a.datatypes.ANY,desc:"Connect this to a slot of any type, to have the parent slot assume its datatype and forward data from the parent graph."})},this.data=null,this.node=b,b.title||(b.title="input_"+b.uid)},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.input_updated=function(a){this.data=a,this.updated=!0},E2.p.prototype.connection_changed=function(a,b,c){var d=this.node.parent_graph.plugin;d&&d.proxy_connection_changed(a,this.node,b.dst_node,c,b.dst_slot)},E2.p.prototype.update_output=function(a){return this.data},E2.p.prototype.state_changed=function(a){a&&this.node.ui.dom.addClass("proxy")},E2.p=E2.plugins.instance_cube_modulator=function(a,b){this.desc="Create a scene that represents <b>count</b>^3 instances of the supplied <b>mesh</b>, starting at position <b>start</b> and forming an axis-aligned cube of instances, with each offset according to <b>offset</b> on each axis separately.",this.input_slots=[{name:"count",dt:a.datatypes.VECTOR,desc:"The cube root of the number of instances to create.",lo:0,def:1},{name:"mesh",dt:a.datatypes.MESH,desc:"The mesh to instantiate."},{name:"start",dt:a.datatypes.VECTOR,desc:"The starting position for one cube corner.",def:"0, 0, 0"},{name:"offset",dt:a.datatypes.VECTOR,desc:"The axis-offset for each instance.",def:"0, 0, 0"}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"Scene representing <b>count</b>^3 instances."}],this.gl=a.renderer.context},E2.p.prototype.update_input=function(a,b){if(a.index===0)this.count=b;else if(a.index===1){var c=this.scene=new Scene(this.gl,null,null);c.meshes=[b],c.vertex_count=b.vertex_count}else a.index===2?this.start=b:this.offset=b},E2.p.prototype.update_state=function(){var a=this.scene,b=a.meshes[0],c=this.start,d=this.offset,e=[],f=c.slice(0),g=Math.round(this.count[0]),h=Math.round(this.count[1]),i=Math.round(this.count[2]);for(var j=0;j<g;j++){f[1]=c[1];for(var k=0;k<h;k++){f[2]=c[2];for(var l=0;l<i;l++){var m=mat4.create();mat4.identity(m),mat4.translate(m,f),e.push(m),f[2]+=d[2]}f[1]+=d[1]}f[0]+=d[0]}b.instances=e,b.instance_transforms=null},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=new Scene(this.gl,null,null),this.count=[1,0,1],this.start=[0,0,0],this.offset=[0,0,0])},E2.p=E2.plugins.bool_display=function(a,b){this.desc="Displays the text 'True' or 'False' depending on the state of the supplied bool or '-', if no data is being received.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"The input boolean to display."}],this.output_slots=[],this.label=null},E2.p.prototype.reset=function(){this.update_value(null)},E2.p.prototype.create_ui=function(){return this.label=make("div"),this.label.css("text-align","right"),this.update_value(null),this.label},E2.p.prototype.connection_changed=function(a,b,c){a||this.update_value(null)},E2.p.prototype.update_input=function(a,b){this.update_value(b)},E2.p.prototype.update_value=function(a){this.label&&this.label.text(a===null?"-":a?"True":"False")},E2.p=E2.plugins.annotation=function(a,b){this.desc="Add textural hints to the graph.",this.input_slots=[],this.output_slots=[],this.state={text:"",width:0,height:0}},E2.p.prototype.create_ui=function(){var a=$('<textarea placeholder="Type text here" />');return a.css({"font-size":"8pt",border:"1px solid #999",margin:"0px","margin-top":"2px",padding:"2px"}),a.bind("blur",function(a){return function(){a.state.text=$(this).val()}}(this)),a.mouseup(function(a){return function(){var b=$(this);a.state.width=b.width(),a.state.height=b.height()}}(this)),a},E2.p.prototype.state_changed=function(a){var b=this.state;a&&b.text!==""&&(a.val(b.text),b.width>0&&a.css("width",b.width),b.height>0&&a.css("height",b.height))},E2.p=E2.plugins.exp_modulator=function(a,b){this.desc="Exp(x).",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"exp(<b>value</b>).",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=Math.exp(b))},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.if_modulator=function(a,b){this.desc="Allows <b>value</b> though if <b>condition</b> is true and inhibits futher data-flow otherwise.",this.input_slots=[{name:"condition",dt:a.datatypes.BOOL,desc:"Condition that, if true, allows <b>value</b> to be emitted.",def:"False"},{name:"value",dt:a.datatypes.FLOAT,desc:"Value to be emitted if <b>condition</b> is true.",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits <b>value</b> if <b>condition</b> is true and nothing otherwise."}]},E2.p.prototype.reset=function(){this.condition=!1,this.out_value=this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.condition=b:this.value=b},E2.p.prototype.update_state=function(){this.condition?this.out_value=this.value:this.updated=!1},E2.p.prototype.update_output=function(a){return this.out_value},E2.p=E2.plugins.assets_failed_generator=function(a,b){this.desc="Emits the current number of assets that have failed to load.",this.input_slots=[],this.output_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"Number of assets that have failed to load."}],this.core=a,this.node=b,this.asset_listener=function(a){return function(){a.node.queued_update=1}}(this),a.asset_tracker.add_listener(this.asset_listener)},E2.p.prototype.reset=function(){},E2.p.prototype.destroy=function(){this.core.asset_tracker.remove_listener(this.asset_listener)},E2.p.prototype.update_output=function(a){return this.core.asset_tracker.failed},E2.p=E2.plugins.ceiling_modulator=function(a,b){this.desc="Round <b>value</b> to the closest higher interger.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Value to be rounded.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The rounded result.",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=Math.ceil(b))},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.output_proxy=function(a,b){this.desc="Create a new type-less slot to route data out of the current graph to its parent. When connected to a slot, it will assume its type until disconnected. Renaming this plugin will rename the corresponding parent slot.",this.input_slots=[],this.output_slots=[],this.state={slot_id:b.add_slot(E2.slot_type.input,{name:"input",dt:a.datatypes.ANY,desc:"Connect a slot of any type to this plugin, to have the parent slot assume its datatype and forward data from this plugin."})},this.node=b,this.data=null,this.changed=!1,b.title||(b.title="output_"+b.uid)},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.connection_changed=function(a,b,c){var d=this.node.parent_graph.plugin;d&&d.proxy_connection_changed(a,this.node,b.src_node,c,b.src_slot)},E2.p.prototype.update_input=function(a,b){var c=this.node;this.data=b,this.changed=!0;if(c.parent_graph.plugin){var d=c.parent_graph.plugin;d.updated_sids.push(d.state.output_sids[c.uid]),d.updated=!0}},E2.p.prototype.state_changed=function(a){a&&this.node.ui.dom.addClass("proxy")},E2.p=E2.plugins.equals_modulator=function(a,b){this.desc="Emits true if <b>value</b> equals <b>reference</b> and false otherwise.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value.",def:0},{name:"reference",dt:a.datatypes.FLOAT,desc:"Reference value to comprate <b>value</b> to.",def:0}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"True if <b>value</b> equals <b>reference</b> and false otherwise.",def:"False"}]},E2.p.prototype.reset=function(){this.value=0,this.ref=0,this.state=!1},E2.p.prototype.update_input=function(a,b){a.index===0?this.value=b:this.ref=b},E2.p.prototype.update_state=function(){this.state=this.value===this.ref},E2.p.prototype.update_output=function(a){return this.state},E2.p=E2.plugins.graph=function(a,b){this.desc="Encapsulate a nested graph into- and out of which arbitrary data can be routed and the encapsulated logic of which can be optinally rendered to a <b>texture</b> instead of the framebuffer.",this.input_slots=[{name:"enabled",dt:a.datatypes.BOOL,desc:"En- or disable the processing of the nested graph logic.",def:"True"}],this.output_slots=[{name:"texture",dt:a.datatypes.TEXTURE,desc:"When connected, all enclosed plugins will render to this texture instead of the framebuffer. Also, when connected two dynamic input slots will appear that allows control of the texture resolution.",def:"Render to framebuffer"}],this.state={enabled:!0,input_sids:{},output_sids:{}},this.gl=a.renderer.context,this.core=a,this.input_nodes={},this.output_nodes={},this.is_reset=!0,this.parent_node=b,this.updated_sids=[],this.framebuffer=null,this.texture=null,this.renderbuffer=null,this.e2_is_graph=!0},E2.p.prototype.reset=function(){this.state.enabled=!0,this.graph&&this.graph.reset()},E2.p.prototype.play=function(){this.graph&&this.graph.pause()},E2.p.prototype.pause=function(){this.graph&&this.graph.pause()},E2.p.prototype.stop=function(){this.graph&&this.graph.stop()},E2.p.prototype.create_ui=function(){var a=$('<input id="state" type="button" value="Edit" title="Open this graph for editing." />');return a.click(function(a){return function(b){a.graph&&a.graph.tree_node.activate()}}(this)),a},E2.p.prototype.get_dt_name=function(a){return!a||!a.name?"ERROR":a.name},E2.p.prototype.dbg=function(a){},E2.p.prototype.connection_changed=function(a,b,c){if(c.uid!==undefined){var d=null,e=this.core;if(!a){if(c.type===E2.slot_type.input){var f=this.input_nodes[c.uid];d=f.dyn_outputs[0],f.plugin.data=e.get_default_value(c.dt),f.reset()}else{var g=this.parent_node,h=0;for(var i=0,j=g.outputs.length;i<j;i++)g.outputs[i].src_slot===c&&h++;h===0&&(d=this.output_nodes[c.uid].dyn_inputs[0])}d&&!d.connected&&(d.dt=c.dt=e.datatypes.ANY,this.dbg("Resetting PDT/GDT for slot("+c.uid+")"))}else{var k=null;c.type===E2.slot_type.input?(c.dt===e.datatypes.ANY&&(c.dt=b.src_slot.dt,this.dbg("Setting GDT for slot("+c.uid+") to "+this.get_dt_name(b.src_slot.dt))),k=this.input_nodes[c.uid],d=k.dyn_outputs[0]):(c.dt===e.datatypes.ANY&&(c.dt=b.dst_slot.dt,this.dbg("Setting GDT for slot("+c.uid+") to "+this.get_dt_name(b.dst_slot.dt))),k=this.output_nodes[c.uid],d=k.dyn_inputs[0]),d.dt===e.datatypes.ANY&&(this.dbg("Setting PDT for slot("+d.uid+") to "+this.get_dt_name(c.dt)),d.dt=c.dt,k.plugin.data=e.get_default_value(c.dt))}}else c.type===E2.slot_type.output&&this.set_render_target_state(a)},E2.p.prototype.set_render_target_state=function(a){var b=this.gl;if(a){this.framebuffer=b.createFramebuffer(),this.framebuffer.width=512,this.framebuffer.height=512,b.bindFramebuffer(b.FRAMEBUFFER,this.framebuffer);var c=b.createTexture();b.bindTexture(b.TEXTURE_2D,c),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE),b.texImage2D(b.TEXTURE_2D,0,b.RGBA,this.framebuffer.width,this.framebuffer.height,0,b.RGBA,b.UNSIGNED_BYTE,null),this.renderbuffer=b.createRenderbuffer(),b.bindRenderbuffer(b.RENDERBUFFER,this.renderbuffer),b.renderbufferStorage(b.RENDERBUFFER,b.DEPTH_COMPONENT16,this.framebuffer.width,this.framebuffer.height),b.framebufferTexture2D(b.FRAMEBUFFER,b.COLOR_ATTACHMENT0,b.TEXTURE_2D,c,0),b.framebufferRenderbuffer(b.FRAMEBUFFER,b.DEPTH_ATTACHMENT,b.RENDERBUFFER,this.renderbuffer),b.bindTexture(b.TEXTURE_2D,null),b.bindRenderbuffer(b.RENDERBUFFER,null),b.bindFramebuffer(b.FRAMEBUFFER,null),this.texture=new Texture(b,c),this.texture.width=this.framebuffer.width,this.texture.height=this.framebuffer.height,this.texture.framebuffer=this.framebuffer}else{var d=!1,e=this.parent_node.outputs;for(var f=0,g=e.length;f<g;f++){var h=e[f].src_slot;if(h.uid===undefined&&h.type===E2.slot_type.output){d=!0;break}}d||(this.framebuffer&&b.deleteFramebuffer(this.framebuffer),this.renderbuffer&&b.deleteRenderbuffer(this.renderbuffer),this.texture&&this.texture.drop(),this.framebuffer=null,this.renderbuffer=null,this.texture=null)}},E2.p.prototype.proxy_connection_changed=function(a,b,c,d,e){var f=this,g=this.core,h=this.parent_node,i=function(a,b){for(var c in a)if(a[c].uid===b)return parseInt(c);return msg("ERROR: Failed to resolve node("+b+") in graph("+f.graph.plugin.parent_node.title+")."),-1},j=function(a){if(a.type===E2.slot_type.input){for(var b=0,c=h.inputs.length;b<c;b++)if(h.inputs[b].dst_slot===a)return!0}else for(var b=0,c=h.outputs.length;b<c;b++)if(h.outputs[b].src_slot===a)return!0;return!1},k=function(d,k,l){f.dbg("Proxy slot change "+a+", last = "+d+", g_slot = "+k.uid+", p_slot = "+l.uid),l.connected=!0;if(a)l.dt===g.datatypes.ANY&&(l.dt=e.dt,f.dbg("    Setting PDT to "+f.get_dt_name(e.dt)+"."),k.dt===g.datatypes.ANY&&(b.plugin.data=g.get_default_value(e.dt))),k.dt===g.datatypes.ANY&&(k.dt=e.dt,f.dbg("    Setting GDT to "+f.get_dt_name(e.dt)+"."));else if(d){var m=h.parent_graph.connections,n=!1;for(var o=0,p=m.length;o<p;o++){var q=m[o];if(q.dst_slot===k||q.src_slot===k){n=!0;break}}l.connected=!1,n||(l.dt=k.dt=g.datatypes.ANY,f.dbg("    Reverting to PDT/GDT to ANY."));if(c.plugin.id==="input_proxy"){n=!1;for(var o=0,p=c.outputs.length;o<p;o++)if(c.outputs[o].src_slot===e){n=!0;break}var r=h.find_dynamic_slot(E2.slot_type.input,i(f.input_nodes,c.uid));!n&&!j(r)&&(e.dt=r.dt=g.datatypes.ANY,f.dbg("    Reverting remote proxy slot to PDT/GDT to ANY."))}else if(c.plugin.id==="output_proxy"){var r=h.find_dynamic_slot(E2.slot_type.output,i(f.output_nodes,c.uid));j(r)||(e.dt=r.dt=g.datatypes.ANY,f.dbg("    Reverting remote proxy slot to PDT/GDT to ANY."))}}};if(b.plugin.id==="input_proxy"){var l=b.outputs.length===0;k(l,h.find_dynamic_slot(E2.slot_type.input,i(this.input_nodes,b.uid)),d),this.dbg("    Output count = "+b.outputs.length)}else{var l=b.inputs.length===0;k(l,h.find_dynamic_slot(E2.slot_type.output,i(this.output_nodes,b.uid)),d),this.dbg("    Input count = "+b.inputs.length)}},E2.p.prototype.update_input=function(a,b){if(a.uid===undefined){if(a.index===0){this.state.enabled=b;if(!b){if(this.graph&&!this.is_reset){var c=this.core;this.is_reset=!0,this.graph===c.active_graph&&c.app&&c.app.updateCanvas(!1)}}else this.is_reset=!1}}else this.input_nodes[a.uid].plugin.input_updated(b)},E2.p.prototype.update_state=function(){this.updated=!1,this.updated_sids=[];if(this.graph&&this.state.enabled){var a=null;if(this.framebuffer){var b=this.gl;this.core.renderer.push_framebuffer(this.framebuffer,this.framebuffer.width,this.framebuffer.height),b.clear(b.COLOR_BUFFER_BIT|b.DEPTH_BUFFER_BIT)}this.graph.update(),this.framebuffer&&this.core.renderer.pop_framebuffer()}},E2.p.prototype.update_output=function(a){return a.uid!==undefined?this.output_nodes[a.uid].plugin.data:(this.updated=!0,this.texture)},E2.p.prototype.query_output=function(a){return a.uid===undefined||this.updated_sids.indexOf(a.uid)>-1},E2.p.prototype.destroy_slot=function(a,b){var c=a===E2.slot_type.input?this.state.input_sids:this.state.output_sids,d=c[b];delete c[b],this.parent_node.remove_slot(a,d)},E2.p.prototype.graph_event=function(a){return function(b){var c=b.node.plugin.id,d=a.core,e=a.parent_node;if(c!=="input_proxy"&&c!=="output_proxy")return;a.dbg("Gevent type = "+b.type+", node uid = "+b.node.uid);if(b.type==="node-created"){if(c==="input_proxy"){var f=e.add_slot(E2.slot_type.input,{name:""+b.node.title,dt:d.datatypes.ANY});a.state.input_sids[b.node.uid]=f,a.input_nodes[f]=b.node}else if(c==="output_proxy"){var f=e.add_slot(E2.slot_type.output,{name:""+b.node.title,dt:d.datatypes.ANY});a.state.output_sids[b.node.uid]=f,a.output_nodes[f]=b.node}}else b.type==="node-destroyed"?c==="input_proxy"?a.destroy_slot(E2.slot_type.input,b.node.uid):c==="output_proxy"&&a.destroy_slot(E2.slot_type.output,b.node.uid):b.type==="node-renamed"&&(c==="input_proxy"?e.rename_slot(E2.slot_type.input,a.state.input_sids[b.node.uid],b.node.title):c==="output_proxy"&&e.rename_slot(E2.slot_type.output,a.state.output_sids[b.node.uid],b.node.title))}},E2.p.prototype.state_changed=function(a){var b=this.core,c=this.parent_node,d=this;if(a){c.ui.dom.addClass("graph");return}var e=function(a,c){for(var e=0,f=a.length;e<f;e++)if(a[e].uid===c){var g=a[e],h=g.plugin;return h.data=b.get_default_value((h.id==="input_proxy"?g.dyn_outputs:g.dyn_inputs)[0].dt),g}return msg("ERROR: Failed to find registered proxy node("+c+") in graph("+d.graph.plugin.parent_node.title+")."),null};for(var f in this.state.input_sids)this.input_nodes[this.state.input_sids[f]]=e(this.graph.nodes,parseInt(f));for(var f in this.state.output_sids)this.output_nodes[this.state.output_sids[f]]=e(this.graph.nodes,parseInt(f));var g=c.outputs;for(var h=0,i=g.length;h<i;h++){var j=g[h];if(j.src_node===c&&j.src_slot.uid===undefined&&j.src_slot.index===0){this.set_render_target_state(!0);break}}},E2.p=E2.plugins.light_type_generator=function(a,b){this.desc="Select light type.",this.input_slots=[],this.output_slots=[{name:"type",dt:a.datatypes.FLOAT,desc:"Emits the selected light type when requested or the selection state changes.",def:"Point"}],this.state={type:Light.type.POINT}},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=Light.type,b=$("<select />",{selectedIndex:1});return $("<option />",{value:a.POINT,text:"Point"}).appendTo(b),$("<option />",{value:a.DIRECTIONAL,text:"Directional"}).appendTo(b),b.change(function(a){return function(){a.state.type=parseInt(b.val()),a.state_changed(b),a.updated=!0}}(this)),b},E2.p.prototype.update_output=function(a){return this.state.type},E2.p.prototype.state_changed=function(a){a&&a.val(""+this.state.type)},E2.p=E2.plugins.audio_player=function(a,b){this.desc="Play an audio stream. Playback loops.",this.input_slots=[{name:"audio",dt:a.datatypes.AUDIO,desc:"The audio stream to play."},{name:"play",dt:a.datatypes.BOOL,desc:"Send true to start playback and false to stop.",def:!1},{name:"mute",dt:a.datatypes.BOOL,desc:"Send true to mute playback and false to reenable audio.",def:!1},{name:"volume",dt:a.datatypes.FLOAT,desc:"Set playback volume.",lo:0,hi:0,def:.5},{name:"time",dt:a.datatypes.FLOAT,desc:"Set playback time."}],this.output_slots=[],this.audio=null,this.playing=!1,this.should_play=!1,this.muted=!1,this.volume=.5,this.time=null},E2.p.prototype.play=function(){this.audio&&!this.playing&&this.should_play&&(this.playing=this.should_play=!0,this.audio.play())},E2.p.prototype.pause=function(){this.audio&&this.playing&&(this.playing=!1,this.should_play=!0,this.audio.pause())},E2.p.prototype.stop=function(){this.audio&&(this.playing&&(this.playing=this.should_play=!1,this.audio.pause()),this.audio.currentTime=0)},E2.p.prototype.update_input=function(a,b){a.index===0?(this.audio=b,this.playing=!1):a.index===1?this.should_play=b:a.index===2?this.muted=b:a.index===3?this.volume=b<0?0:b>1?1:b:a.index===4&&(this.time=b)},E2.p.prototype.update_state=function(){var a=this.audio;this.playing!==this.should_play&&a&&(this.should_play?a.play():a.pause(),this.playing=this.should_play);if(!this.playing)return;a&&(a.muted=this.muted,a.volume=this.volume,this.time&&(a.currentTime=this.time,this.time=null)),this.updated=!0},E2.p=E2.plugins.instance_ifs_modulator=function(a,b){this.desc="Create a scene that represents <b>count</b> instances of the supplied <b>mesh</b>, starting at position <b>start</b>, offset by <b>delta</b> each instance.",this.input_slots=[{name:"recursion depth",dt:a.datatypes.FLOAT,desc:"Level to resurse to.",lo:1,hi:6,def:1},{name:"level resolution",dt:a.datatypes.FLOAT,desc:"Number of instances per recursion level.",lo:1,hi:4,def:1},{name:"mesh",dt:a.datatypes.MESH,desc:"The mesh to instantiate."},{name:"level transform",dt:a.datatypes.MATRIX,desc:"Transform applied between branches.",def:"Identity"},{name:"branch transform",dt:a.datatypes.MATRIX,desc:"Transform applied between instances on the same level.",def:"Identity"}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"Scene representing the resulting IFS."}],this.gl=a.renderer.context},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.r_depth=b);if(a.index===1)this.l_res=b;else if(a.index===2){var c=this.scene=new Scene(this.gl,null,null);c.meshes=[b],c.vertex_count=b.vertex_count}else a.index===3?this.l_transform=b:a.index===4&&(this.b_transform=b)},E2.p.prototype.update_state=function(){var a=this.scene,b=a.meshes[0],c=function(a,b,d,e){if(e===a.r_depth)return;for(var f=0;f<a.l_res;f++)b.push(mat4.create(d)),mat4.multiply(d,a.b_transform);mat4.multiply(d,a.l_transform),c(a,b,d,e+1)},d=[],e=mat4.create();mat4.identity(e),c(this,d,e,0),b.instances=d,b.instance_transforms=null},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=new Scene(this.gl,null,null),this.r_depth=1,this.l_res=1,this.l_transform=mat4.create(),this.b_transform=mat4.create(),mat4.identity(this.l_transform),mat4.identity(this.b_transform))},E2.p=E2.plugins.material_light_modulator=function(a,b){this.desc="Sets the light parameters for a lightsource speficied by index.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"light index",dt:a.datatypes.FLOAT,desc:"The index of the light in the supplied <b>material</b>.",def:0,lo:0,hi:9},{name:"light",dt:a.datatypes.LIGHT,desc:"The light to use in the specified <b>index</b> of the supplied <b>material</b>.",def:0,lo:0,hi:7}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:a.index===1?this.next_index=b<0?0:b>7?7:b:a.index===2&&(this.light=b)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?this.material=new Material:c.index===2&&(this.light=null))},E2.p.prototype.update_state=function(){this.material.lights[this.index]=null,this.material.lights[this.next_index]=this.light,this.index=this.next_index},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.next_index=this.index=0,this.light=null)},E2.p=E2.plugins.const_float_generator=function(a,b){this.desc="Emits a float constant specified in an input field. If an invalid string in entered, the field is reset to the previous value.",this.input_slots=[],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The currently entered value.",def:1}],this.state={val:1}},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=$('<input type="text" value="1.0" style="width: 50px;" />');return a.css("border","1px solid #999"),a.change(function(b){return function(c){try{var d=parseFloat(a.val());isNaN(d)||(b.state.val=d)}catch(c){}a.val(""+b.state.val),b.updated=!0}}(this)),a},E2.p.prototype.update_output=function(a){return this.state.val},E2.p.prototype.state_changed=function(a){a&&a.val(""+this.state.val)},E2.p=E2.plugins.divide_modulator=function(a,b){this.desc="Divides <b>value</b> by <b>scalar</b> and emits the result.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value to be divided.",def:0},{name:"scalar",dt:a.datatypes.FLOAT,desc:"Factor to divide <b>value</b> by.",lo:">0",def:1}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"Emits <b>value</b> / <b>scalar</b>.",def:0}]},E2.p.prototype.reset=function(){this.value=0,this.scalar=1,this.result=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.value=b:this.scalar=b<1e-7?1:b},E2.p.prototype.update_state=function(){this.result=this.value/this.scalar},E2.p.prototype.update_output=function(a){return this.result},E2.p=E2.plugins.scale_matrix=function(a,b){this.desc="Create a matrix that scales by the supplied factors for each axis.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Factors to scale each axis by.",def:"1, 1, 1"}],this.output_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The resulting scale matrix.",def:"Identity"}]},E2.p.prototype.reset=function(){this.matrix=mat4.create(),mat4.identity(this.matrix)},E2.p.prototype.update_input=function(a,b){mat4.identity(this.matrix),mat4.scale(this.matrix,b)},E2.p.prototype.update_output=function(a){return this.matrix},E2.p=E2.plugins.delegate_get_length_modulator=function(a,b){this.desc="Emits the number of elements in the supplied sequence <b>delegate</b>.",this.input_slots=[{name:"delegate",dt:a.datatypes.DELEGATE,desc:"The delegate to the the number of elements in.",def:0}],this.output_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"The number of elements in the supplied <b>delegate</b>.",def:0}],this.delegate=null,this.result=0},E2.p.prototype.update_input=function(a,b){this.delegate=b},E2.p.prototype.update_output=function(a){return this.delegate?this.delegate.count:0},E2.p=E2.plugins.convert_oscilator_unit_modulator=function(a,b){this.desc="Rescales and offsets a number in the range -1;1 to the range 0;1.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The input value.",lo:-1,hi:1,def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The output value: (I + 1) / 2",lo:0,hi:1,def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){var c=(b+1)*.5;this.value=c<0?0:c>1?1:c},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.or_modulator=function(a,b){this.desc="Emits true if either input value is true and false otherwise.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"The first operand.",def:"False"},{name:"bool",dt:a.datatypes.BOOL,desc:"The second operand.",def:"False"}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Emits true if <b>first</b> <i>or</i> <b>second</b> are true and false otherwise.",def:"False"}]},E2.p.prototype.reset=function(){this.conds=[!1,!1],this.state=!1},E2.p.prototype.update_input=function(a,b){this.conds[a.index]=b},E2.p.prototype.update_state=function(){this.state=this.conds[0]||this.conds[1]},E2.p.prototype.update_output=function(a){return this.state},E2.p=E2.plugins.instance_texture_modulator=function(a,b){this.desc="Create a scene that represents <b>count</b> instances of the supplied </b>mesh</b>, distributed according to the intensity of the red channel of the supplied <b>texture</b>, whereas the green channel specifies instance elevation.",this.input_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"The number of instances to create.",lo:0,def:1},{name:"mesh",dt:a.datatypes.MESH,desc:"The mesh to instantiate."},{name:"texture",dt:a.datatypes.TEXTURE,desc:"The instantiation parameter texture map."},{name:"scale",dt:a.datatypes.VECTOR,desc:"The scale of the generated instance map.",def:"1, 1, 1"}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"Scene representing <b>count</b> instances."}],this.gl=a.renderer.context},E2.p.prototype.update_input=function(a,b){if(a.index===0)this.count=Math.round(b);else if(a.index===1){var c=this.scene=new Scene(this.gl,null,null);c.meshes=[b],c.vertex_count=b.vertex_count}else a.index===2?this.texture_sampler=b.get_sampler():a.index===3&&(this.scale=b)},E2.p.prototype.update_state=function(){var a=this.scene;if(this.texture_sampler){var b=a.meshes[0],c=[],d=0,e,f,a;while(d<this.count){var g=mat4.create();mat4.identity(g),e=Math.random(),f=Math.random(),a=this.texture_sampler.get_pixel(e,f);while(Math.random()*255>a[0])e=Math.random(),f=Math.random(),a=this.texture_sampler.get_pixel(e,f);mat4.translate(g,[(e-.5)*this.scale[0],a[1]/255*this.scale[1],(f-.5)*this.scale[2]]),c.push(g),d++}b.instances=c,b.instance_transforms=null}},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=new Scene(this.gl,null,null),this.count=1,this.texture=null,this.scale=[1,1,1])},E2.p=E2.plugins.toggle_modulator=function(a,b){this.desc="For every continous sequence of 'true' values sent to the 'trigger' input slot the emitted value will switch from true to false and visa versa. The initial value is true.",this.input_slots=[{name:"trigger",dt:a.datatypes.BOOL,desc:"Every time true is sent one or more times in a row, the emitted value will switch between true and false, starting with true."}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"The current state.",def:"True"}],this.state={value:!0}},E2.p.prototype.update_input=function(a,b){b&&(this.triggered=!0,this.state.value=!this.state.value)},E2.p.prototype.update_state=function(){this.triggered||(this.updated=!1),this.triggered=!1},E2.p.prototype.update_output=function(a){return this.state.value},E2.p.prototype.state_changed=function(a){a||(this.state.value=!0,this.triggered=!0)},E2.p=E2.plugins.sawtooth_modulator=function(a,b){this.desc="Sawtooth oscilator. A <b>time</b> value incrementing by one unit per second will yield a 1Hz output signal.",this.input_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Time in seconds.",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits ((<b>time</b> % 1) - 0.5) * 2.",lo:-1,hi:1,def:0}]},E2.p.prototype.reset=function(){this.time=0,this.result=0},E2.p.prototype.update_input=function(a,b){this.time=b},E2.p.prototype.update_state=function(){this.result=(this.time%1-.5)*2},E2.p.prototype.update_output=function(a){return this.result},E2.p=E2.plugins.blend_mode_generator=function(a,b){this.desc="Select blend mode.",this.input_slots=[],this.output_slots=[{name:"blend mode",dt:a.datatypes.FLOAT,desc:"Emits the selected blend mode when requested or the selection state changes.",def:"Normal"}],this.state={mode:Renderer.blend_mode.NORMAL}},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=Renderer.blend_mode,b=$("<select />",{selectedIndex:4});return $("<option />",{value:a.NONE,text:"None"}).appendTo(b),$("<option />",{value:a.ADDITIVE,text:"Add"}).appendTo(b),$("<option />",{value:a.SUBTRACTIVE,text:"Sub"}).appendTo(b),$("<option />",{value:a.MULTIPLY,text:"Mul"}).appendTo(b),$("<option />",{value:a.NORMAL,text:"Normal"}).appendTo(b),b.change(function(a){return function(){a.state.mode=parseInt(b.val()),a.state_changed(b),a.updated=!0}}(this)),b},E2.p.prototype.update_output=function(a){return this.state.mode},E2.p.prototype.state_changed=function(a){a&&a.val(""+this.state.mode)},E2.p=E2.plugins.triangle_modulator=function(a,b){this.desc="Triangle oscilator. A <b>time</b> value incrementing by one per second will yield a 1Hz output signal.",this.input_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"The current time in seconds.",def:0}],this.output_slots=[{name:"value"
,dt:a.datatypes.FLOAT,desc:"Emits ((0.5 - |(<b>time</b> % 1.0) - 0.5|) - 0.25) * 4.",def:0}]},E2.p.prototype.reset=function(){this.time=0,this.result=0},E2.p.prototype.update_input=function(a,b){this.time=b},E2.p.prototype.update_state=function(){this.result=(.5-Math.abs(this.time%1-.5)-.25)*4},E2.p.prototype.update_output=function(a){return this.result},E2.p=E2.plugins.light_clone_modulator=function(a,b){this.desc="Makes a physical copy of the input light reference, to allow side-effect free light chain branching.",this.input_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"Input light reference."}],this.output_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"The cloned light."}]},E2.p.prototype.update_input=function(a,b){var c=this.light;c.type=b.type,c.diffuse_color.clone(b.diffuse_color),c.specular_color.clone(b.specular_color),c.position[0]=b.position[0],c.position[1]=b.position[1],c.position[2]=b.position[2],c.direction[0]=b.direction[0],c.direction[1]=b.direction[1],c.direction[2]=b.direction[2],c.intensity=b.intensity},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(this.light=new Light)},E2.p.prototype.update_output=function(a){return this.light},E2.p.prototype.state_changed=function(a){a||(this.light=new Light)},E2.p=E2.plugins.mouse_position_generator=function(a,b){this.desc="Emits the current mouse position in unit space mapped to the canvas.",this.input_slots=[],this.output_slots=[{name:"x",dt:a.datatypes.FLOAT,desc:"0 at left edge of canvas and 1 at the right edge. Can be both smaller than 0 and larger than one if the mouse is outside the canvas bounds.",def:0},{name:"y",dt:a.datatypes.FLOAT,desc:"0 at top edge of canvas and 1 at the bottom edge. Can be both smaller than 0 and larger than one if the mouse is outside the canvas bounds.",def:0}]},E2.p.prototype.update_output=function(a){return a.index===0?this.x:this.y},E2.p.prototype.mouse_moved=function(a){return function(b){var c=E2.dom.webgl_canvas[0];a.x=(b.pageX-c.offsetLeft)/c.width,a.y=(b.pageY-c.offsetTop)/c.height,a.updated=!0}},E2.p.prototype.state_changed=function(a){a||(this.x=this.y=0,$(document).mousemove(this.mouse_moved(this)))},E2.p=E2.plugins.instance_clear_transform_modulator=function(a,b){this.desc="Clear or add user transforms to every instance in the supplied scene. This plugin must be applied before any subsequent transformation of instanced scenes.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The scene to to clear the transform of instances in."},{name:"driver",dt:a.datatypes.FLOAT,desc:"Since the instancing plugins do not regenerate the scene every frame, this plugin needs to be driven by another plugin delivering continous output, like a Clock. If the driver slot is not connected to a plugin delivering continous output, subsequent transforms will effectively be accumulative."}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The modified scene."}]},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.scene=null)},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.scene=b)},E2.p.prototype.update_state=function(){if(this.scene){var a=this.scene.meshes;for(var b=0,c=a.length;b<c;b++){var d=a[b];if(d.instance_transforms)for(var e=0,f=d.instances.length;e<f;e++)mat4.identity(d.instance_transforms[e]);else{d.instance_transforms=[];for(var e=0,f=d.instances.length;e<f;e++){var g=mat4.create();mat4.identity(g),d.instance_transforms.push(g)}}}}},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=null)},E2.p=E2.plugins.convert_vector_xyz_modulator=function(a,b){this.desc="Decompose a vector to its individual XYZ components so they can be manipulated individually.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Input vector.",def:"0, 0, 0"}],this.output_slots=[{name:"x",dt:a.datatypes.FLOAT,desc:"The x-component.",def:0},{name:"y",dt:a.datatypes.FLOAT,desc:"The y-component.",def:0},{name:"z",dt:a.datatypes.FLOAT,desc:"The z-component.",def:0}]},E2.p.prototype.reset=function(){this.value=[0,0,0]},E2.p.prototype.update_input=function(a,b){this.value=b},E2.p.prototype.update_output=function(a){return this.value[a.index]},E2.p=E2.plugins.color_add_modulator=function(a,b){this.desc="Adds a constant value to all components of a color. Each channel is clipped to the range 0;1.",this.input_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Input color."},{name:"value",dt:a.datatypes.FLOAT,desc:"Value to be added to the R, G and B channels."}],this.output_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Output color: R+V, G+V, B+V, A"}]},E2.p.prototype.reset=function(){this.color=new Color(1,1,1),this.output_color=new Color(1,1,1),this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.color=b:this.value=b},E2.p.prototype.update_state=function(){var a=this.color.rgba,b=this.output_color.rgba,c=this.value;for(var d=0;d<3;d++){var e=a[d]+c;b[d]=e<0?0:e>1?1:e}b[3]=a[4]},E2.p.prototype.update_output=function(a){return this.output_color},E2.p=E2.plugins.format_string_float=function(a,b){this.desc="Formats a float as a string.",this.input_slots=[{name:"float",dt:a.datatypes.FLOAT,desc:"Input float to be formatted.",def:0},{name:"decimals",dt:a.datatypes.FLOAT,desc:"Number of decimals to output.",def:4}],this.output_slots=[{name:"text",dt:a.datatypes.TEXT,desc:"The input float as a string.",def:'"0.0"'}]},E2.p.prototype.reset=function(){this.value=0,this.d_count=4,this.result="0.0"},E2.p.prototype.update_input=function(a,b){a.index===0?this.value=b:this.d_count=Math.round(b)},E2.p.prototype.update_state=function(){this.result=this.value.toFixed(this.d_count)},E2.p.prototype.update_output=function(a){return this.result},E2.p=E2.plugins.clock_generator=function(a,b){this.desc="Emits current absolute time in seconds.",this.input_slots=[],this.output_slots=[{name:"seconds",dt:a.datatypes.FLOAT,desc:"Current absolute time."}],this.core=a},E2.p.prototype.update_state=function(){this.updated=!0},E2.p.prototype.update_output=function(a){return this.core.abs_t},E2.p=E2.plugins.slider_float_generator=function(a,b){this.desc="Emits a user controllable float value between a specified minimum and maximum.",this.input_slots=[],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits the current value when the slider is adjusted.",def:0}],this.state={val:0,min:0,max:1},this.v_col=null,this.slider=null},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=make("table"),b=make("tr"),c=[make("td"),make("td"),make("td")],d=$('<input id="lo" type="text" style="width: 30px;" />'),e=$('<input id="hi" type="text" style="width: 30px;" />'),f=make("div");f.attr("id","sl"),f.css({width:"60px","margin-right":"5px","margin-left":"6px"}),a.css("width","150px"),a.addClass("pl_layout"),d.css("border","1px solid #999"),e.css("border","1px solid #999");var g=make("td");g.attr("colspan","3"),g.css("text-align","center"),f.slider({slide:function(a,b){return function(b,c){a.update_value(c.value),a.state.val=c.value}}(this,g),min:this.state.min,max:this.state.max,value:this.state.val,step:this.calc_step(),animate:!0}),a.append(b),b.append(c[0]),b.append(c[1]),b.append(c[2]),c[0].append(d),c[1].append(f),c[2].append(e);var h=function(b,c){var d=c.min>c.max;if(d){var e=c.min;c.min=c.max,c.max=e}c.val=c.val<c.min?c.min:c.val>c.max?c.max:c.val,d&&b.state_changed(a)},i=function(a,b,c){return function(){var d=parseFloat(b.val()),e=c.slider("option","value"),f=c.slider("option","min"),g=c.slider("option","max"),i=b.attr("id"),j=f,k=g,l=a.state;i=="lo"?(c.slider("option","min",d),l.min=d,j=d,h(a,l)):i=="hi"&&(c.slider("option","max",d),l.max=d,k=d,h(a,l)),c.slider("option","step",a.calc_step()),c.slider("option","value",l.val)}};d.blur(i(this,d,f)),e.blur(i(this,e,f));var j=make("tr");return j.append(g),g.append(),a.append(j),this.v_col=g,this.update_value(0),this.slider=f,a},E2.p.prototype.update_output=function(a){return this.state.val},E2.p.prototype.calc_step=function(){return(this.state.max-this.state.min)/100},E2.p.prototype.update_value=function(a){this.updated=!0,this.v_col.text(a.toFixed(2))},E2.p.prototype.state_changed=function(a){a&&(this.slider.slider("option","min",this.state.min),this.slider.slider("option","max",this.state.max),this.slider.slider("option","value",this.state.val),this.update_value(this.state.val),a.find("#lo").val(this.state.min),a.find("#hi").val(this.state.max))},E2.plugins.scene_renderer_emitter=function(a,b){var c=this,d=a.renderer.context;this.desc="Render the supplied <b>scene</b>. If no <b>shader</b> is specified, the internal shaders of the scene meshes are used.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The scene to be rendered.",def:"Render nothing."},{name:"material",dt:a.datatypes.MATERIAL,desc:"If a material is specified, internal shaders are generated to render each scene mesh using this material as an overload.",def:"Use scene materials and shaders."},{name:"camera",dt:a.datatypes.CAMERA,desc:"The camera to use for rendering.",def:"Screenspace camera."},{name:"transform",dt:a.datatypes.MATRIX,desc:"The scene transform to use for rendering.",def:"Identity"},{name:"inv. transform",dt:a.datatypes.BOOL,desc:"Send true to this slot to apply <b>transform</b> in inverse order when rendering instances.",def:"False"}],this.output_slots=[],this.reset=function(){c.scene=null,c.shader=null},this.update_input=function(a,b){if(a.index===0)b!==c.scene&&(c.scene=b,c.ext_camera||(c.camera=c.scene.create_autofit_camera()),c.material_dirty=!0);else if(a.index===1){c.material=b;var d=Material.get_caps_hash(null,b);c.material_caps!==d&&(c.material_caps=d,c.material_dirty=!0)}else a.index===2?(c.camera=b,c.ext_camera=!0):a.index===3&&(c.transform=b)},this.connection_changed=function(a,b,d){a||(d.index===0?(c.scene=null,c.material_dirty=!0):d.index===1?(c.material=null,c.material_caps="",c.overload_shaders=null):d.index===2&&(c.ext_camera=!1,c.scene&&(c.camera=c.scene.create_autofit_camera())))},this.update_state=function(){c.scene&&(c.material_dirty&&c.material&&(c.overload_shaders=c.scene.build_overload_shaders(c.material),c.material_dirty=!1),c.transform.invert=c.inv_transform,c.scene.render(d,c.camera,c.transform,c.overload_shaders,c.material))},this.state_changed=function(a){a||(c.material=null,c.material_caps="",c.material_dirty=!1,c.overload_shaders=null,c.camera=new Camera,c.transform=mat4.create(),mat4.identity(c.transform),c.ext_camera=!1,c.inv_transform=!1)}},E2.p=E2.plugins.video_player=function(a,b){this.desc="Play a video stream. Playback loops by default.",this.input_slots=[{name:"video",dt:a.datatypes.VIDEO,desc:"The video stream to play."},{name:"play",dt:a.datatypes.BOOL,desc:"Send true to start playback and false to stop.",def:!1},{name:"muted",dt:a.datatypes.BOOL,desc:"Is audio muted?",def:!0},{name:"volume",dt:a.datatypes.FLOAT,desc:"Set playback volume.",lo:0,hi:0,def:.5},{name:"time",dt:a.datatypes.FLOAT,desc:"Set playback time."}],this.output_slots=[{name:"texture",dt:a.datatypes.TEXTURE,desc:"The current video frame."}],this.node=b,this.video=null,this.playing=!1,this.should_play=!1,this.muted=!0,this.volume=.5,this.time=null,this.texture=new Texture(a.renderer.context)},E2.p.prototype.play=function(){this.video&&!this.playing&&this.should_play&&(this.playing=this.should_play=!0,this.video.play())},E2.p.prototype.pause=function(){this.video&&this.playing&&(this.playing=!1,this.should_play=!0,this.video.pause())},E2.p.prototype.stop=function(){this.video&&(this.playing&&(this.playing=this.should_play=!1,this.video.pause()),this.video.currentTime=0)},E2.p.prototype.update_input=function(a,b){a.index===0?(this.video=b,this.playing=!1):a.index===1?this.should_play=b:a.index===2?this.muted=b:a.index===3?this.volume=b<0?0:b>1?1:b:a.index===4&&(this.time=b)},E2.p.prototype.update_state=function(){var a=this.video;this.playing!==this.should_play&&a&&(this.should_play?a.play():a.pause(),this.playing=this.should_play);if(!this.playing)return;a&&(a.videoWidth>0&&a.videoHeight>0&&this.texture.upload(a),a.muted=this.muted,a.volume=this.volume,this.time&&(a.currentTime=this.time,this.time=null)),this.updated=!0},E2.p.prototype.update_output=function(a){return this.node.queued_update=1,this.texture},E2.p=E2.plugins.material_blend_mode_modulator=function(a,b){this.desc="Set the blend mode.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"blend mode",dt:a.datatypes.FLOAT,desc:"Set the material blend mode.",def:"Normal"}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:this.blend_mode=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=new Material)},E2.p.prototype.update_state=function(){this.material.blend_mode=this.blend_mode},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.blend_mode=Renderer.blend_mode.NORMAL)},E2.p=E2.plugins.material_clone_modulator=function(a,b){this.desc="Makes a physical copy of the input material reference, to allow side-effect free material chain branching.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material reference."}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The cloned material."}]},E2.p.prototype.update_input=function(a,b){var c=this.material;c.t_cache=b.t_cache,c.depth_test=b.depth_test,c.depth_write=b.depth_write,c.depth_func=b.depth_func,c.alpha_clip=b.alpha_clip,c.shinyness=b.shinyness,c.double_sided=b.double_sided,c.blend_mode=b.blend_mode,c.ambient_color.clone(b.ambient_color),c.diffuse_color.clone(b.diffuse_color),c.textures=b.textures.slice(0),c.lights=b.lights.slice(0)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(this.material=new Material)},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material)},E2.p=E2.plugins.material_z_buffer_modulator=function(a,b){this.desc="En- or disables depth buffer test, and write.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"depth test",dt:a.datatypes.BOOL,desc:"Set to true to discard behind the one already in the buffer.",def:"True"},{name:"depth write",dt:a.datatypes.BOOL,desc:"Set to false to stop writing fragment depth to the z-buffer.",def:"True"},{name:"depth func",dt:a.datatypes.FLOAT,desc:"Set z-buffer test function.",def:"Less than or equal"}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:a.index===1?this.depth_test=b:a.index===2?this.depth_write=b:a.index===3&&(this.depth_func=b<0?0:b%Material.depth_func.COUNT)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=new Material)},E2.p.prototype.update_state=function(){this.material.depth_test=this.depth_test,this.material.depth_write=this.depth_write,this.material.depth_func=this.depth_func},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.depth_test=!0,this.depth_write=!0,this.depth_func=Material.depth_func.LEQUAL)},E2.p=E2.plugins.absolute_modulator=function(a,b){this.desc="Emit the absolute value of the input.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Positive or negative input value",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"Positive output value",def:0}]},E2.p.prototype.reset=function(){this.input_val=0,this.output_val=0},E2.p.prototype.update_input=function(a,b){this.input_val=b},E2.p.prototype.update_state=function(){this.output_val=Math.abs(this.input_val)},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.material_diffuse_color_modulator=function(a,b){this.desc="Set the diffuse color.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"color",dt:a.datatypes.COLOR,desc:"The material diffuse color.",def:"White"}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:this.color=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=new Material)},E2.p.prototype.update_state=function(){this.material.diffuse_color=this.color},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.color=new Color(1,1,1,1))},E2.p=E2.plugins.instance_array_modulator=function(a,b){this.desc="Create a scene that represents <b>count</b> instances of the supplied <b>mesh</b>, starting at position <b>start</b>, offset by <b>delta</b> each instance.",this.input_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"The number of instances to create.",lo:0,def:1},{name:"mesh",dt:a.datatypes.MESH,desc:"The mesh to instantiate."},{name:"start",dt:a.datatypes.VECTOR,desc:"The starting position.",def:"0, 0, 0"},{name:"offset",dt:a.datatypes.VECTOR,desc:"The offset vector.",def:"0, 0, 0"}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"Scene representing <b>count</b> instances."}],this.gl=a.renderer.context},E2.p.prototype.update_input=function(a,b){if(a.index===0)this.count=b;else if(a.index===1){var c=this.scene=new Scene(this.gl,null,null);c.meshes=[b],c.vertex_count=b.vertex_count}else a.index===2?this.start=b:this.offset=b},E2.p.prototype.update_state=function(){var a=this.scene,b=a.meshes[0],c=this.start,d=this.offset,e=[],f=c.slice(0);for(var g=0;g<this.count;g++){var h=mat4.create();mat4.identity(h),mat4.translate(h,f),e.push(h),f[0]+=d[0],f[1]+=d[1],f[2]+=d[2]}b.instances=e,b.instance_transforms=null},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=new Scene(this.gl,null,null),this.count=1,this.start=[0,0,0],this.offset=[0,0,0])},E2.p=E2.plugins.vector_normalize=function(a,b){this.desc="Emit a normalized version of the supplied vector with a magnitude of 1.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The input vector to be normalised.",def:"0, 0, 0"}],this.output_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Emits the normalised input vector.",def:"0, 0, 0"}]},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.vector=b)},E2.p.prototype.update_state=function(){var a=this.vector[0],b=this.vector[1],c=this.vector[2],d=this.normalized,e=Math.sqrt(a*a+b*b+c*c);e?e===1?(d[0]=a,d[1]=b,d[2]=c):(e=1/e,d[0]=a*e,d[1]=b*e,d[2]=c*e):(d[0]=0,d[1]=0,d[2]=0)},E2.p.prototype.update_output=function(a){return this.normalized},E2.p.prototype.state_changed=function(a){a||(this.vector=[0,0,0],this.normalized=[0,0,0])},E2.p=E2.plugins.sine_modulator=function(a,b){this.desc="Sine oscilator. A <b>time</b> value incrementing by one per second will yield a 1Hz output signal.",this.input_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Time in seconds.",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits sin(<b>time</b> * 2pi).",def:0}]},E2.p.prototype.reset=function(){this.time=0,this.result=0},E2.p.prototype.update_input=function(a,b){this.time=b},E2.p.prototype.update_state=function(){this.result=Math.sin(this.time*2*Math.PI)},E2.p.prototype.update_output=function(a){return this.result},E2.p=E2.plugins.round_modulator=function(a,b){this.desc="Emits the input <b>value</b> rounded to the nearest integer.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The input value to be rounded.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The rounded integer.",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){this.value=Math.round(b)},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.led_display=function(a,b){this.desc="Displays the supplied normalised float value as a red LED, with a 8 bit color granularity.",this.input_slots=[{name:"float",dt:a.datatypes.FLOAT,desc:"Normalised input value.",lo:0,hi:1,def:0}],this.output_slots=[]},E2.p.prototype.reset=function(){this.update_value(0)},E2.p.prototype.create_ui=function(){return this.label=make("span"),this.label.html("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"),this.update_value(0),this.label},E2.p.prototype.connection_changed=function(a,b,c){a||this.update_value(0)},E2.p.prototype.update_input=function(a,b){this.update_value(b<0?0:b>1?1:b)},E2.p.prototype.update_value=function(a){this.label&&this.label.css("background-color","rgb("+Math.round(a*255)+", 40, 40)")},E2.p=E2.plugins.lowpass_filter_modulator=function(a,b){this.desc="Perform simple 1st-order lowpass filtering of the supplied value.\n\n<b>Caution:</b> Do not use this plugin to filter infrequently updated values. This plugin expects continuous input every frame; if necessary, a clock or another cheap continuous float provider can be multiplied by zero and added to the lowpass input to drive updates.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value. Must be updated every frame for correct operation of the filter.",def:0},{name:"amount",dt:a.datatypes.FLOAT,desc:"Filter amount. Zero is pure passthrough, 0.999 maximum filtering.",lo:0,hi:.999,def:.9}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The smoothed output value",def:0}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.input_val=b:this.amount=b<0?0:b>.999?.999:b},E2.p.prototype.update_state=function(){this.output_val=this.input_val*(1-this.amount)+this.last_val*this.amount,this.last_val=this.output_val},E2.p.prototype.update_output=function(a){return this.output_val},E2.p.prototype.state_changed=function(a){a||(this.input_val=0,this.amount=.9,this.output_val=0,this.last_val=0)},E2.p=E2.plugins.more_than_modulator=function(a,b){this.desc="Emits true if the supplied <b>value</b> is larger than <b>reference</b> and false otherwise.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value to be compared.",def:0},{name:"reference",dt:a.datatypes.FLOAT,desc:"Reference to compare <b>value</b> to.",def:0}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Emits true if <b>value</b> is larger than <b>reference</b>.",def:!1}]},E2.p.prototype.reset=function(){this.value=0,this.ref=0,this.state=null},E2.p.prototype.update_input=function(a,b){a.index===0?this.value=b:this.ref=b},E2.p.prototype.update_state=function(){var a=this.value>this.ref;a!==this.state?this.state=a:this.updated=!1},E2.p.prototype.update_output=function(a){return this.state},E2.p=E2.plugins.material_shinyness_modulator=function(a,b){this.desc="Set the specularity coefficient.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"shinyness",dt:a.datatypes.FLOAT,desc:"Higher values indicates higher specularity.",def:0,lo:0,hi:10}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:this.shinyness=b<0?0:b>10?10:b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=new Material)},E2.p.prototype.update_state=function(){this.material.shinyness=this.shinyness},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.shinyness=1)},E2.p=E2.plugins.assets_started_generator=function(a,b){this.desc="Emits the current number of assets that have begun loading.",this.input_slots=[],this.output_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"Number of assets that have begun loading."}],this.core=a,this.node=b,this.asset_listener=function(a){return function(){a.node.queued_update=1}}(this),a.asset_tracker.add_listener(this.asset_listener)},E2.p.prototype.reset=function(){},E2.p.prototype.destroy=function(){this.core.asset_tracker.remove_listener(this.asset_listener)},E2.p.prototype.update_output=function(a){return this.core.asset_tracker.started},E2.p=E2.plugins.vector_display=function(a,b){this.desc="Displays the supplied vector as a three-cell row of values.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The vector to be displayed."}],this.output_slots=[]},E2.p.prototype.reset=function(){this.vec=["-","-","-"],this.update_values()},E2.p.prototype.create_ui=function(){var a=make("table"),b=make("tr"),c={"text-align":"right","padding-left":"10px"};this.columns=[make("td"),make("td"),make("td")];for(var d=0;d<3;d++){var e=this.columns[d];e.text(this.vec[d]),e.css(c),b.append(e)}return a.append(b),a},E2.p.prototype.connection_changed=function(a,b,c){a||self.reset(null)},E2.p.prototype.update_input=function(a,b){for(var c=0;c<3;c++)this.vec[c]=b[c].toFixed(2);this.update_values()},E2.p.prototype.update_values=function(){if(!this.columns)return;for(var a=0;a<3;a++)this.columns[a].text(this.vec[a])},E2.p=E2.plugins.video_get_duration_modulator=function(a,b){this.desc="Get the duration of the supplied video in seconds.",this.input_slots=[{name:"video",dt:a.datatypes.VIDEO,desc:"Input video."}],this.output_slots=[{name:"duration",dt:a.datatypes.FLOAT,desc:"Duration in seconds.",def:0}]},E2.p.prototype.reset=function(){this.duration=0},E2.p.prototype.update_input=function(a,b){this.duration=b.duration},E2.p.prototype.update_output=function(a){return this.duration},E2.p=E2.plugins.min_modulator=function(a,b){this.desc="Emit the lesser of the two input values.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The first input value",def:0},{name:"value",dt:a.datatypes.FLOAT,desc:"The second input value",def:0}],this.output_slots=[{name:"min",dt:a.datatypes.FLOAT,desc:"The smaller of the two supplied values.",def:0}]},E2.p.prototype.reset=function(){this.val_a=0,this.val_b=0,this.output_val=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.val_a=b:this.val_b=b},E2.p.prototype.update_state=function(){this.output_val=Math.min(this.val_a,this.val_b)},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.alpha_modulator=function(a,b){this.desc="Changes the alpha component of the supplied <b>color</b> to the supplied <b>alpha</b>.",this.input_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Input color with any alpha value"},{name:"alpha",dt:a.datatypes.FLOAT,desc:"Replacement alpha value",lo:0,hi:1,def:1}],this.output_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Emits the input <b>color</b> with the A-channel replaced by <b>alpha</b>."}]},E2.p.prototype.reset=function(){this.color=new Color(1,1,1)},E2.p.prototype.update_input=function(a,b){var c=this.color.rgba;a.index===0?(c[0]=b.rgba[0],c[1]=b.rgba[1],c[2]=b.rgba[2]):c[3]=b},E2.p.prototype.update_output=function(a){return this.color},E2.p=E2.plugins.register_global_write=function(a,b){this.desc="Write to a local register using name of the node, the value of which can subsequently be read.",this.input_slots=[],this.output_slots=[],this.state={slot_id:b.add_slot(E2.slot_type.input,{name:"value",dt:a.datatypes.ANY,desc:""})},this.core=a,this.node=b,b.title?this.old_title=b.title:this.old_title=b.title="reg_"+b.uid},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.destroy=function(){this.regs.unlock(this,this.node.title)},E2.p.prototype.register_dt_changed=function(a){this.node.change_slot_datatype(E2.slot_type.input,this.state.slot_id,a)},E2.p.prototype.renamed=function(){this.regs.unlock(this,this.old_title),this.regs.lock(this,this.node.title)},E2.p.prototype.connection_changed=function(a,b,c){var d=this.regs.connection_changed(this.node.title,a);a&&d===1&&this.regs.set_datatype(this.node.title,b.src_slot.dt)},E2.p.prototype.update_input=function(a,b){this.regs.write(this.node.title,b)},E2.p.prototype.target_reg=function(a){var b=this.node.find_dynamic_slot(E2.slot_type.input,this.state.slot_id);this.regs.lock(this,a);var c=this.regs.registers[a].dt;c!==this.core.datatypes.ANY&&this.register_dt_changed(b.dt)},E2.p.prototype.state_changed=function(a){a?this.node.ui.dom.addClass("register"):(this.regs=this.core.registers,this.target_reg(this.node.title))},E2.p=E2.plugins.color_picker=function(a,b){this.desc="Provides an intuitive way of picking arbitary colors via a hue slider and saturation / luminosity selection area.",this.input_slots=[],this.output_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"The selected color.",def:"White"}],this.state={hue:0,sat:0,lum:1}},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=this.c=make("div"),b=this.i=make("img"),c=this.s=make("img"),d=this.h=make("img"),e=this.hs=make("img");a.css({width:"130px",height:"102px","margin-right":"10px",position:"relative"}),d.attr("src","images/color_picker/hue.png"),d.attr("id","hue"),c.attr("src","images/color_picker/select.gif"),c.attr("id","sel"),e.attr("src","images/color_picker/hue-select.png"),e.attr("id","hue-sel"),b.attr("src","images/color_picker/picker.png"),b.attr("id","img"),d.css({width:"14px",height:"100px",border:"1px solid #888",cursor:"crosshair","z-index":"100"}),e.css({position:"absolute",top:"0px",left:"114px",width:"20px",height:"5px",cursor:"crosshair","z-index":"101"}),c.css({width:"11px",height:"11px",cursor:"crosshair","z-index":"101",position:"absolute"}),b.css({width:"100px",height:"100px",border:"1px solid #888",cursor:"crosshair","z-index":"100","background-color":"#f00"}),a.append(b),a.append(c),a.append(d),a.append(e);var f=function(a,b,c,d){return function(e){a.color_drag=!0,a.update_picker_ev(e,b,d,c)}}(this,a,b,c),g=function(a){return function(b){b.preventDefault(),a.color_drag=!1}}(this),h=function(a,b,c,d){return function(e){a.update_picker_ev(e,b,d,c),a.color_clipped=a.clip(e,c)}}(this,a,b,c);c.mousedown(f),c.mouseup(g),c.mousemove(h),b.mousedown(f),b.mouseup(g),b.mousemove(h);var i=function(a,b,c,d,e){return function(f){f.preventDefault(),a.hue_drag=!0,a.update_hue_ev(b,f,c,d,e)}}(this,a,b,d,e),j=function(a){return function(b){b.preventDefault(),a.hue_drag=!1}}(this),k=function(a,b,c,d,e){return function(f){a.update_hue_ev(b,f,c,d,e),a.hue_clipped=a.clip(f,d)}}(this,a,b,d,e);return e.mousedown(i),e.mouseup(j),e.mousemove(k),d.mousedown(i),d.mouseup(j),d.mousemove(k),a},E2.p.prototype.update_state=function(){this.update_value(this.c)},E2.p.prototype.update_output=function(a){return this.color},E2.p.prototype.update_value=function(a){var b=this.state.sat,c=this.state.lum,d=[this.hue_rgb[0]/255,this.hue_rgb[1]/255,this.hue_rgb[2]/255],e=c*(1-b),f=function(a){return e+d[a]*c*b},g=function(a){return Math.floor(d[a]*255)};d=[f(0),f(1),f(2)];var h=this.color?this.color.rgba:null;if(!h||h[0]!==d[0]||h[1]!==d[1]||h[2]!==d[2])h[0]=d[0],h[1]=d[1],h[2]=d[2],this.updated=!0;a&&a.css("background-color","rgb("+g(0)+", "+g(1)+", "+g(2)+")")},E2.p.prototype.update_picker_ev=function(a,b,c,d){a.preventDefault();if(!this.color_drag||this.color_clipped)return;var e=d.offset(),f=this.state;f.sat=(a.pageX-e.left)/100,f.lum=1-(a.pageY-e.top)/100,f.sat=f.sat<0?0:f.sat>1?1:f.sat,f.lum=f.lum<0?0:f.lum>1?1:f.lum,this.update_picker(b,c)},E2.p.prototype.update_picker=function(a,b){b.css("left",Math.floor(this.state.sat*100)-5),b.css("top",Math.floor((1-this.state.lum)*100)-5),this.update_value(a)},E2.p.prototype.update_hue_ev=function(a,b,c,d,e){b.preventDefault();if(!this.hue_drag||this.hue_clipped)return;this.state.hue=(b.pageY-d.offset().top)/100,this.update_hue(a,c,d,e)},E2.p.prototype.update_hue=function(a,b,c,d){var e=1-this.state.hue,f=1,g=0,h=[e+1/3,e,e-1/3],i=[0,0,0];for(var j=0;j<3;j++){h[j]<0?h[j]+=1:h[j]>1&&(h[j]-=1);var k=h[j];6*k<1?i[j]=k*6:2*k<1?i[j]=1:3*k<2?i[j]=(2/3-k)*6:i[j]=g,i[j]=Math.floor(i[j]*255)}this.hue_rgb=i,b&&b.css("background-color","rgb("+i[0]+", "+i[1]+", "+i[2]+")");if(c&&d){var l=c.offset();d.css("left",l.left-b.offset().left),d.css("top",Math.floor(this.state.hue*100-2))}this.update_value(a)},E2.p.prototype.clip=function(a,b){var c=b.offset();return a.pageX<c.left||a.pageX>c.left+b.width()||a.pageY<c.top||a.pageY>c.top+b.height()},E2.p.prototype.state_changed=function(a){a?(this.update_hue(a,a.find("#img"),a.find("#hue"),a.find("#hue-sel")),this.update_picker(a,a.find("#sel"))):(this.hue_rgb=[255,0,0],this.hue_drag=!1,this.color_drag=!1,this.hue_clipped=!1,this.color_clipped=!1,this.color=new Color(1,1,1,1),this.update_hue(null,null,null,null))},E2.p=E2.plugins
.material_texture_modulator=function(a,b){this.desc="Sets a material texture.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"type",dt:a.datatypes.FLOAT,desc:"The type of texture to use the supplied <b>texture</b> as. See also Generators/Values/Texture type.",def:"Diffuse color"},{name:"texture",dt:a.datatypes.TEXTURE,desc:"A texture.",def:"None."}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:a.index===1?this.next_type=b<0?0:b%Material.texture_type.COUNT:a.index===2&&(this.texture=b)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?this.material=new Material:c.index===2&&(this.texture=null))},E2.p.prototype.update_state=function(){this.type!==-1&&(this.material.textures[this.type]=null),this.material.textures[this.next_type]=this.texture,this.type=this.next_type},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.type=-1,this.next_type=Material.texture_type.DIFFUSE_COLOR,this.texture=null)},E2.p=E2.plugins.if_else_modulator=function(a,b){this.desc="Emits <b>true value</b> if <b>condition</b> is true and <b>false value</b> otherwise. The output only updates when the <b>condition</b> or relavant input value does. Any incoming data-flow to the value slot excluded by <b>condition</b> does not result in data emission.",this.input_slots=[{name:"condition",dt:a.datatypes.BOOL,desc:"Send true to route <b>true value</b> to the output and false to route <b>false value</b>.",def:"False"},{name:"true value",dt:a.datatypes.FLOAT,desc:"Value to be send to output if <b>condition</b> is true",def:0},{name:"false value",dt:a.datatypes.FLOAT,desc:"Value to be send to output if <b>condition</b> is false",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits <b>true value</b> if <b>condition</b> is true and <b>false value</b> otherwise.",def:"False value"}]},E2.p.prototype.reset=function(){this.condition=!1,this.yes=0,this.no=0,this.upd_state=[!1,!1,!1]},E2.p.prototype.update_input=function(a,b){a.index===0?this.condition=b:a.index===1?this.yes=b:this.no=b,this.upd_state[a.index]=!0},E2.p.prototype.update_state=function(){var a=this.upd_state;this.updated=a[0]||a[this.condition?1:2],a[0]=a[1]=a[2]=!1},E2.p.prototype.update_output=function(a){return this.condition?this.yes:this.no},E2.p=E2.plugins.vector_dot=function(a,b){this.desc="Emits the dot products of the two supplied vectors.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The first operand.",def:"0, 0, 0"},{name:"vector",dt:a.datatypes.VECTOR,desc:"The second operand.",def:"0, 0, 0"}],this.output_slots=[{name:"float",dt:a.datatypes.FLOAT,desc:"Emits F dot S.",def:"0.0"}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.vector_a=b:a.index===1&&(this.vector_b=b)},E2.p.prototype.update_state=function(){this.result=vec3.dot(this.vector_a,this.vector_b)},E2.p.prototype.update_output=function(a){return this.result},E2.p.prototype.state_changed=function(a){a||(this.vector_a=[0,0,0],this.vector_b=[0,0,0],this.result=0)},E2.p=E2.plugins.float_display=function(a,b){this.desc="Display the supplied float value on the plugin surface.",this.input_slots=[{name:"float",dt:a.datatypes.FLOAT,desc:"Input value to be displayed."}],this.output_slots=[]},E2.p.prototype.reset=function(){this.update_value(null)},E2.p.prototype.create_ui=function(){return this.label=make("div"),this.label.css("text-align","right"),this.update_value(null),this.label},E2.p.prototype.connection_changed=function(a,b,c){a||this.update_value(null)},E2.p.prototype.update_input=function(a,b){this.update_value(b)},E2.p.prototype.update_value=function(a){this.label&&(this.label[0].innerHTML=a===null?"-":a.toFixed(2))},E2.p=E2.plugins.vector_transform=function(a,b){this.desc="Transform a vector by the supplied matrix.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Input vector to transform.",def:"0, 0, 0"},{name:"matrix",dt:a.datatypes.MATRIX,desc:"Transformation matrix to multiply the vector by.",def:"Identity"}],this.output_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Emits the transformed input vector.",def:"0, 0, 0"}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.vector=b:a.index===1&&(this.matrix=b)},E2.p.prototype.update_state=function(){mat4.multiplyVec3(this.matrix,this.vector,this.transformed)},E2.p.prototype.update_output=function(a){return this.transformed},E2.p.prototype.state_changed=function(a){a||(this.vector=[0,0,0],this.transformed=[0,0,0],this.matrix=mat4.create(),mat4.identity(this.matrix))},E2.p=E2.plugins.log_modulator=function(a,b){this.desc="Log(x).",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"log(<b>value</b>).",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=Math.log(b))},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.light_position_modulator=function(a,b){this.desc="Sets the position of the light source to a given vector.",this.input_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"Input light."},{name:"position",dt:a.datatypes.VECTOR,desc:"The light position.",def:"0, 1, 0"}],this.output_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"The modified light."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.light=b:this.position=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.light=new Light)},E2.p.prototype.update_state=function(){this.light.position=this.position},E2.p.prototype.update_output=function(a){return this.light},E2.p.prototype.state_changed=function(a){a||(this.light=new Light,this.position=[0,1,0])},E2.p=E2.plugins.depth_func_generator=function(a,b){this.desc="Select z-buffer depth compare function.",this.input_slots=[],this.output_slots=[{name:"func",dt:a.datatypes.FLOAT,desc:"Emits the selected depth function when requested or the selection state changes.",def:"Diffuse color"}],this.state={depth_func:Material.depth_func.LEQUAL}},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=Material.depth_func,b=$("<select />",{selectedIndex:4});return $("<option />",{value:a.NEVER,text:"Never"}).appendTo(b),$("<option />",{value:a.LESS,text:"Less"}).appendTo(b),$("<option />",{value:a.EQUAL,text:"Equal"}).appendTo(b),$("<option />",{value:a.LEQUAL,text:"Less / equal"}).appendTo(b),$("<option />",{value:a.GREATER,text:"Greater"}).appendTo(b),$("<option />",{value:a.NOTEQUAL,text:"Not equal"}).appendTo(b),$("<option />",{value:a.GEQUAL,text:"Greater / equal"}).appendTo(b),$("<option />",{value:a.ALWAYS,text:"Always"}).appendTo(b),b.change(function(a){return function(){a.state.depth_func=parseInt(b.val()),a.state_changed(b),a.updated=!0}}(this)),b},E2.p.prototype.update_output=function(a){return this.state.depth_func},E2.p.prototype.state_changed=function(a){a&&a.val(""+this.state.depth_func)},E2.p=E2.plugins.mouse_wheel_generator=function(a,b){this.desc="Emits the current mouse wheel state.",this.input_slots=[],this.output_slots=[{name:"delta",dt:a.datatypes.FLOAT,desc:"The delta mouse wheel movement.",def:0}]},E2.p.prototype.update_output=function(a){return this.delta},E2.p.prototype.mouse_wheel=function(a){return function(b,c){a.delta=-c,a.updated=!0}},E2.p.prototype.state_changed=function(a){a||(this.delta=0,E2.dom.webgl_canvas.bind("mousewheel",this.mouse_wheel(this)))},E2.p=E2.plugins.concatenate_matrix_modulator=function(a,b){this.desc="Combine two matrices. Order is significant.",this.input_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The first matrix operand."},{name:"matrix",dt:a.datatypes.MATRIX,desc:"The second matrix operand."}],this.output_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"Emits <b>first</b> * <b>second</b>."}]},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&mat4.identity(this.matrices[c.index])},E2.p.prototype.update_input=function(a,b){this.matrices[a.index]=b},E2.p.prototype.update_state=function(){var a=this.matrices;if(a[0]===null||a[1]===null)return;mat4.multiply(a[0],a[1],this.matrix)},E2.p.prototype.update_output=function(a){return this.matrix},E2.p.prototype.state_changed=function(a){a||(this.matrices=[mat4.create(),mat4.create()],this.matrix=mat4.create(),mat4.identity(this.matrices[0]),mat4.identity(this.matrices[1]),mat4.identity(this.matrix))},E2.p=E2.plugins.text_display=function(a,b){this.desc="Display the supplied text value on the plugin surface.",this.input_slots=[{name:"text",dt:a.datatypes.TEXT,desc:"Input text to be displayed."}],this.output_slots=[]},E2.p.prototype.reset=function(){this.update_value(null)},E2.p.prototype.create_ui=function(){return this.label=make("div"),this.label},E2.p.prototype.connection_changed=function(a,b,c){a||this.update_value("")},E2.p.prototype.update_input=function(a,b){this.update_value(b)},E2.p.prototype.update_value=function(a){this.label&&(this.label[0].innerHTML=a)},E2.p=E2.plugins.vector_multiply=function(a,b){this.desc="Multiples the X, Y and Z components of the supplied vectors and emits the result.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The first operand.",def:"0, 0, 0"},{name:"vector",dt:a.datatypes.VECTOR,desc:"The second operand.",def:"0, 0, 0"}],this.output_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Emits Fx * Sx, Fy * Sy, Fz * Sz.",def:"0, 0, 0"}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.vector_a=b:a.index===1&&(this.vector_b=b)},E2.p.prototype.update_state=function(){var a=this.result,b=this.vector_a,c=this.vector_a;a[0]=b[0]*c[0],a[1]=b[1]*c[1],a[2]=b[2]*c[2]},E2.p.prototype.update_output=function(a){return this.result},E2.p.prototype.state_changed=function(a){a||(this.vector_a=[0,0,0],this.vector_b=[0,0,0],this.result=[0,0,0])},E2.p=E2.plugins.audio_get_current_time_modulator=function(a,b){this.desc="Get the current playback time of the supplied audio sample in seconds.",this.input_slots=[{name:"audio",dt:a.datatypes.AUDIO,desc:"Input audio sample."}],this.output_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Current playback time.",def:0}]},E2.p.prototype.reset=function(){this.time=0,this.audio=null},E2.p.prototype.update_input=function(a,b){this.audio=b},E2.p.prototype.update_output=function(a){return this.updated=!0,this.audio?this.audio.currentTime:0},E2.p=E2.plugins.light_intensity_modulator=function(a,b){this.desc="Sets the intensity of the light source to a given factor.",this.input_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"Input light."},{name:"intensity",dt:a.datatypes.FLOAT,desc:"The light intensity.",def:1,lo:0}],this.output_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"The modified light."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.light=b:this.intensity=b<0?0:b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.light=new Light)},E2.p.prototype.update_state=function(){this.light.intensity=this.intensity},E2.p.prototype.update_output=function(a){return this.light},E2.p.prototype.state_changed=function(a){a||(this.light=new Light,this.intensity=1)},E2.p=E2.plugins.square_modulator=function(a,b){this.desc="Square oscilator. A <b>time</b> value incrementing by one unit per second will yield a 1Hz output signal.",this.input_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Time in seconds.",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits 1 if <b>time</b> % 1 is less than 0.5 and -1 otherwise.",def:0}]},E2.p.prototype.reset=function(){this.time=0,this.result=0},E2.p.prototype.update_input=function(a,b){this.time=b},E2.p.prototype.update_state=function(){this.result=this.time%1<.5?1:-1},E2.p.prototype.update_output=function(a){return this.result},E2.p=E2.plugins.accumulate_modulator=function(a,b){this.desc="Every input <b>value</b> is accumulated in an internal buffer (which resets to zero on playback stop).",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"A small value to be accumulated in an internal buffer.",def:0},{name:"reset",dt:a.datatypes.FLOAT,desc:"Send a value to this slot to reset the accumulator to that value.",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The current value of the accumulation buffer.",def:0}],this.state={value:0}},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.update_input=function(a,b){a.index===0?this.state.value+=b:this.state.value=b},E2.p.prototype.update_output=function(a){return this.state.value},E2.p=E2.plugins.convert_color_rgba_modulator=function(a,b){this.desc="Convert a color to its individual RGBA components so they can be individually manipulated.",this.input_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Input color to be split.",def:"White"}],this.output_slots=[{name:"red",dt:a.datatypes.FLOAT,desc:"Red channel value.",def:1},{name:"green",dt:a.datatypes.FLOAT,desc:"Green channel value.",def:1},{name:"blue",dt:a.datatypes.FLOAT,desc:"Blue channel value.",def:1},{name:"alpha",dt:a.datatypes.FLOAT,desc:"Alpha channel value.",def:1}]},E2.p.prototype.reset=function(){this.color=new Color(1,1,1,1)},E2.p.prototype.update_input=function(a,b){this.color=b},E2.p.prototype.update_output=function(a){return this.color.rgba[a.index]},E2.p=E2.plugins.add_modulator=function(a,b){this.desc="Add two floating point values.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The first operand.",def:0},{name:"value",dt:a.datatypes.FLOAT,desc:"The second operand.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The result of <b>first</b> + <b>second</b>.",def:0}]},E2.p.prototype.reset=function(){this.input_val=0,this.add_val=0,this.output_val=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.input_val=b:this.add_val=b},E2.p.prototype.update_state=function(){this.output_val=this.input_val+this.add_val},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.scene_get_mesh_by_index=function(a,b){this.desc="Extract a single <b>mesh</b> from a <b>scene</b> by <b>index</b> so it can be rendered individually.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The scene to extract a mesh reference from."},{name:"index",dt:a.datatypes.FLOAT,desc:"The desired mesh index."}],this.output_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"The extracted mesh reference."}]},E2.p.prototype.reset=function(){this.changed=!0},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?this.scene=null:c.index===1&&(this.index=0))},E2.p.prototype.update_input=function(a,b){a.index===0?this.scene=b:a.index===1&&(this.index=Math.floor(b<0?-b:b))},E2.p.prototype.update_state=function(){if(this.scene){var a=this.scene.meshes,b=a.length;if(b<1)return;var c=a[this.index%b];if(c!==this.mesh){this.mesh=c;return}}this.changed||(this.updated=!1),this.changed=!1},E2.p.prototype.update_output=function(a){return this.mesh},E2.p.prototype.state_changed=function(a){a||(this.scene=null,this.index=0,this.mesh=null,this.changed=!0)},E2.p=E2.plugins.audio_get_duration_modulator=function(a,b){this.desc="Get the duration of the supplied audio sample in seconds.",this.input_slots=[{name:"audio",dt:a.datatypes.AUDIO,desc:"Input audio sample."}],this.output_slots=[{name:"duration",dt:a.datatypes.FLOAT,desc:"Duration in seconds.",def:0}]},E2.p.prototype.reset=function(){this.duration=0},E2.p.prototype.update_input=function(a,b){this.duration=b.duration},E2.p.prototype.update_output=function(a){return this.duration},E2.p=E2.plugins.planar_projection_matrix=function(a,b){this.desc="Create a matrix that represent a planar projection.",this.input_slots=[{name:"plane offset",dt:a.datatypes.FLOAT,desc:"Plane offset from the origin.",def:"0, 0, 0"},{name:"plane normal",dt:a.datatypes.VECTOR,desc:"Plane orientation.",def:"0, 0, -1"},{name:"light pos",dt:a.datatypes.VECTOR,desc:"Light position in world space.",def:"0, 0, -2"}],this.output_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The resulting projection matrix.",def:"Identity"}]},E2.p.prototype.reset=function(){this.plane_offset=0,this.plane_normal=[0,0,-1],this.light_pos=[0,0,-2],this.matrix=mat4.create(),mat4.identity(this.matrix)},E2.p.prototype.update_input=function(a,b){a.index===0?this.plane_offset=b:a.index===1?this.plane_normal=b:a.index===1&&(this.light_pos=b)},E2.p.prototype.update_state=function(){var a=this.plane_normal,b=this.light_pos,c=this.matrix,d=this.plane_offset,e=a[0]*b[0]+a[1]*b[1]+a[2]*b[2];e=e>0?1/e:1,c[0]=1-a[0]*b[0]*e,c[4]=-a[0]*b[1]*e,c[8]=-a[0]*b[2]*e,c[1]=-a[1]*b[0]*e,c[5]=-1-a[1]*b[1]*e,c[9]=-a[1]*b[2]*e,c[2]=-a[2]*b[0]*e,c[6]=-a[2]*b[2]*e,c[10]=1-a[2]*b[2]*e,c[2]=d*b[0]*e,c[6]=d*b[1]*e,c[10]=1-b[2]*e},E2.p.prototype.update_output=function(a){return this.matrix},E2.p=E2.plugins.material_double_sided_modulator=function(a,b){this.desc="If set to true, backface culling is disabled.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"double sided",dt:a.datatypes.BOOL,desc:"Set to true to disable backface-culling.",def:"False"}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:this.double_sided=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=new Material)},E2.p.prototype.update_state=function(){this.material.double_sided=this.double_sided},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.double_sided=!1)},E2.p=E2.plugins.multiply_modulator=function(a,b){this.desc="Multiplies the two supplied values and emits the result.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The first operand.",def:0},{name:"value",dt:a.datatypes.FLOAT,desc:"The first operand.",def:1}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The product of the two supplied values.",def:0}]},E2.p.prototype.reset=function(){this.vals=[0,1],this.output_val=0},E2.p.prototype.update_input=function(a,b){this.vals[a.index]=b},E2.p.prototype.update_state=function(){this.output_val=this.vals[0]*this.vals[1]},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.vector_cross=function(a,b){this.desc="Emits the cross products of the two supplied vectors.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The first operand.",def:"0, 0, 0"},{name:"vector",dt:a.datatypes.VECTOR,desc:"The second operand.",def:"0, 0, 0"}],this.output_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Emits F cross S.",def:"0.0, 0.0, 0.0"}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.vector_a=b:a.index===1&&(this.vector_b=b)},E2.p.prototype.update_state=function(){vec3.cross(this.vector_a,this.vector_b,this.result)},E2.p.prototype.update_output=function(a){return this.result},E2.p.prototype.state_changed=function(a){a||(this.vector_a=[0,0,0],this.vector_b=[0,0,0],this.result=[0,0,0])},E2.p=E2.plugins.rotation_matrix=function(a,b){this.desc="Create a matrix that performs a rotation around an arbitrary axis.",this.input_slots=[{name:"angle",dt:a.datatypes.FLOAT,desc:"Number of degrees to rotate.",lo:-360,hi:360,def:0},{name:"axis",dt:a.datatypes.VECTOR,desc:"Normalized vector describing the axis around which the rotation is performed.",def:"0, 0, 1"}],this.output_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The resulting rotation matrix.",def:"Identity"}]},E2.p.prototype.reset=function(){this.angle=0,this.axis=[0,0,1],this.matrix=mat4.create(),mat4.identity(this.matrix)},E2.p.prototype.update_input=function(a,b){a.index===0?this.angle=b%360/180*Math.PI:this.axis=b},E2.p.prototype.update_state=function(){mat4.identity(this.matrix),mat4.rotate(this.matrix,this.angle,this.axis)},E2.p.prototype.update_output=function(a){return this.matrix},E2.p=E2.plugins.cos_modulator=function(a,b){this.desc="Cos(x).",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"cos(<b>value</b>).",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=Math.cos(b))},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.color_multiply_modulator=function(a,b){this.desc="Scale the RGB components of a color by a supplied factor.",this.input_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Color to be modulated."},{name:"factor",dt:a.datatypes.FLOAT,desc:"Factor to scale the RGB components of the supplied color with.",def:1}],this.output_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Output color: R * V, G * V, B * V, A"}]},E2.p.prototype.reset=function(){this.color=new Color(1,1,1),this.output_color=new Color(1,1,1),this.factor=1},E2.p.prototype.update_input=function(a,b){a.index===0?this.color=b:this.factor=b},E2.p.prototype.update_state=function(){var a=this.color.rgba,b=this.output_color.rgba,c=this.factor;for(var d=0;d<3;d++){var e=a[d]*c;b[d]=e<0?0:e>1?1:e}b[3]=a[4]},E2.p.prototype.update_output=function(a){return this.output_color},E2.p=E2.plugins.negate_modulator=function(a,b){this.desc="Emits the sign inverted input value.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value to be negated.",def:0}],this.output_slots=[{name:"-value",dt:a.datatypes.FLOAT,desc:"The sign-inverted input value.",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){this.value=-b},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.particle_mesh_generator=function(a,b){this.desc="Create a mesh of <b>count</b> unconnected vertices at the origin.",this.input_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"Number of vertices to generate.",lo:1,hi:65535,def:10}],this.output_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"Quad mesh."}],this.gl=a.renderer.context,this.mesh=null},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.update_input=function(a,b){this.count=b<1?1:b>65535?65535:b,this.generate_mesh()},E2.p.prototype.update_output=function(a){return this.mesh},E2.p.prototype.generate_mesh=function(){var a=this.mesh.vertex_buffers.VERTEX,b,c,d=this.count*3,e=0;b=new Array(d);for(c=0;c<d;c+=3)b[c]=e,b[c+1]=0,b[c+2]=0,e++;a.bind_data(b)},E2.p.prototype.state_changed=function(a){if(!a){var b=this.gl;this.count=10,this.mesh=new Mesh(b,b.POINTS),this.mesh.vertex_buffers.VERTEX=new VertexBuffer(b,VertexBuffer.vertex_type.VERTEX),this.generate_mesh()}},E2.p=E2.plugins.convert_camera_matrices=function(a,b){this.desc="Extract the projection and view matrices from a camera.",this.input_slots=[{name:"camera",dt:a.datatypes.CAMERA,desc:"The input camera to be split into constituent matrices.",def:"Screenspace camera"}],this.output_slots=[{name:"projection",dt:a.datatypes.MATRIX,desc:"The camera projection matrix.",def:"Identity"},{name:"view",dt:a.datatypes.MATRIX,desc:"The camera view matrix.",def:"Identity"}],this.gl=a.renderer.context},E2.p.prototype.reset=function(){this.camera=new Camera(this.gl)},E2.p.prototype.update_input=function(a,b){this.camera=b},E2.p.prototype.update_output=function(a){return a.index===0?this.camera.projection:this.camera.view},E2.p=E2.plugins.vector_magnitude=function(a,b){this.desc="Emits the magnitude (length) of the supplied vector.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Input vector to compute the length of.",def:"0, 0, 0"}],this.output_slots=[{name:"mag",dt:a.datatypes.FLOAT,desc:"Emits the magnitude of the input vector.",def:0}]},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.vector=b)},E2.p.prototype.update_state=function(){var a=this.vector[0],b=this.vector[1],c=this.vector[2];this.mag=Math.sqrt(a*a+b*b+c*c)},E2.p.prototype.update_output=function(a){return this.mag},E2.p.prototype.state_changed=function(a){a||(this.vector=[0,0,0],this.mag=0)},E2.p=E2.plugins.light_direction_modulator=function(a,b){this.desc="Sets the direction normal of the light source to a given vector. The user is responsible for ensuring the normalization of the input vector.",this.input_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"Input light."},{name:"direction",dt:a.datatypes.VECTOR,desc:"The light direction. Should be normalized.",def:"0, -1, 0"}],this.output_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"The modified light."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.light=b:this.direction=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.light=new Light)},E2.p.prototype.update_state=function(){this.light.direction=this.direction},E2.p.prototype.update_output=function(a){return this.light},E2.p.prototype.state_changed=function(a){a||(this.light=new Light,this.direction=[0,-1,0])},E2.p=E2.plugins.register_local_read=function(a,b){this.desc="Read from a local register using the name of the node.",this.input_slots=[],this.output_slots=[],this.state={slot_id:b.add_slot(E2.slot_type.output,{name:"value",dt:a.datatypes.ANY,desc:""})},this.core=a,this.node=b,this.data=null,b.title?this.old_title=b.title:this.old_title=b.title="reg_"+b.uid},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.destroy=function(){this.regs.unlock(this,this.node.title)},E2.p.prototype.renamed=function(){this.regs.unlock(this,this.old_title),this.target_reg(this.node.title)},E2.p.prototype.register_dt_changed=function(a){this.node.change_slot_datatype(E2.slot_type.output,this.state.slot_id,a)},E2.p.prototype.register_updated=function(a){this.updated=!0,this.node.queued_update=1,this.data=a},E2.p.prototype.connection_changed=function(a,b,c){var d=this.regs.connection_changed(this.node.title,a);a&&d===1&&this.regs.set_datatype(this.node.title,b.dst_slot.dt)},E2.p.prototype.update_output=function(a){return this.data},E2.p.prototype.target_reg=function(a){this.regs.lock(this,a);var b=this.regs.registers[a].dt;b!==this.core.datatypes.ANY&&(this.register_dt_changed(b),this.data=this.regs.registers[a].value)},E2.p.prototype.state_changed=function(a){if(!a){var b=this.node;this.regs=b.parent_graph.registers,this.target_reg(b.title)}else this.node.ui.dom.addClass("register")},E2.p=E2.plugins.mouse_button_generator=function(a,b){this.desc="Emits the current mouse button state.",this.input_slots=[],this.output_slots=[{name:"Left",dt:a.datatypes.BOOL,desc:"True if the left mouse button is pressed and false otherwise.",def:"False"},{name:"Middle",dt:a.datatypes.BOOL,desc:"True if the middle mouse button is pressed and false otherwise.",def:"False"},{name:"Right",dt:a.datatypes.BOOL,desc:"True if the right mouse button is pressed and false otherwise.",def:"False"}]},E2.p.prototype.update_output=function(a){return this.buttons[a.index]},E2.p.prototype.mouse_down=function(a){return function(b){b.preventDefault(),a.buttons[b.which-1]=!0,a.updated=!0}},E2.p.prototype.mouse_up=function(a){return function(b){a.buttons[b.which-1]=!1,a.updated=!0}},E2.p.prototype.state_changed=function(a){a||(this.buttons=[],this.buttons[0]=this.buttons[1]=this.buttons[2]=!1,E2.dom.webgl_canvas.mousedown(this.mouse_down(this)),E2.dom.webgl_canvas.mouseup(this.mouse_up(this)))},E2.p=E2.plugins.cube_mesh_generator=function(a,b){this.desc="Create a cube mesh of unit size with normals and one set of UV-cordinates.",this.input_slots=[],this.output_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"Cube mesh."}],this.gl=a.renderer.context,this.mesh=null},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.update_output=function(a){return this.mesh},E2.p.prototype.state_changed=function(a){if(!a){var b=this.gl;msg("Cube: Generating mesh."),this.mesh=new Mesh(b,b.TRIANGLES);var c=this.mesh.vertex_buffers.VERTEX=new VertexBuffer(b,VertexBuffer.vertex_type.VERTEX);c.bind_data([-1,-1,1,1,-1,1,1,1,1,-1,1,1,-1,-1,-1,-1,1,-1,1,1,-1,1,-1,-1,-1,1,-1,-1,1,1,1,1,1,1,1,-1,-1,-1,-1,1,-1,-1,1,-1,1,-1,-1,1,1,-1,-1,1,1,-1,1,1,1,1,-1,1,-1,-1,-1,-1,-1,1,-1,1,1,-1,1,-1]);var d=this.mesh.vertex_buffers.NORMAL=new VertexBuffer(b,VertexBuffer.vertex_type.NORMAL);d.bind_data([0,0,1,0,0,1,0,0,1,0,0,1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,1,0,0,1,0,0,1,0,0,1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,1,0,0,1,0,0,1,0,0,1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0]);var e=this.mesh.vertex_buffers.UV0=new VertexBuffer(b,VertexBuffer.vertex_type.UV0);e.bind_data([0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,1]);var f=this.mesh.index_buffer=new IndexBuffer(b);f.bind_data([0,1,2,0,2,3,4,5,6,4,6,7,8,9,10,8,10,11,12,13,14,12,14,15,16,17,18,16,18,19,20,21,22,20,22,23])}},E2.p=E2.plugins.rotation_xyz_matrix=function(a,b){this.desc="Create a matrix that rotates individually around the X, Y and Z axis.",this.input_slots=[{name:"x",dt:a.datatypes.FLOAT,desc:"Number of degrees to rotate around the X-axis.",lo:-360,hi:360,def:0},{name:"y",dt:a.datatypes.FLOAT,desc:"Number of degrees to rotate around the Y-axis.",lo:-360,hi:360,def:0},{name:"z",dt:a.datatypes.FLOAT,desc:"Number of degrees to rotate around the Z-axis.",lo:-360,hi:360,def:0}],this.output_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The resulting rotation matrix.",def:"Identity"}]},E2.p.prototype.reset=function(){this.angles=[0,0,0],this.matrix=mat4.create(),mat4.identity(this.matrix)},E2.p.prototype.update_input=function(a,b){this.angles[a.index]=b%360/180*Math.PI},E2.p.prototype.update_state=function(){mat4.identity(this.matrix),mat4.rotateX(this.matrix,this.angles[0]),mat4.rotateY(this.matrix,this.angles[1]),mat4.rotateZ(this.matrix,this.angles[2])},E2.p.prototype.update_output=function(a){return this.matrix},E2.p=E2.plugins.tween_in_modulator=function(a,b){this.desc="Perform tween in over time.",this.input_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Time ranging from zero to one.",def:0,lo:0,hi:1}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"Emits a tween in over <b>time</b>.",def:0}],this.state={type:0}},E2.p.prototype.create_ui=function(){var a=$("<select />",{selectedIndex:0}),b=function(b,c){$("<option />",{value:b,text:c}).appendTo(a)};return b(0,"Circular"),b(1,"Cubic"),b(2,"Exponential"),b(3,"Quadratic"),b(4,"Quartic"),b(5,"Quintic"),b(6,"Sinusoidal"),a.change(function(b){return function(){b.state.type=parseInt(a.val())}}(this)),a},E2.p.prototype.reset=function(){this.result=0,this.time=0},E2.p.prototype.update_input=function(a,b){this.time=b<0?0:b>1?1:b},E2.p.prototype.update_state=function(){var a=0,b=this.time;switch(this.state.type){case 0:a=1-Math.sqrt(1-b*b);break;case 1:a=b*b*b;break;case 2:a=b===0?0:Math.pow(1024,b-1);break;case 3:a=b*b;break;case 4:a=b*b*b*b;break;case 5:a=b*b*b*b*b;break;case 6:a=1-Math.cos(b*Math.PI/2);break;default:}this.result=a},E2.p.prototype.update_output=function(a){return this.result},E2.p.prototype.state_changed=function(a){a&&a.val(""+this.state.type)},E2.p=E2.plugins.color_display=function(a,b){this.desc="Displays the supplied color in a rectangle on the plugin.",this.input_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Input color to be displayed.",def:"White"}],this.output_slots=[]},E2.p.prototype.reset=function(){this.update_value(1,1,1)},E2.p.prototype.create_ui=function(){return this.label=make("span"),this.label.html("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"),this.label.css({"background-color":"#fff",border:"1px #aaa solid"}),this.label},E2.p.prototype.connection_changed=function(a,b,c){a||this.update_value(0)},E2.p.prototype.update_input=function(a,b){this.update_value(b.rgba[0],b.rgba[1],b.rgba[2])},E2.p.prototype.update_value=function(a,b,c){this.label&&this.label.css("background-color","rgb("+Math.round(a*255)+", "+Math.round(b*255)+", "+Math.round(c*255)+")")},E2.p=E2.plugins.not_modulator=function(a,b){this.desc="Emits true if the input is false and vice versa.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Input boolean to be inverted.",def:"False"}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Truth-inverted input value.",def:"True"}]},E2.p.prototype.update_input=function(a,b){this.input=b},E2.p.prototype.update_state=function(){this.output=!this.input},E2.p.prototype.update_output=function(a){return this.output},E2.p.prototype.state_changed=function(a){a&&(this.input=!1,this.output=!0)},E2.p=E2.plugins.delegate_loop_generator=function(a,b){this.desc="Emits a delegate that represents the list of indices in a sequence [<b>lo</b>...<b>hi</b>] in increments of <b>step</b>. These can be iterated over to form loops or to generate uniform integer sequences for other purposes."
,this.input_slots=[{name:"lo",dt:a.datatypes.FLOAT,desc:"The first index in the emitted sequence.",def:0},{name:"hi",dt:a.datatypes.FLOAT,desc:"The last index in the emitted sequence.",def:0},{name:"step",dt:a.datatypes.FLOAT,desc:"Granularity of the emitted sequence.",def:1}],this.output_slots=[{name:"delegate",dt:a.datatypes.DELEGATE,desc:"The resulting sequence float delegate."}],this.state={},this.lo=0,this.hi=0,this.step=1,this.delegate=new Delegate(this.delegate_func(this),a.datatypes.FLOAT,0)},E2.p.prototype.delegate_func=function(a){return function(b){var c=Math.floor(b)*a.step;return c>=a.lo&&c<=a.hi?c:0}},E2.p.prototype.update_input=function(a,b){a.index===0?this.lo=Math.floor(b):a.index===1?this.hi=Math.floor(b):(this.step=Math.floor(b),this.step=this.step===0?1:this.step)},E2.p.prototype.update_state=function(){if(this.lo>this.hi){var a=this.lo;this.lo=this.hi,this.hi=this.t}this.delegate.count=(this.hi-this.lo)/this.step},E2.p.prototype.update_output=function(a){return this.delegate},E2.p=E2.plugins.vector=function(a,b){this.desc="Create a vector from individual X, Y and Z components.",this.input_slots=[{name:"x",dt:a.datatypes.FLOAT,desc:"The input x-component.",def:0},{name:"y",dt:a.datatypes.FLOAT,desc:"The input y-component.",def:0},{name:"z",dt:a.datatypes.FLOAT,desc:"The input z-component.",def:0}],this.output_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The resulting vector.",def:"0, 0, 0"}]},E2.p.prototype.update_input=function(a,b){this.xyz[a.index]=b},E2.p.prototype.update_output=function(a){return this.xyz},E2.p.prototype.state_changed=function(a){a||(this.xyz=[0,0,0])},E2.p=E2.plugins.url_scene_generator=function(a,b){this.desc="Load a scene from an URL. Hover over the Source button to see the url of the current file.",this.input_slots=[],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The loaded scene if one has been selected."}],this.state={url:""},this.core=a,this.scene=null},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=$('<input id="url" type="button" value="Source" title="No scene selected." />');return a.click(function(b){return function(c){var d=b.state.url;d===""&&(d="data/scenes/");var e=make("div"),f=$('<input type="input" value="'+d+'" />');f.css("width","410px"),e.append(f);var g=function(){b.state.url=f.val(),b.state_changed(null),b.state_changed(a),b.updated=!0,e.dialog("close")};e.dialog({width:460,height:150,modal:!0,title:"Select scene URL.",show:"slide",hide:"slide",buttons:{OK:function(){g()},Cancel:function(){$(this).dialog("close")}},open:function(){f.focus().val(f.val()),e.keyup(function(a){a.keyCode===$.ui.keyCode.ENTER&&g()})}})}}(this)),a},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){this.state.url!==""&&(a?a.attr("title",this.state.url):this.scene=Scene.load(this.core.renderer.context,this.state.url,this.core))},E2.p=E2.plugins.instance_translate_modulator=function(a,b){this.desc="Translate every mesh instance contained in the scene by an amount specified by supplying three delegates. The delegates will be evaluated using the mesh instance index.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The scene to to scale the instances in."},{name:"x-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to an x-axis offset given a mesh index."},{name:"y-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to an y-axis offset given a mesh index."},{name:"z-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to an z-axis offset given a mesh index."}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The modified scene."}]},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?this.scene=null:c.index===1?this.x_delegate=null:c.index===2?this.y_delegate=null:c.index===3&&(this.z_delegate=null))},E2.p.prototype.update_input=function(a,b){a.index===0?this.scene=b:a.index===1?this.x_delegate=b:a.index===2?this.y_delegate=b:a.index===3&&(this.z_delegate=b)},E2.p.prototype.update_state=function(){if(this.scene&&(this.x_delegate||this.y_delegate||this.z_delegate)){var a=this.scene.meshes;for(var b=0,c=a.length;b<c;b++){var d=a[b];if(d.instance_transforms){var e=this.m,f=this.d;for(var g=0,h=d.instances.length;g<h;g++)mat4.identity(e),this.x_delegate&&(f[0]=this.x_delegate.delegate(g)),this.y_delegate&&(f[1]=this.y_delegate.delegate(g)),this.z_delegate&&(f[2]=this.z_delegate.delegate(g)),mat4.translate(e,f),mat4.multiply(d.instance_transforms[g],e)}}}},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=null,this.m=mat4.create(),this.d=vec3.create(),this.x_delegate=null,this.y_delegate=null,this.z_delegate=null)},E2.p=E2.plugins.delegate_sample_modulator=function(a,b){this.desc="Sample the value of the supplied delegate given some parameter <b>x</b>.",this.input_slots=[{name:"delegate",dt:a.datatypes.DELEGATE,desc:"The delegate to sample.",def:"None"},{name:"x",dt:a.datatypes.FLOAT,desc:"The parameter to evaluate the <b>delegate</b> for.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The value the delegate evaluates for a given <b>x</b>.",def:0}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.delegate=b:this.x=b},E2.p.prototype.update_state=function(){this.delegate&&(this.result=this.delegate.delegate(this.x))},E2.p.prototype.update_output=function(a){return this.result},E2.p.prototype.state_changed=function(a){a||(this.delegate=null,this.x=0,this.result=0)},E2.p=E2.plugins.url_audio_generator=function(a,b){this.desc="Load a sample from an URL. Each sample should be encoded as .wav, .mp3, .mp4 and .ogg, and no extension should be specified. This plugin will load the appropriate filetype for the current execution environment. Hover over the Source button to see the url of the current file.",this.input_slots=[],this.output_slots=[{name:"audio",dt:a.datatypes.AUDIO,desc:"An audio stream."}],this.state={url:""},this.audio=null},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=$('<input id="url" type="button" value="Source" title="No audio selected." />');return a.click(function(b){return function(c){var d=b.state.url;d===""&&(d="data/audio/");var e=make("div"),f=$('<input type="input" value="'+d+'" />');f.css("width","410px"),e.append(f);var g=function(){var c=f.val();b.state.url=c.substr(0,c.lastIndexOf("."))||c,b.state_changed(null),b.state_changed(a),b.updated=!0,e.dialog("close")};e.dialog({width:460,height:150,modal:!0,title:"Select audio URL (no extension).",show:"slide",hide:"slide",buttons:{OK:function(){g()},Cancel:function(){$(this).dialog("close")}},open:function(){f.focus().val(f.val()),e.keyup(function(a){a.keyCode===$.ui.keyCode.ENTER&&g()})}})}}(this)),a},E2.p.prototype.update_output=function(a){return this.audio},E2.p.prototype.state_changed=function(a){if(this.state.url!=="")if(a)a.attr("title",this.state.url);else if(typeof Audio!="undefined"){this.audio!==null&&(this.audio.pause(),delete this.audio);var b=null;this.audio=new Audio,this.audio.loop=!0,this.audio.preload=!0,this.audio.canPlayType('audio/ogg; codecs="vorbis"')?b=this.state.url+".ogg":this.audio.canPlayType("audio/mpeg")?b=this.state.url+".mp3":msg("Audio: This browser supports neither ogg vorbis or mp3 audio playback."),b!==null&&(this.audio.addEventListener("error",function(a,b){return function(c){msg("ERROR: Audio: Failed to load '"+b+"'."),a.audio=null}}(this,b)),msg("Audio: Loading "+b+"."),this.audio.src=b)}else msg("Audio: This browser does not support the Audio API.")},E2.p=E2.plugins.scene_get_mesh_count=function(a,b){this.desc="Emits the number of meshes in the supplied <b>scene</b>. Note that the maximum index is one less than the mesh <b>count</b>.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The scene to obtain the mesh count from."}],this.output_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"The number of meshes in the supplied <b>scene</b>. Note that mesh indices are zero-index, so the highest mesh index in a scene is count - 1.",def:0}]},E2.p.prototype.update_input=function(a,b){this.scene=b},E2.p.prototype.update_state=function(){this.count=this.scene?this.scene.meshes.length:0},E2.p.prototype.update_output=function(a){return this.count},E2.p.prototype.state_changed=function(a){a||(this.scene=null,this.count=0)},E2.p=E2.plugins.pi_generator=function(a,b){this.desc="Emits the constant ∏ (pi).",this.input_slots=[],this.output_slots=[{name:"pi",dt:a.datatypes.FLOAT,desc:"The constant ∏ (pi)."}]},E2.p.prototype.update_output=function(a){return Math.PI},E2.p=E2.plugins.convert_rgba_color_modulator=function(a,b){this.desc="Creates a new color from individual RGBA components.",this.input_slots=[{name:"red",dt:a.datatypes.FLOAT,desc:"Red channel value.",lo:0,hi:1,def:1},{name:"green",dt:a.datatypes.FLOAT,desc:"Green channel value.",lo:0,hi:1,def:1},{name:"blue",dt:a.datatypes.FLOAT,desc:"Blue channel value.",lo:0,hi:1,def:1},{name:"alpha",dt:a.datatypes.FLOAT,desc:"Alpha channel value.",lo:0,hi:1,def:1}],this.output_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"The output color",def:"White"}]},E2.p.prototype.reset=function(){this.color=new Color(1,1,1,1)},E2.p.prototype.update_input=function(a,b){this.color.rgba[a.index]=b<0?0:b>1?1:b},E2.p.prototype.update_output=function(a){return this.color},E2.p=E2.plugins.url_texture_generator=function(a,b){this.desc="Load a texture from an URL. JPEG and PNG supported. Hover over the Source button to see the url of the current file.",this.input_slots=[],this.output_slots=[{name:"texture",dt:a.datatypes.TEXTURE,desc:"The loaded texture."}],this.state={url:""},this.gl=a.renderer.context,this.core=a,this.texture=null},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=$('<input id="url" type="button" value="Source" title="No texture selected." />');return a.click(function(b){return function(c){var d=b.state.url;d===""&&(d="data/textures/");var e=make("div"),f=$('<input type="input" value="'+d+'" />');f.css("width","410px"),e.append(f);var g=function(){b.state.url=f.val(),b.state_changed(null),b.state_changed(a),b.state.url===""&&a.attr("title","No texture selected."),b.updated=!0,e.dialog("close")};e.dialog({width:460,height:150,modal:!0,title:"Select image URL.",show:"slide",hide:"slide",buttons:{OK:function(){g()},Cancel:function(){$(this).dialog("close")}},open:function(){f.focus().val(f.val()),e.keyup(function(a){a.keyCode===$.ui.keyCode.ENTER&&g()})}})}}(this)),a},E2.p.prototype.update_output=function(a){return this.texture},E2.p.prototype.state_changed=function(a){this.state.url!==""&&(a?a.attr("title",this.state.url):this.texture=this.core.renderer.texture_cache.get(this.state.url))},E2.p=E2.plugins.light_specular_color_modulator=function(a,b){this.desc="Sets the specular color of the light source.",this.input_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"Input light."},{name:"color",dt:a.datatypes.COLOR,desc:"The light specular color.",def:"White"}],this.output_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"The modified light."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.light=b:this.color=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.light=new Light)},E2.p.prototype.update_state=function(){this.light.specular_color=this.color},E2.p.prototype.update_output=function(a){return this.light},E2.p.prototype.state_changed=function(a){a||(this.light=new Light,this.color=new Color(1,1,1,1))},E2.p=E2.plugins.convert_matrices_camera=function(a,b){this.desc="Create a new camera from a projection and view matrix.",this.input_slots=[{name:"projection",dt:a.datatypes.MATRIX,desc:"The projection matrix.",def:"Identity"},{name:"view",dt:a.datatypes.MATRIX,desc:"The view matrix.",def:"Identity"}],this.output_slots=[{name:"camera",dt:a.datatypes.CAMERA,desc:"The resulting camera.",def:"Screenspace camera"}],this.gl=a.renderer.context},E2.p.prototype.update_input=function(a,b){a.index===0?this.camera.projection=b:this.camera.view=b},E2.p.prototype.update_output=function(a){return this.camera},E2.p.prototype.state_changed=function(a){a||(this.camera=new Camera(this.gl))},E2.p=E2.plugins.vector_add=function(a,b){this.desc="Adds the X, Y and Z components of the supplied vectors and emits the result.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The first operand.",def:"0, 0, 0"},{name:"vector",dt:a.datatypes.VECTOR,desc:"The second operand.",def:"0, 0, 0"}],this.output_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Emits Fx + Sx, Fy + Sy, Fz + Sz.",def:"0, 0, 0"}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.vector_a=b:a.index===1&&(this.vector_b=b)},E2.p.prototype.update_state=function(){var a=this.result,b=this.vector_a,c=this.vector_b;a[0]=b[0]+c[0],a[1]=b[1]+c[1],a[2]=b[2]+c[2]},E2.p.prototype.update_output=function(a){return this.result},E2.p.prototype.state_changed=function(a){a||(this.vector_a=[0,0,0],this.vector_b=[0,0,0],this.result=[0,0,0])},E2.p=E2.plugins.vector_scale=function(a,b){this.desc="Scale the X, Y and Z components of the supplied vector by the supplied factor.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"The input vector to be scaled.",def:"0, 0, 0"},{name:"scale",dt:a.datatypes.FLOAT,desc:"The scale factor.",def:1}],this.output_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Emits Vx * s, Vy *s, Vz * s.",def:"0, 0, 0"}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.vector=b:a.index===1&&(this.scale=b)},E2.p.prototype.update_state=function(){var a=this.scale,b=this.scaled,c=this.vector;b[0]=c[0]*a,b[1]=c[1]*a,b[2]=c[2]*a},E2.p.prototype.update_output=function(a){return this.scaled},E2.p.prototype.state_changed=function(a){a||(this.vector=[0,0,0],this.scaled=[0,0,0],this.scale=1)},E2.p=E2.plugins.instance_scale_modulator=function(a,b){this.desc="Scale every mesh instance contained in the scene by an amount specified by supplying three delegates. The delegates will be evaluated using the mesh instance index.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The scene to to scale the instances in."},{name:"x-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to a factor to scale the x-axis given a mesh index."},{name:"y-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to a factor to scale the y-axis given a mesh index."},{name:"z-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to a factor to scale the z-axis given a mesh index."}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The modified scene."}]},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?this.scene=null:c.index===1?this.x_delegate=null:c.index===2?this.y_delegate=null:c.index===3&&(this.z_delegate=null))},E2.p.prototype.update_input=function(a,b){a.index===0?this.scene=b:a.index===1?this.x_delegate=b:a.index===2?this.y_delegate=b:a.index===3&&(this.z_delegate=b)},E2.p.prototype.update_state=function(){if(this.scene&&(this.x_delegate||this.y_delegate||this.z_delegate)){var a=this.scene.meshes;for(var b=0,c=a.length;b<c;b++){var d=a[b],e=vec3.create();if(d.instance_transforms){var f=this.m;for(var g=0,h=d.instances.length;g<h;g++)mat4.identity(f),e[0]=this.x_delegate?this.x_delegate.delegate(g):1,e[1]=this.y_delegate?this.y_delegate.delegate(g):1,e[2]=this.z_delegate?this.z_delegate.delegate(g):1,mat4.scale(f,e),mat4.multiply(d.instance_transforms[g],f)}}}},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=null,this.m=mat4.create(),this.x_delegate=null,this.y_delegate=null,this.z_delegate=null)},E2.p=E2.plugins.scene_get_bounding_box=function(a,b){this.desc="Extract the <b>min</b> and <b>max</b> AABB vectors from a supplied <b>scene</b> for use in debugging, camera calibration or other calculations.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The input scene."}],this.output_slots=[{name:"min",dt:a.datatypes.VECTOR,desc:"The lowest <b>scene</b> extent.",def:"0, 0, 0"},{name:"max",dt:a.datatypes.VECTOR,desc:"The highest <b>scene</b> extent.",def:"0, 0, 0"}]},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.scene=b)},E2.p.prototype.update_state=function(){if(this.scene){var a=this.scene.bounding_box;this.lo=a.lo,this.hi=a.hi}},E2.p.prototype.update_output=function(a){return a.index===0?this.lo:this.hi},E2.p.prototype.state_changed=function(a){a||(this.scene=null,this.lo=[0,0,0],this.hi=[0,0,0])},E2.p=E2.plugins.const_text_generator=function(a,b){this.desc="Enter a constant text string.",this.input_slots=[],this.output_slots=[{name:"text",dt:a.datatypes.TEXT,desc:"The currently entered text.",def:"Empty string"}],this.state={text:"",width:0,height:0}},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.create_ui=function(){var a=$('<textarea placeholder="Type text here" />');return a.css({"font-size":"8pt",border:"1px solid #999",margin:"0px","margin-top":"2px",padding:"2px"}),a.bind("blur",function(a){return function(){a.state.text=$(this).val(),a.updated=!0}}(this)),a.mouseup(function(a){return function(){var b=$(this);a.state.width=b.width(),a.state.height=b.height()}}(this)),a},E2.p.prototype.update_output=function(a){return this.state.text},E2.p.prototype.state_changed=function(a){var b=this.state;a&&b.text!==""&&(a.val(b.text),b.width>0&&a.css("width",b.width),b.height>0&&a.css("height",b.height))},E2.p=E2.plugins.flat_shader=function(a,b){this.desc="Simple shader for rendering meshes with diffuse color only.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The surface material."}],this.output_slots=[{name:"shader",dt:a.datatypes.SHADER,desc:"The resulting shader."}];var c=a.renderer.context,d="attribute vec3 v_pos;uniform mat4 m_mat;uniform mat4 v_mat;uniform mat4 p_mat;void main(void) { gl_Position = p_mat * v_mat * m_mat * vec4(v_pos, 1.0); }",e="precision mediump float;uniform vec4 d_col;void main(void) { gl_FragColor = d_col; }";this.s=new ShaderProgram(c),this.vs=new Shader(c,c.VERTEX_SHADER,d),this.ps=new Shader(c,c.FRAGMENT_SHADER,e);var f=this.s.program;this.s.attach(this.vs),this.s.attach(this.ps),this.s.link(),this.s.v_pos=c.getAttribLocation(f,"v_pos"),this.s.m_mat=c.getUniformLocation(f,"m_mat"),this.s.v_mat=c.getUniformLocation(f,"v_mat"),this.s.p_mat=c.getUniformLocation(f,"p_mat"),this.s.d_col=c.getUniformLocation(f,"d_col"),this.s.bind_array=function(a,b){return function(c,d,e){if(c!==VertexBuffer.vertex_type.VERTEX)return;b.bindBuffer(b.ARRAY_BUFFER,d),b.vertexAttribPointer(a.s.v_pos,e,b.FLOAT,!1,0,0)}}(this,c),this.s.apply_uniforms=this.apply_uniforms=function(a,b){return function(c){var d=a.material?a.material:c.material;b.uniform4fv(a.s.d_col,d.diffuse_color?new Float32Array(d.diffuse_color.rgba):this.s),b.enableVertexAttribArray(a.s.v_pos),d.enable()}}(this,c),this.state_changed(null)},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.material=b)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(this.material=null)},E2.p.prototype.update_output=function(a){return this.s},E2.p.prototype.state_changed=function(a){a||(this.material=null)},E2.p=E2.plugins.delegate_json_array_generator=function(a,b){this.desc="Emit a float delegate that can load and expose the (float) values of a JSON array from a given URL. The identifier of the array is expected to be '<b>data</b>'.",this.input_slots=[{name:"json url",dt:a.datatypes.TEXT,desc:"The URL of a JSON file containing an array."}],this.output_slots=[{name:"delegate",dt:a.datatypes.DELEGATE,desc:"The resulting float delegate."}],this.state={},this.core=a,this.data=null,this.delegate=new Delegate(function(a){return 0},a.datatypes.FLOAT,0),this.url=""},E2.p.prototype.delegate_func=function(a){return function(b){var c=Math.floor(b);return a.data&&c>-1&&c<a.data.length?a.data[c]:0}},E2.p.prototype.reset=function(){},E2.p.prototype.update_input=function(a,b){if(this.url===b)return;var c=this;msg("JSON array delegate: Loading : "+b),this.url=b,this.core.asset_tracker.signal_started(),$.ajax({url:b,dataType:"json",async:!1,headers:{},success:function(a,b,c){return function(d){d.data?(a.data=d.data,a.delegate=new Delegate(a.delegate_func(a),c.datatypes.FLOAT,a.data.length),c.asset_tracker.signal_completed()):(msg("ERROR: JSON array delegate: The file '"+b+"' did not contain the expected array named 'data'."),c.asset_tracker.signal_failed())}}(c,b,this.core),error:function(a,b){return function(){msg("ERROR: JSON array delegate: Couldn't load "+a),b.asset_tracker.signal_failed()}}(b,this.core)})},E2.p.prototype.update_output=function(a){return this.delegate},E2.p=E2.plugins.delta_modulator=function(a,b){this.desc="Emits the derivative of the incoming <b>value</b>.",this.input_slots=[{name:"reset",dt:a.datatypes.BOOL,desc:"Send true to this slot to clear the internal state."},{name:"value",dt:a.datatypes.FLOAT,desc:"Input value."}],this.output_slots=[{name:"delta",dt:a.datatypes.FLOAT,desc:"The delta value from the last frame update."}]},E2.p.prototype.reset=function(){this.input_val=0,this.last_val=0,this.output_val=0,this.clear=!1},E2.p.prototype.update_input=function(a,b){a.index===0?this.clear=b:a.index===1&&(this.input_val=b)},E2.p.prototype.update_state=function(){this.clear?(this.output_val=0,this.clear=!1):this.output_val=this.input_val-this.last_val,this.last_val=this.input_val},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.matrix_display=function(a,b){this.desc="Displays the supplied matrix as a 4x4 grid of values.",this.input_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The input matrix to be displayed."}],this.output_slots=[]},E2.p.prototype.reset=function(){this.cell_vals=["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],this.update_values()},E2.p.prototype.create_ui=function(){var a=make("table"),b={"text-align":"right","padding-left":"10px"};this.columns=[];for(var c=0;c<4;c++){var d=make("tr");for(var e=0;e<4;e++){var f=make("td");f.text("-"),f.css(b),this.columns.push(f[0]),d.append(f)}a.append(d)}return a},E2.p.prototype.connection_changed=function(a,b,c){a||this.reset()},E2.p.prototype.update_input=function(a,b){var c=0;for(var d=0;d<16;d++)this.cell_vals[d]=b[d].toFixed(2);this.update_values()},E2.p.prototype.update_values=function(){if(!this.columns)return;for(var a=0;a<16;a++)this.columns[a].innerHTML=this.cell_vals[a]},E2.p=E2.plugins.material_ambient_color_modulator=function(a,b){this.desc="Set the ambient color.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"color",dt:a.datatypes.COLOR,desc:"The material ambient color.",def:"0.2, 0.2, 0.2"}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:this.color=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=new Material)},E2.p.prototype.update_state=function(){this.material.ambient_color=this.color},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.color=new Color(.2,.2,.2,1))},E2.p=E2.plugins.plot_display=function(a,b){this.desc="Displays the supplied coordiate on a XY plot.",this.input_slots=[{name:"x",dt:a.datatypes.FLOAT,desc:"The location on the x-axis.",lo:0,hi:1,def:0},{name:"y",dt:a.datatypes.FLOAT,desc:"The location on the y-axis.",lo:0,hi:1,def:0}],this.output_slots=[]},E2.p.prototype.reset=function(){this.coord=[0,0],this.update_values()},E2.p.prototype.create_ui=function(){var a=make("div");a.css({width:"64px",height:"64px",background:"url('images/plot_display/bg.png')","z-index":"1000",position:"relative"});var b=this.coord_div=make("div");return b.css({width:"7px",height:"7px",background:"url('images/plot_display/point.png')","z-index":"1001",position:"absolute"}),a.append(b),this.reset(),a},E2.p.prototype.connection_changed=function(a,b,c){a||this.reset()},E2.p.prototype.update_input=function(a,b){this.coord[a.index]=b<0?0:b>1?1:b,this.update_values()},E2.p.prototype.update_values=function(){if(!this.coord_div)return;this.coord_div.css({left:Math.round(this.coord[0]*55),top:Math.round(55-this.coord[1]*55)+2})},E2.p=E2.plugins.invert_matrix_modulator=function(a,b){this.desc="Emits the inverse of the supplied <b>matrix</b>.",this.input_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The input matrix to be inverted.",def:"Identity"}],this.output_slots=[{name:"inverse",dt:a.datatypes.MATRIX,desc:"Emits the inverse of the input <b>matrix</b>.",def:"Identity"}]},E2.p.prototype.reset=function(){this.matrix=mat4.create(),this.inverse=mat4.create(),mat4.identity(this.matrix),mat4.identity(this.inverse)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(mat4.identity(this.matrix),mat4.identity(this.inverse))},E2.p.prototype.update_input=function(a,b){this.matrix=b},E2.p.prototype.update_state=function(){mat4.inverse(this.matrix,this.inverse)},E2.p.prototype.update_output=function(a){return this.inverse},E2.p=E2.plugins.normal_as_color_shader=function(a,b){var c=this,d=a.renderer,e=d.context;this.desc="Render vertex normals as interpolated RGB colors.",this.input_slots=[],this.output_slots=[{name:"shader",dt:a.datatypes.SHADER,desc:"The resulting shader."}];var f="attribute vec3 v_pos;attribute vec3 v_norm;uniform mat4 m_mat;uniform mat4 v_mat;uniform mat4 p_mat;varying lowp vec3 f_col;void main(void) { gl_Position = p_mat * v_mat * m_mat * vec4(v_pos, 1.0); f_col = (v_norm * 0.5) + vec3(0.5, 0.5, 0.5); }",g="precision mediump float;varying lowp vec3 f_col;void main(void) { gl_FragColor = vec4(f_col, 1.0); }",h=this.s=new ShaderProgram(e);this.vs=new Shader(e,e.VERTEX_SHADER,f),this.ps=new Shader(e,e.FRAGMENT_SHADER,g);var i=h.program;h.attach(this.vs),h.attach(this.ps),h.link(),h.v_pos=e.getAttribLocation(i,"v_pos"),h.v_norm=e.getAttribLocation(i,"v_norm"),h.m_mat=e.getUniformLocation(i,"m_mat"),h.v_mat=e.getUniformLocation(i,"v_mat"),h.p_mat=e.getUniformLocation(i,"p_mat"),h.bind_array=function(a,b){return function(c,d,e){var f=VertexBuffer.vertex_type;b.bindBuffer(b.ARRAY_BUFFER,d),c===f.VERTEX?b.vertexAttribPointer(a.v_pos,e,b.FLOAT,!1,0,0):c===f.NORMAL&&b.vertexAttribPointer(a.v_norm,e,b.FLOAT,!1,0,0)}}(h,e),h.apply_uniforms=function(a,b,c){return function(d){b.enableVertexAttribArray(a.v_pos),b.enableVertexAttribArray(a.v_norm),c.set_depth_enable(!0),c.set_blend_mode(Renderer.blend_mode.NORMAL)}}(h,e,a.renderer)},E2.p.prototype.reset=function(){},E2.p.prototype.update_output=function(a){return this.s},E2.p=E2.plugins.register_global_read=function(a,b){this.desc="Read from a local register using the name of the node.",this.input_slots=[],this.output_slots=[],this.state={slot_id:b.add_slot(E2.slot_type.output,{name:"value",dt:a.datatypes.ANY,desc:""})},this.core=a,this.node=b,this.data=null,b.title?this.old_title=b.title:this.old_title=b.title="reg_"+b.uid},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.destroy=function(){this.regs.unlock(this,this.node.title)},E2.p.prototype.renamed=function(){this.regs.unlock(this,this.old_title),this.target_reg(this.node.title)},E2.p.prototype.register_dt_changed=function(a){this.node.change_slot_datatype(E2.slot_type.output,this.state.slot_id,a)},E2.p.prototype.register_updated=function(a){this.updated=!0,this.node.queued_update=1,this.data=a},E2.p.prototype.connection_changed=function(a,b,c){var d=this.regs.connection_changed(this.node.title,a);a&&d===1&&this.regs.set_datatype(this.node.title,b.dst_slot.dt)},E2.p.prototype.update_output=function(a){return this.data},E2.p.prototype.target_reg=function(a){this.regs.lock(this,a);var b=this.regs.registers[a].dt;b!==this.core.datatypes.ANY&&(this.register_dt_changed(b),this.data=this.regs.registers[a].value)},E2.p.prototype.state_changed=function(a){a?this.node.ui.dom.addClass("register"):(this.regs=this.core.registers,this.target_reg(this.node.title))},E2.p=E2.plugins.cosine_modulator=function(a,b){this.desc="Cosine oscilator. A <b>time</b> value incrementing by one unit per second will yield a 1Hz output signal.",this.input_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Time in seconds",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits cos(<b>time</b> * 2pi)",def:0}]},E2.p.prototype.reset=function(){this.time=0,this.result=0},E2.p.prototype.update_input=function(a,b){this.time=b},E2.p.prototype.update_state=function(){this.result=Math.cos(this.time*2*Math.PI)},E2.p.prototype.update_output=function(a){return this.result},E2.p=E2.plugins.convert_bool_float_modulator=function(a,b){this.desc="Convert a bool to a float. True emits 1 and false 0.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Input boolean to be converted.",def:"False"}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits 0 when the input is false and 1 otherwise.",lo:0,hi:1,def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){this.value=b?1:0},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.subtract_modulator=function(a,b){this.desc="Subtract the second value from the first and emit the result.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The first operand.",def:0},{name:"value",dt:a.datatypes.FLOAT,desc:"The second operand.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The result of <b>first</b> - <b>second</b>.",def:0}]},E2.p.prototype.reset=function(){this.input_val=0,this.sub_val=0,this.output_val=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.input_val=b:this.sub_val=b},E2.p.prototype.update_state=function(){this.output_val=this.input_val-this.sub_val},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.translation_matrix=function(a,b){this.desc="Create a matrix that represent a translation.",this.input_slots=[{name:"vector",dt:a.datatypes.VECTOR,desc:"Translation vector.",def:"0, 0, 0"}],this.output_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The resulting translation matrix.",def:"Identity"}]},E2.p.prototype.reset=function(){this.matrix=mat4.create(),mat4.identity(this.matrix)},E2.p.prototype.update_input=function(a,b){var c=this.matrix;c[12]=b[0],c[13]=b[1],c[14]=b[2]},E2.p.prototype.update_output=function(a){return this.matrix},E2.p=E2.plugins.material_alpha_clip_modulator=function(a,b){this.desc="If set to true, fragments with alpha < 0.5 will be discarded.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"Input material."},{name:"alpha clip",dt:a.datatypes.BOOL,desc:"Set to true to discard fragments with alpha < 0.5.",def:"False"}],this.output_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The modified material."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:this.alpha_clip=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=new Material)},E2.p.prototype.update_state=function(){this.material.alpha_clip=this.alpha_clip},E2.p.prototype.update_output=function(a){return this.material},E2.p.prototype.state_changed=function(a){a||(this.material=new Material,this.alpha_clip=!1)},E2.p=E2.plugins.sphere_mesh_generator=function(a,b){this.desc="Create a sphere mesh of unit size with normals and one set of UV-cordinates. Vertical and horizontal resolution is customizable.",this.input_slots=[{name:"v res",dt:a.datatypes.FLOAT,desc:"Vertical resolution.",lo:3,hi:25,def:15},{name:"h res",dt:a.datatypes.FLOAT,desc:"Horizontal resolution.",lo:3,hi:25,def:15}],this.output_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"Sphere mesh."}],this.state={v_res:15,h_res:15},this.gl=a.renderer.context,this.mesh=null},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.update_input=function(a,b){a.index===0&&this.state.v_res!==Math.floor(b)&&b>1?(this.state.v_res=Math.floor(b<3?3:b>25?25:b),this.dirty=!0):a.index===1&&this.state.h_res!==Math.floor(b)&&b>1&&(this.state.h_res=Math.floor(b<3?3:b>25?25:b),this.dirty=!0)},E2.p.prototype.update_state=function(){this.dirty&&(this.generate_mesh(),this.dirty=!1)},E2.p.prototype.update_output=function(a){return this.mesh},E2.p.prototype.generate_mesh=function(){var a=this.gl;msg("Sphere: Generating mesh."),this.mesh=new Mesh(a,a.TRIANGLES);var b=[],c=[],d=[],e=[],f=Math.PI/this.state.v_res,g=2*Math.PI/this.state.h_res,h=0,i=this.state.v_res,j=this.state.h_res;for(var k=0;k<
i+1;k++){var l=Math.sin(k*f),m=Math.cos(k*f);for(var n=0;n<j+1;n++){var o=l*Math.sin(n*g),p=l*Math.cos(n*g);b.push(o),b.push(m),b.push(p);var q=Math.sqrt(o*o+m*m+p*p);q<1e-5&&(q=1),q=1/q,c.push(o*q),c.push(m*q),c.push(p*q),d.push(n/j),d.push(1-k/i),k!==i&&(e.push(h+j+1),e.push(h),e.push(h+j),e.push(h+j+1),e.push(h+1),e.push(h),h++)}}var r=this.mesh.vertex_buffers.VERTEX=new VertexBuffer(a,VertexBuffer.vertex_type.VERTEX);r.bind_data(b),delete b;var s=this.mesh.vertex_buffers.NORMAL=new VertexBuffer(a,VertexBuffer.vertex_type.NORMAL);s.bind_data(c),delete c;var t=this.mesh.vertex_buffers.UV0=new VertexBuffer(a,VertexBuffer.vertex_type.UV0);t.bind_data(d),delete d;var u=this.mesh.index_buffer=new IndexBuffer(a);u.bind_data(e),delete e},E2.p.prototype.state_changed=function(a){a||(this.generate_mesh(),this.dirty=!1)},E2.p=E2.plugins.transpose_matrix_modulator=function(a,b){this.desc="Emits the transposed version of the supplied <b>matrix</b>.",this.input_slots=[{name:"matrix",dt:a.datatypes.MATRIX,desc:"The input matrix to be transposed.",def:"Identity"}],this.output_slots=[{name:"transposed",dt:a.datatypes.MATRIX,desc:"Emits the transposed input <b>matrix</b>.",def:"Identity"}]},E2.p.prototype.reset=function(){this.matrix=mat4.create(),this.transposed=mat4.create(),mat4.identity(this.matrix),mat4.identity(this.transposed)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(mat4.identity(this.matrix),mat4.identity(this.transposed))},E2.p.prototype.update_input=function(a,b){this.matrix=b},E2.p.prototype.update_state=function(){mat4.transpose(this.matrix,this.transposed)},E2.p.prototype.update_output=function(a){return this.transposed},E2.p=E2.plugins.texture_from_text_generator=function(a,b){this.desc="Create a texture of a (2^n closest to the) given size filled with a rendered version of the supplied text.",this.input_slots=[{name:"text",dt:a.datatypes.TEXT,desc:"The text to be rendered to <b>texture</b>.",def:"Empty string"},{name:"width",dt:a.datatypes.FLOAT,desc:"The width of the output <b>texture</b>. Will be rounded to nearest 2^n.",lo:2,hi:1024,def:128},{name:"height",dt:a.datatypes.FLOAT,desc:"The height of the output <b>texture</b>. Will be rounded to nearest 2^n.",lo:2,hi:1024,def:128},{name:"x",dt:a.datatypes.FLOAT,desc:"The x position of the text.",def:10},{name:"y",dt:a.datatypes.FLOAT,desc:"The y position of the text.",def:10},{name:"font style",dt:a.datatypes.TEXT,desc:"The desired font style (CSS standard).",def:"bold 16px arial"},{name:"fill style",dt:a.datatypes.TEXT,desc:"The desired fill style (CSS standard).",def:"#fff"},{name:"stroke style",dt:a.datatypes.TEXT,desc:"The desired stroke style (CSS standard).",def:"none"},{name:"stroke width",dt:a.datatypes.FLOAT,desc:"The desired stroke width in pixels.",def:"0"},{name:"align",dt:a.datatypes.TEXT,desc:"Text alignment.",def:"center"},{name:"baseline",dt:a.datatypes.TEXT,desc:"Text baseline.",def:"middle"},{name:"line height",dt:a.datatypes.FLOAT,desc:"Line height scalar.",def:"1.2"}],this.output_slots=[{name:"texture",dt:a.datatypes.TEXTURE,desc:"Output texture containing the rendered text."}],this.gl=a.renderer.context,this.mesh=null,this.canvas2d=$('<canvas style="display:none" width="128" height="128"></canvas>')[0],this.c2d_ctx=this.canvas2d.getContext("2d")},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.sanitize_size=function(a){var b=Math.log(a)/Math.log(2),c=Math.floor(b);return c<1?c=1:c>10&&(c=10),Math.pow(2,c)},E2.p.prototype.update_input=function(a,b){a.index===0?this.text=b:a.index===1?this.width=this.sanitize_size(b):a.index===2?this.height=this.sanitize_size(b):a.index===3?this.x=b:a.index===4?this.y=b:a.index===5?this.font_style=b:a.index===6?this.fill_style=b:a.index===7?this.stroke_style=b:a.index===8?this.stroke_width=b:a.index===9?this.align=b:a.index===10?this.baseline=b:a.index===11&&(this.line_height=b)},E2.p.prototype.update_state=function(){if(this.text==="")return;var a=this.text.split("\n"),b=this.canvas2d,c=this.c2d_ctx;b.width=this.width,b.height=this.height,c.clearRect(0,0,this.width,this.height),c.fillStyle=this.fill_style,c.lineWidth=this.stroke_width,c.strokeStyle=this.stroke_style,c.font=this.font_style,c.textAlign=this.align,c.textBaseline=this.baseline;var d=c.measureText("M").width*this.line_height;for(var e=0,f=a.length;e<f;e++){var g=this.y+e*d,h=a[e];c.strokeText(h,this.x,g),c.fillText(h,this.x,g)}this.texture.upload(b,"Rendered text")},E2.p.prototype.update_output=function(a){return this.texture},E2.p.prototype.state_changed=function(a){a||(this.texture=new Texture(this.gl),this.text="",this.width=128,this.height=128,this.x=10,this.y=10,this.font_style="bold 16px arial",this.fill_style="#fff",this.stroke_style="none",this.stroke_width=0,this.align="center",this.baseline="middle",this.line_height=1.2)},E2.p=E2.plugins.delta_t_generator=function(a,b){this.desc="Emits the current frame delta time in seconds.",this.input_slots=[],this.output_slots=[{name:"seconds",dt:a.datatypes.FLOAT,desc:"Last frame delta time in seconds."}],this.core=a},E2.p.prototype.update_state=function(){this.updated=!0},E2.p.prototype.update_output=function(a){return this.core.delta_t},E2.p=E2.plugins.stop_emitter=function(a,b){this.desc="Stops graph playback when a true value is received by the <b>bool</b> slot.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"When true is received by this slot, graph playback is stopped."}],this.output_slots=[],this.core=a,this.stop_seq=!1},E2.p.prototype.reset=function(){this.stop_seq=!1},E2.p.prototype.update_input=function(a,b){this.stop_seq=b},E2.p.prototype.update_state=function(){if(!this.stop_seq)return;E2.app.onStopClicked?E2.app.onStopClicked():this.core.player.stop(),this.stop_seq=!1},E2.p=E2.plugins.url_video_generator=function(a,b){this.desc="Load a Ogg/Theora video from an URL.",this.input_slots=[],this.output_slots=[{name:"video",dt:a.datatypes.VIDEO,desc:"An video stream."}],this.state={url:""},this.gl=a.renderer.context,this.video=null},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=$('<input id="url" type="button" value="Source" title="No video selected." />');return a.click(function(b){return function(c){var d=b.state.url;d===""&&(d="data/video/");var e=make("div"),f=$('<input type="input" value="'+d+'" />');f.css("width","410px"),e.append(f);var g=function(){b.state.url=f.val(),b.state_changed(null),b.state_changed(a),b.updated=!0,e.dialog("close")};e.dialog({width:460,height:150,modal:!0,title:"Select video URL.",show:"slide",hide:"slide",buttons:{OK:function(){g()},Cancel:function(){$(this).dialog("close")}},open:function(){f.focus().val(f.val()),e.keyup(function(a){a.keyCode===$.ui.keyCode.ENTER&&g()})}})}}(this)),a},E2.p.prototype.update_output=function(a){return this.video},E2.p.prototype.state_changed=function(a){this.state.url!==""&&(a?a.attr("title",this.state.url):(this.video!==null&&(this.video.pause(),delete this.video),this.video=document.createElement("video"),this.video!=="undefined"?(this.video.loop=!0,this.video.preload="auto",this.video.controls=!1,this.video.addEventListener("error",function(a){return function(b){msg("ERROR: Video: Failed to load '"+a.state.url+"'."),a.video=null}}(this)),msg("Video: Loading "+this.state.url+"."),this.video.src=this.state.url):(msg("Video: This browser does not support the Video API."),this.video=null)))},E2.p=E2.plugins.knob_float_generator=function(a,b){this.desc="Emits a user controllable float value between 0 and 1.",this.input_slots=[],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Emits the current value when the knob is adjusted.",lo:0,hi:1,def:0}],this.state={val:0},this.knob=null},E2.p.prototype.reset=function(){},E2.p.prototype.set_rotation=function(){var a="rotate("+Math.floor(this.state.val*270)+"deg)";this.knob.css({transform:a,"-moz-transform":a,"-webkit-transform":a})},E2.p.prototype.create_ui=function(){var a=make("div");this.knob=make("div");var b=function(a){return function(b){return a.doc.unbind("mouseup.knob"),a.doc.unbind("mousemove.knob"),b.stopPropagation&&b.stopPropagation(),b.preventDefault&&b.preventDefault(),!1}},c=function(a,b){return function(c){var d=c.pageY-b.last_y,e=a.state.val;return b.last_y=c.pageY,a.state.val-=d*.01,a.state.val=a.state.val<0?0:a.state.val>1?1:a.state.val,a.state.val!==e&&(a.set_rotation(),a.updated=!0),c.stopPropagation&&c.stopPropagation(),c.preventDefault&&c.preventDefault(),!1}},d=function(a){return function(d){var e={doc:$(document),last_y:d.pageY};return e.doc.bind("mouseup.knob",b(e)),e.doc.bind("mousemove.knob",c(a,e)),d.stopPropagation&&d.stopPropagation(),d.preventDefault&&d.preventDefault(),!1}};return a.css({width:"32px",height:"32px","z-index":"3000",background:"url('images/knob/shadow.png')"}),this.knob.css({width:"32px",height:"32px","z-index":"3001",background:"url('images/knob/knob.png')"}),a.append(this.knob),this.knob.mousedown(d(this)),a},E2.p.prototype.update_output=function(a){return this.state.val},E2.p.prototype.state_changed=function(a){a&&this.set_rotation()},E2.p=E2.plugins.delegate_expression_generator=function(a,b){this.desc="Emit a float delegate that resolves an integer parameter '<b>x</b>' to the value of an arbitrary javascript expression that can be contingent on an arbitrary number of dynamic input float slots.",this.input_slots=[],this.output_slots=[{name:"delegate",dt:a.datatypes.DELEGATE,desc:"The resulting float delegate."}],this.state={expression:"",slot_ids:{}},this.core=a,this.node=b,this.gl=a.renderer.context,this.slot_name=[],this.slot_data={}},E2.p.prototype.delegate_func=function(self){return function(x){if(self.state.expression==="")return 0;with(Math)with(self.slot_data)try{var r=eval(self.state.expression);return typeof r=="number"?r:0}catch(e){return msg("ERROR: Failed to evaluate expression: "+e),0}}},E2.p.prototype.reset=function(){},E2.p.prototype.open_editor=function(a,b,c){return function(d){var e=make("span"),f=$("<textarea></textarea>");e.css({margin:"0px",padding:"2px"}),f.css({margin:"0px",padding:"0px","margin-top":"2px",border:"none",width:"455px",height:"400px",resize:"none","font-size":"9pt","font-family":"Monospace",overflow:"scroll","word-wrap":"normal","white-space":"pre","background-color":"#ddd"}),f.val(a.state.expression),e.append(f);var g=make("span"),h=$('<input id="add_btn" type="button" value="Add slot" title="Click to add new delegate input slot." />'),i=$('<input id="rem_btn" type="button" value="Remove slot" title="Click to remove the selected slot(s)." />'),j=$('<select size="4" />');j.css({border:"none",width:"457px","margin-left":"2px","background-color":"#ddd"}),g.css("width","455px"),g.append(h),g.append(i),e.append(make("br")),e.append(g),e.append(make("br")),e.append(j);for(var k in a.state.slot_ids){var l=a.state.slot_ids[k];j.append($("<option>",{value:l}).text(k))}h.click(function(a){return function(b){var c=make("div"),d=$('<input type="input" />'),e=make("span"),f=$("<div>Identifier:</div>");d.css("width","220px"),f.css({"padding-top":"3px","float":"left",width:"80px"}),e.append(f),e.append(d),c.append(e);var g=function(a){return function(){var b=d.val(),e=b.replace(" ","_").toLowerCase(),f=a.node.add_slot(E2.slot_type.input,{name:e,dt:a.core.datatypes.FLOAT});a.state.slot_ids[e]=f,a.slot_name[f]=e,a.slot_data[e]=null,j.append($("<option>",{value:f}).text(e)),c.dialog("close")}}(a);c.dialog({width:360,height:170,modal:!0,title:"Create new slot.",show:"slide",hide:"slide",buttons:{OK:function(){g()},Cancel:function(){$(this).dialog("close")}},open:function(){c.keyup(function(a){a.keyCode===$.ui.keyCode.ENTER&&g()})}})}}(a)),i.click(function(a){return function(b){var c=j.val();if(c===null)return;var d=j.find("option[value='"+c+"']").remove().text();c=parseInt(c),delete a.state.slot_ids[d],a.node.remove_slot(E2.slot_type.input,c)}}(a)),e.dialog({width:460,height:150,modal:!0,title:"Edit expression.",show:"slide",hide:"slide",buttons:{OK:function(){c(f.val()),b(e)},Cancel:function(){$(this).dialog("close")}}})}},E2.p.prototype.create_ui=function(){var a=make("div"),b=$('<input id="slot_btn" type="button" value="Edit" title="Click to edit the expression input slots." />');b.css("width","55px");var c=function(a){return function(b){a.updated=!0,b&&b.dialog("close")}}(this);return b.click(this.open_editor(this,c,function(a){return function(b){a.state.expression=b,a.updated=!0}}(this))),a.append(b),a},E2.p.prototype.update_input=function(a,b){this.slot_data[this.slot_name[a.uid]]=b},E2.p.prototype.update_state=function(){},E2.p.prototype.update_output=function(a){return this.delegate},E2.p.prototype.state_changed=function(a){if(!a){this.delegate=new Delegate(this.delegate_func(this),this.core.datatypes.FLOAT,Number.POSITIVE_INFINITY);var b=this.state.slot_ids;for(var c in b){if(!b.hasOwnProperty(c))continue;var d=b[c];this.slot_name[d]=c,this.slot_data[c]=null}}},E2.p=E2.plugins.key_press_generator=function(a,b){this.desc="Emits true on the next update after the key matching the set filter has been pressed and false once after it has been released.",this.input_slots=[],this.output_slots=[{name:"signal",dt:a.datatypes.BOOL,desc:"Emits true once when the set key is pressed."}],this.state={key:0,type:0}},E2.p.prototype.update_output=function(a){return this.key_state},E2.p.prototype.create_ui=function(){var a=[[-1,"[Pick a key]"],[8,"Backspace"],[9,"Tab"],[13,"Enter"],[33,"Page up"],[34,"Page down"],[35,"End"],[36,"Home"],[37,"Left arrow"],[38,"Up arrow"],[39,"Right arrow"],[40,"Down arrow"],[45,"Insert"],[46,"Delete"],[48,"0"],[49,"1"],[50,"2"],[51,"3"],[52,"4"],[53,"5"],[54,"6"],[55,"7"],[56,"8"],[57,"9"],[65,"a"],[66,"b"],[67,"c"],[68,"d"],[69,"e"],[70,"f"],[71,"g"],[72,"h"],[73,"i"],[74,"j"],[75,"k"],[76,"l"],[77,"m"],[78,"n"],[79,"o"],[80,"p"],[81,"q"],[82,"r"],[83,"s"],[84,"t"],[85,"u"],[86,"v"],[87,"w"],[88,"x"],[89,"y"],[90,"z"]],b=make("div"),c=$('<select id="key" title="Select key" />',{selectedIndex:0}),d=$('<select id="o_type" title="Select output signal type" />',{selectedIndex:0});for(var e=0,f=a.length;e<f;e++){var g=a[e];$("<option />",{value:g[0],text:g[1]}).appendTo(c)}return $("<option />",{value:0,text:"Impulse"}).appendTo(d),$("<option />",{value:1,text:"Continuous"}).appendTo(d),c.change(function(a){return function(){a.state.key=parseInt(c.val()),a.reset_keystate(),a.updated=!0,c.blur()}}(this)),d.change(function(a){return function(){a.state.type=parseInt(d.val()),a.updated=!0,d.blur()}}(this)),c.css("width","100px"),d.css("width","100px"),b.append(c),b.append(make("br")),b.append(d),b},E2.p.prototype.key_down=function(a){return function(b){if(b.originalEvent.keyCode!==a.state.key)return;a.key_state=!0,a.updated=!0}},E2.p.prototype.key_up=function(a){return function(b){if(b.originalEvent.keyCode!==a.state.key)return;a.key_state=!1,a.updated=!0}},E2.p.prototype.reset_keystate=function(){this.last_state=this.key_state=!1},E2.p.prototype.update_state=function(){this.state.type===0&&this.key_state===this.last_state&&(this.updated=!1),this.last_state=this.key_state},E2.p.prototype.state_changed=function(a){a?(a.find("#key").val(this.state.key),a.find("#o_type").val(this.state.type)):(this.reset_keystate(),$(document).keydown(this.key_down(this)),$(document).keyup(this.key_up(this)))},E2.p=E2.plugins.record_framebuffer=function(a,b){this.desc="Grab the current framebuffer and transmit frame size and RGB data to a specified recording server.",this.input_slots=[{name:"record",dt:a.datatypes.BOOL,desc:"Switch recording on or off.",def:!1},{name:"url",dt:a.datatypes.TEXT,desc:"URL of the recording server."},{name:"texture",dt:a.datatypes.TEXTURE,desc:"The texture output of a graph."}],this.output_slots=[],this.gl=a.renderer.context},E2.p.prototype.reset=function(){this.url=null,this.texture=null},E2.p.prototype.connection_changed=function(a,b,c){a||(c.index===1?this.url=null:c.index===2&&(this.texture=null))},E2.p.prototype.update_input=function(a,b){a.index===0?this.record=b:a.index===1?this.url=b:a.index===2&&(this.texture=b)},E2.p.prototype.update_state=function(){if(!this.record||!this.url||!this.texture||!this.texture.framebuffer)return;var a=this.gl,b=this.texture.width,c=this.texture.height,d=b*c*4,e=new Uint8Array(d);a.bindFramebuffer(a.FRAMEBUFFER,this.texture.framebuffer),a.readPixels(0,0,b,c,a.RGBA,a.UNSIGNED_BYTE,e),a.bindFramebuffer(a.FRAMEBUFFER,null);var f=[];for(var g=0;g<d;g+=4)f.push(e[g]),f.push(e[g+1]),f.push(e[g+2]);var h=new FormData;h.append("width",b),h.append("height",c),h.append("img_data",f),$.ajax({url:this.url,data:h,async:!1,contentType:!1,processData:!1,type:"POST",success:function(a){msg("Successfully transmitted frame to "+this.url)},error:function(){msg("ERROR: Could not transmit frame to "+this.url)}})},E2.p=E2.plugins.assets_completed_generator=function(a,b){this.desc="Emits the current number of assets that have successfully loaded.",this.input_slots=[],this.output_slots=[{name:"count",dt:a.datatypes.FLOAT,desc:"Number of assets that have successfully loaded."}],this.core=a,this.node=b,this.asset_listener=function(a){return function(){a.node.queued_update=1}}(this),a.asset_tracker.add_listener(this.asset_listener)},E2.p.prototype.reset=function(){},E2.p.prototype.destroy=function(){this.core.asset_tracker.remove_listener(this.asset_listener)},E2.p.prototype.update_output=function(a){return this.core.asset_tracker.completed},E2.p=E2.plugins.perspective_camera=function(a,b){this.desc="Create a new perspective (3D) camera.",this.input_slots=[{name:"FOV",dt:a.datatypes.FLOAT,desc:"Field of view in degrees.",def:45},{name:"near",dt:a.datatypes.FLOAT,desc:"Depth of the near clipping plane.",def:.01},{name:"far",dt:a.datatypes.FLOAT,desc:"Depth of the far clipping plane.",def:1e3},{name:"position",dt:a.datatypes.VECTOR,desc:"Camera position.",def:"0, 0, -2"},{name:"target",dt:a.datatypes.VECTOR,desc:"Camera target.",def:"0, 0, 0"}],this.output_slots=[{name:"camera",dt:a.datatypes.CAMERA,desc:"The resulting camera."}],this.gl=a.renderer.context,this.canvas=a.renderer.canvas[0],this.up=[0,1,0]},E2.p.prototype.update_input=function(a,b){a.index===0?this.fov=b:a.index===1?this.near=b:a.index===2?this.far=b:a.index===3?this.position=b:this.target=b},E2.p.prototype.update_state=function(){var a=this.canvas;mat4.perspective(this.fov,a.width/a.height,this.near,this.far,this.camera.projection),mat4.lookAt(this.position,this.target,this.up,this.camera.view)},E2.p.prototype.update_output=function(a){return this.camera},E2.p.prototype.state_changed=function(a){a||(this.camera=new Camera(this.gl),this.fov=45,this.near=.01,this.far=1e3,this.position=[0,0,-2],this.target=[0,0,0])},E2.p=E2.plugins.aspect_ratio_generator=function(a,b){this.desc="Emits current renderer aspect ratio (width / height).",this.input_slots=[],this.output_slots=[{name:"aspect",dt:a.datatypes.FLOAT,desc:"The current renderer aspect ratio."}],this.canvas=a.renderer.canvas[0]},E2.p.prototype.reset=function(){},E2.p.prototype.update_output=function(a){var b=this.canvas;return b.width/b.height},E2.p=E2.plugins.from_mesh_custom_shader=function(a,b){this.desc="Auto-generate a shader embedding user-defined main bodies tailored to correctly and optimally render the supplied mesh.",this.input_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"Mesh to adapt the shader to."},{name:"material",dt:a.datatypes.MATERIAL,desc:"The surface material."}],this.output_slots=[{name:"shader",dt:a.datatypes.SHADER,desc:"The resulting shader."}],this.state={vs_src:"",ps_src:"",changed:!1,slot_ids:{}},this.core=a,this.node=b,this.gl=a.renderer.context,this.shader=null,this.slot_data=[]},E2.p.prototype.reset=function(){},E2.p.prototype.open_editor=function(a,b,c,d,e){return function(f){var g=make("span"),h=$("<textarea></textarea>");g.css({margin:"0px",padding:"2px"}),h.css({margin:"0px",padding:"0px","margin-top":"2px",border:"none",width:"455px",height:"400px",resize:"none","font-size":"9pt","font-family":"Monospace",overflow:"scroll","word-wrap":"normal","white-space":"pre","background-color":"#ddd"}),h.val(a.state[b]),g.append(h);var i=make("span"),j=$('<input id="comp_btn" type="button" value="Compile" title="Click to rebuild the shader." />'),k=$('<input id="add_btn" type="button" value="Add slot" title="Click to add new shader input slot." />'),l=$('<input id="rem_btn" type="button" value="Remove slot" title="Click to remove the selected slot(s)." />'),m=$('<select size="4" />');m.css({border:"none",width:"457px","margin-left":"2px","background-color":"#ddd"}),i.css("width","455px"),i.append(j),i.append(k),i.append(l),g.append(make("br")),g.append(i),g.append(make("br")),g.append(m);for(var n in a.state.slot_ids){var o=a.state.slot_ids[n];m.append($("<option>",{value:o.id}).text(n))}j.click(function(a){e(h.val()),d(null)}),k.click(function(a){return function(b){var c=make("div"),d=$('<input type="input" />'),e=$("<select />"),f=a.core.datatypes,g=[f.FLOAT,f.TEXTURE,f.COLOR,f.MATRIX,f.VECTOR];for(var h=0,i=g.length;h<i;h++){var j=g[h];e.append($("<option>",{value:j.id}).text(j.name))}var k=make("span"),l=$("<div>Identifier:</div>");d.css("width","220px"),l.css({"padding-top":"3px","float":"left",width:"80px"}),k.append(l),k.append(d),c.append(k),c.append(make("br"));var n=make("span");l=$("<div>Data type:</div>"),l.css({"padding-top":"3px","float":"left",width:"78px"}),n.append(l),n.append(e),c.append(n);var o=function(a){return function(){var b=d.val(),f=parseInt(e.val());for(var g in a.core.datatypes){g=a.core.datatypes[g];if(g.id===f){var h=b.replace(/[^\w]/gi,"_").toLowerCase(),i=a.node.add_slot(E2.slot_type.input,{name:h,dt:g});a.state.slot_ids[h]={id:i,dt:g,uniform:null},a.slot_data[i]=a.core.get_default_value(E2.slot_type.input,g),m.append($("<option>",{value:i}).text(h));break}}c.dialog("close"),a.dirty=!0}}(a);c.dialog({width:360,height:170,modal:!0,title:"Create new slot.",buttons:{OK:function(){o()},Cancel:function(){$(this).dialog("close")}},open:function(){c.keyup(function(a){a.keyCode===$.ui.keyCode.ENTER&&o()})}})}}(a)),l.click(function(a){return function(b){var c=m.val();if(c===null)return;var d=m.find("option[value='"+c+"']").remove().text();c=parseInt(c),delete a.state.slot_ids[d],a.node.remove_slot(E2.slot_type.input,c),a.dirty=!0}}(a)),g.dialog({width:460,height:150,modal:!0,title:"Edit "+c+" shader.",buttons:{OK:function(){e(h.val()),d(g)},Cancel:function(){$(this).dialog("close")}}})}},E2.p.prototype.create_ui=function(){var a=make("div"),b=$('<input id="vs_btn" type="button" value="Vertex" title="Click to edit the vertex shader source." />'),c=$('<input id="ps_btn" type="button" value="Pixel" title="Click to edit the pixel shader source." />');b.css("width","55px"),c.css("width","55px");var d=function(a){return function(b){a.updated=a.dirty=!0,a.node.queued_update=1,b&&b.dialog("close")}}(this);return b.click(this.open_editor(this,"vs_src","vertex",d,function(a){return function(b){a.state.vs_src=b,a.state.changed=!0}}(this))),c.click(this.open_editor(this,"ps_src","pixel",d,function(a){return function(b){a.state.ps_src=b,a.state.changed=!0}}(this))),a.append(b),a.append(make("br")),a.append(c),a},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?(this.mesh=null,this.shader=null):c.index===1&&(this.material=null))},E2.p.prototype.rebuild_shader=function(){var a="",b="",c=this.state,d=this.gl,e=this.core.datatypes;for(var f in c.slot_ids){var g="",h=c.slot_ids[f],i=h.dt.id;i===e.FLOAT.id?g="float":i===e.TEXTURE.id?g="sampler2D":i===e.COLOR.id?g="vec4":i===e.MATRIX.id?g="mat4":i===e.VECTOR.id&&(g="vec3"),i!==e.TEXTURE.id&&(a+="uniform "+g+" "+f+";\n"),b+="uniform "+g+" "+f+";\n"}this.shader=ComposeShader(null,this.mesh,this.material,a,b,c.vs_src&&c.changed?c.vs_src:null,c.ps_src&&c.changed?c.ps_src:null);for(var f in c.slot_ids){var h=c.slot_ids[f];h.uniform=d.getUniformLocation(this.shader.program,f)}this.shader.apply_uniforms_custom=function(a){return function(){var b=1,e=a.slot_data,f=a.core.datatypes;for(var g in c.slot_ids){var h=c.slot_ids[g];if(h.uniform===null||e[h.id]===null)continue;var i=h.dt.id;i===f.FLOAT.id?d.uniform1f(h.uniform,e[h.id]):i===f.TEXTURE.id?(d.uniform1i(h.uniform,b),e[h.id].enable(d.TEXTURE0+b),b++):i===f.COLOR.id?d.uniform4fv(h.uniform,new Float32Array(e[h.id].rgba)):i===f.MATRIX.id?d.uniformMatrix4fv(h.uniform,!1,e[h.id]):i===f.VECTOR.id&&d.uniform3fv(h.uniform,new Float32Array(e[h.id]))}}}(this),c.vs_src===""&&(c.vs_src=this.shader.vs_c_src),c.ps_src===""&&(c.ps_src=this.shader.ps_c_src)},E2.p.prototype.update_input=function(a,b){a.uid===undefined?a.index===0?this.mesh!==b&&(this.mesh=b,this.dirty=!0):a.index===1&&(this.material=b):this.slot_data[a.uid]=b},E2.p.prototype.update_state=function(){if(!this.mesh)return;var a=Material.get_caps_hash(this.mesh,this.material);if(!this.dirty&&this.caps_hash===a){this.shader.material=this.material;return}(this.dirty||this.caps_hash!==a)&&this.rebuild_shader(),this.caps_hash=a,this.updated=!0,this.dirty=!1},E2.p.prototype.update_output=function(a){return this.shader},E2.p.prototype.state_changed=function(a){a||(this.mesh=null,this.material=null,this.caps_mask="",this.dirty=!1)},E2.p=E2.plugins.light_diffuse_color_modulator=function(a,b){this.desc="Sets the diffuse color of the light source.",this.input_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"Input light."},{name:"color",dt:a.datatypes.COLOR,desc:"The light diffuse color.",def:"White"}],this.output_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"The modified light."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.light=b:this.color=b},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.light=new Light)},E2.p.prototype.update_state=function(){this.light.diffuse_color=this.color},E2.p.prototype.update_output=function(a){return this.light},E2.p.prototype.state_changed=function(a){a||(this.light=new Light,this.color=new Color(1,1,1,1))},E2.p=E2.plugins.from_mesh_shader=function(a,b){this.desc="Auto-generate a shader tailored to correctly and optimally render the supplied mesh.",this.input_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"Mesh to adapt the shader to."},{name:"material",dt:a.datatypes.MATERIAL,desc:"The surface material."}],this.output_slots=[{name:"shader",dt:a.datatypes.SHADER,desc:"The resulting shader."}],this.shader=null},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?(this.mesh=null,this.shader=null):c.index===1&&(this.material=null))},E2.p.prototype.update_input=function(a,b){a.index===0?this.mesh!==b&&(this.mesh=b,this.dirty=!0):a.index===1&&(this.material=b)},E2.p.prototype.update_state=function(){if(!this.mesh)return;var a=Material.get_caps_hash(this.mesh,this.material);if(!this.dirty&&this.caps_hash===a){this.shader.material=this.material;return}if(this.dirty||this.caps_hash!==a)msg("Recomposing shader with caps: "+this.caps_hash),this.shader=ComposeShader(null,this.mesh,this.material,null,null,null,null);this.caps_hash=a,this.updated=!0,this.dirty=!1},E2.p.prototype.update_output=function(a){return this.shader},E2.p.prototype.state_changed=function(a){a||(this.mesh=null,this.material=null,this.caps_hash="",this.dirty=!0)},E2.p=E2.plugins.toggle_button=function(a,b){this.desc="Toggle button that emits true and false as it is clicked.",this.input_slots=[],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"True or false is emitted on the next update after the buttons has been clicked.",def:"False"}],this.state={enabled:!1},this.node=b},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=$('<input id="state" type="button" value="Enable" />');return a.click(function(b){return function(c){b.state.enabled=!b.state.enabled,b.state_changed(a),b.node.update_connections()&&E2.app.updateCanvas(!0),b.updated=!0}}(this)),a},E2.p.prototype.update_output=function(a){return this.state.enabled},E2.p.prototype.state_changed=function(a){a&&a.prop("value",this.state.enabled?"Disable":"Enable")},E2.p=E2.plugins.texture_type_generator=function(a,b){this.desc="Select texture type.",this.input_slots=[],this.output_slots=[{name:"type",dt:a.datatypes.FLOAT,desc:"Emits the selected texture type when requested or the selection state changes.",def:"Diffuse color"}],this.state={type:Material.texture_type.DIFFUSE_COLOR}},E2.p.prototype.reset=function(){},E2.p.prototype.create_ui=function(){var a=Material.texture_type,b=$("<select />",{selectedIndex:0});return $("<option />",{value:a.DIFFUSE_COLOR,text:"Diffuse color"}).appendTo(b),$("<option />",{value:a.EMISSION_COLOR,text:"Emission color"}).appendTo(b),$("<option />",{value:a.SPECULAR_COLOR,text:"Specular color"}).appendTo(b),$("<option />",{value:a.NORMAL,text:"Normal"}).appendTo(b),b.change(function(a){return function(){a.state.type=parseInt(b.val()),a.state_changed(b),a.updated=!0}}(this)),b},E2.p.prototype.update_output=function(a){return this.state.type},E2.p.prototype.state_changed=function(a){a&&a.val(""+this.state.type)},E2.p=E2.plugins.clamp_modulator=function(a,b){this.desc="Emit a float <b>value</b> no less than <b>min</b> and no greater than <b>max</b>.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Value to be clipped.",def:0},{name:"min",dt:a.datatypes.FLOAT,desc:"Minimum output value.",def:0},{name:"max",dt:a.datatypes.FLOAT,desc:"Maximum output value.",def:1}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"Emits <b>min</b> <= <b>value</b> >= <b>max</b>.",def:0}]},E2.p.prototype.reset=function(){this.input_val=0,this.min_value=0,this.max_value=1,this.output_val=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.input_val=b:a.index===1?this.min_value=b:this.max_value=b},E2.p.prototype.update_state=function(){var a=this.min_value,b=this.max_value,c=this.input_val;if(a>b){var d=a;a=b,b=d}this.output_val=c<a?a:c>b?b:c},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.modulate_modulator=function(a,b){this.desc="Modulate <b>value</b> such that the result will always be never be negative and less than or equal to <b>limit</b>.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value to be modulated.",def:0},{name:"limit",dt:a.datatypes.FLOAT,desc:"Divisor.",lo:">0",def:1}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"Emits the remainder of <b>value</b> divided by <b>limit</b>",def:0}]},E2.p.prototype.reset=function(){this.input_val=0,this.limit_val=1,this.output_val=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.input_val=b:this.limit_val=b==0?1:b},E2.p.prototype.update_state=function(){this.output_val=this.input_val%this.limit_val},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.string_concatenate_modulator=function(a,b){this.desc="Concatenates the two supplied strings.",this.input_slots=[{name:"text",dt:a.datatypes.TEXT,desc:"The first string."},{name:"text",dt:a.datatypes.TEXT,desc:"The second string."}],this.output_slots=[{name:"result",dt:a.datatypes.TEXT,desc:"The string representing the combination of <b>first</b> + <b>second</b>."}]},E2.p.prototype.reset=function(){this.text_a="",this.text_b="",this.output_val=""},E2.p.prototype.update_input=function(a,b){a.index===0?this.text_a=""+b:this.text_b=""+b},E2.p.prototype.update_state=function(){this.output_val=this.text_a+this.text_b},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.tan_modulator=function(a,b){this.desc="Tan(x).",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"tan(<b>value</b>).",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){this.value=Math.tan(b)},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.less_than_modulator=function(a,b){this.desc="Emits true if the supplied <b>value</b> is less than <b>reference</b> and false otherwise.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value to compare.",def:0},{name:"reference",dt:a.datatypes.FLOAT,desc:"Reference to compare <b>value</b> to.",def:0}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Emits true if <b>value</b> is less than <b>reference</b> and false otherwise.",def:"False"}]},E2.p.prototype.reset=function(){this.value=0,this.ref=0,this.state=null},E2.p.prototype.update_input=function(a,b){a.index===0?this.value=b:this.ref=b},E2.p.prototype.update_state=function(){var a=this.value<this.ref;a!==this.state?this.state=a:this.updated=!1},E2.p.prototype.update_output=function(a){return this.state},E2.p=E2.plugins.register_local_write=function(a,b){this.desc="Write to a local register using name of the node, the value of which can subsequently be read."
,this.input_slots=[],this.output_slots=[],this.state={slot_id:b.add_slot(E2.slot_type.input,{name:"value",dt:a.datatypes.ANY,desc:""})},this.core=a,this.node=b,b.title?this.old_title=b.title:this.old_title=b.title="reg_"+b.uid},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.destroy=function(){this.regs.unlock(this,this.node.title)},E2.p.prototype.register_dt_changed=function(a){this.node.change_slot_datatype(E2.slot_type.input,this.state.slot_id,a)},E2.p.prototype.renamed=function(){this.regs.unlock(this,this.old_title),this.regs.lock(this,this.node.title)},E2.p.prototype.connection_changed=function(a,b,c){var d=this.regs.connection_changed(this.node.title,a);a&&d===1&&this.regs.set_datatype(this.node.title,b.src_slot.dt)},E2.p.prototype.update_input=function(a,b){this.regs.write(this.node.title,b)},E2.p.prototype.target_reg=function(a){var b=this.node.find_dynamic_slot(E2.slot_type.input,this.state.slot_id);this.regs.lock(this,a);var c=this.regs.registers[a].dt;c!==this.core.datatypes.ANY&&this.register_dt_changed(b.dt)},E2.p.prototype.state_changed=function(a){if(!a){var b=this.node;this.regs=b.parent_graph.registers,this.target_reg(b.title)}else this.node.ui.dom.addClass("register")},E2.p=E2.plugins.instance_rotate_modulator=function(a,b){this.desc="Rotate every mesh instance contained in the scene by an amount specified by supplying three delegates. The delegates will be evaluated using the mesh instance index.",this.input_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The scene to to rotate the instances in."},{name:"x-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to an angle to rotate about the x-axis given a mesh index."},{name:"y-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to an angle to rotate about the y-axis given a mesh index."},{name:"z-delegate",dt:a.datatypes.DELEGATE,desc:"The delegate that evaluates to an angle to rotate about the z-axis given a mesh index."}],this.output_slots=[{name:"scene",dt:a.datatypes.SCENE,desc:"The modified scene."}]},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&(c.index===0?this.scene=null:c.index===1?this.x_delegate=null:c.index===2?this.y_delegate=null:c.index===3&&(this.z_delegate=null))},E2.p.prototype.update_input=function(a,b){a.index===0?this.scene=b:a.index===1?this.x_delegate=b:a.index===2?this.y_delegate=b:a.index===3&&(this.z_delegate=b)},E2.p.prototype.update_state=function(){if(this.scene&&(this.x_delegate||this.y_delegate||this.z_delegate)){var a=this.scene.meshes;for(var b=0,c=a.length;b<c;b++){var d=a[b];if(d.instance_transforms){var e=this.m;for(var f=0,g=d.instances.length;f<g;f++)mat4.identity(e),this.x_delegate&&mat4.rotateX(e,this.x_delegate.delegate(f)),this.y_delegate&&mat4.rotateY(e,this.y_delegate.delegate(f)),this.z_delegate&&mat4.rotateZ(e,this.z_delegate.delegate(f)),mat4.multiply(d.instance_transforms[f],e)}}}},E2.p.prototype.update_output=function(a){return this.scene},E2.p.prototype.state_changed=function(a){a||(this.scene=null,this.m=mat4.create(),this.x_delegate=null,this.y_delegate=null,this.z_delegate=null)},E2.p=E2.plugins.sqrt_modulator=function(a,b){this.desc="Sqrt(x).",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"sqrt(<b>value</b>).",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=Math.sqrt(b))},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.convert_color_hsla_modulator=function(a,b){this.desc="Create an RGBA color from hue, saturation and luminosity and alpha.",this.input_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"The corresponding RGBA color.",def:"Black"}],this.output_slots=[{name:"hue",dt:a.datatypes.FLOAT,desc:"The hue of the input <b>color</b>.",lo:0,hi:1,def:0},{name:"saturation",dt:a.datatypes.FLOAT,desc:"The saturation (color intensity) of the input <b>color</b>.",lo:0,hi:1,def:0},{name:"luminosity",dt:a.datatypes.FLOAT,desc:"The luminosity (brightness) of the input <b>color</b>.",lo:0,hi:1,def:0},{name:"alpha",dt:a.datatypes.FLOAT,desc:"The alpha of the input <b>color</b>.",lo:0,hi:1,def:0}]},E2.p.prototype.reset=function(){this.hsla=[0,0,0,1],this.color=new Color(0,0,0,1)},E2.p.prototype.update_input=function(a,b){this.color=b},E2.p.prototype.update_state=function(){var a=this.color.rgba;this.hsla[0]=this.hsla[1]=this.hsla[2]=0,this.hsla[3]=a[3];var b=Math.max(Math.max(a[0],a[1]),a[2]),c=Math.min(Math.min(a[0],a[1]),a[2]),d=(c+b)*.5;if(d<=0)return;var e=b-c,f=e;this.hsla[2]=d;if(f>0)f/=d<=.5?c+b:2-b-c;else return;var g=(b-a[0])/e,h=(b-a[1])/e,i=(b-a[2])/e,j=0;a[0]==b?j=a[1]==c?5+i:1-h:a[1]==b?j=a[2]==c?1+g:3-i:j=a[0]==c?3+h:5-g,this.hsla[0]=j/6,this.hsla[1]=f},E2.p.prototype.update_output=function(a){return this.hsla[a.index]},E2.p=E2.plugins.max_modulator=function(a,b){this.desc="Emit the greater of the two input values.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The first input value",def:0},{name:"value",dt:a.datatypes.FLOAT,desc:"The second input value",def:0}],this.output_slots=[{name:"max",dt:a.datatypes.FLOAT,desc:"The larger of the two supplied values.",def:0}]},E2.p.prototype.reset=function(){this.val_a=0,this.val_b=0,this.output_val=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.val_a=b:this.val_b=b},E2.p.prototype.update_state=function(){this.output_val=Math.max(this.val_a,this.val_b)},E2.p.prototype.update_output=function(a){return this.output_val},E2.p=E2.plugins.sample_and_hold_modulator=function(a,b){this.desc="Emits the input value when 'sample' is true and emits the last sampled value otherwise. Emits zero by default.",this.input_slots=[{name:"sample",dt:a.datatypes.BOOL,desc:"Sending true to this slot updated the output value to match the input value, false inhibits input sampling.",def:"True"},{name:"value",dt:a.datatypes.FLOAT,desc:"The input value.",def:0}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"The output value.",def:0}],this.state={value:0}},E2.p.prototype.reset=function(){this.has_updated=!1,this.updated=!0,this.last_state=!0},E2.p.prototype.update_input=function(a,b){a.index===0?this.sample=b:this.buffer=b},E2.p.prototype.update_state=function(){this.sample?this.state.value=this.buffer:this.has_updated&&(this.updated=!1),!this.sample&&this.last_state&&(this.last_state=this.sample,this.has_updated=!1)},E2.p.prototype.update_output=function(a){return this.has_updated=!0,this.state.value},E2.p.prototype.state_changed=function(a){a||(this.state.value=0,this.buffer=0,this.sample=!0)},E2.p=E2.plugins.tween_out_modulator=function(a,b){this.desc="Perform tween out over time.",this.input_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Time ranging from zero to one.",def:0,lo:0,hi:1}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"Emits a tween out over <b>time</b>.",def:0}],this.state={type:0}},E2.p.prototype.create_ui=function(){var a=$("<select />",{selectedIndex:0}),b=function(b,c){$("<option />",{value:b,text:c}).appendTo(a)};return b(0,"Circular"),b(1,"Cubic"),b(2,"Exponential"),b(3,"Quadratic"),b(4,"Quartic"),b(5,"Quintic"),b(6,"Sinusoidal"),a.change(function(b){return function(){b.state.type=parseInt(a.val())}}(this)),a},E2.p.prototype.reset=function(){this.result=0,this.time=0},E2.p.prototype.update_input=function(a,b){this.time=b<0?0:b>1?1:b},E2.p.prototype.update_state=function(){var a=0,b=this.time;switch(this.state.type){case 0:a=Math.sqrt(1- --b*b);break;case 1:a=--b*b*b+1;break;case 2:a=b===1?1:1-Math.pow(2,-10*b);break;case 3:a=b*(2-b);break;case 4:a=1- --b*b*b*b;break;case 5:a=--b*b*b*b*b+1;break;case 6:a=Math.sin(b*Math.PI/2);break;default:}this.result=a},E2.p.prototype.update_output=function(a){return this.result},E2.p.prototype.state_changed=function(a){a&&a.val(""+this.state.type)},E2.p=E2.plugins.xor_modulator=function(a,b){this.desc="Emits true when the values of the two inputs are different and false when they're identical.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"The first operand.",def:"False"},{name:"bool",dt:a.datatypes.BOOL,desc:"The second operand.",def:"False"}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Emits true if <b>first</b> does not equal <b>second</b> and false otherwise.",def:"False"}]},E2.p.prototype.reset=function(){this.conds=[!1,!1],this.state=!1},E2.p.prototype.update_input=function(a,b){this.conds[a.index]=b},E2.p.prototype.update_state=function(){this.state=this.conds[0]?!this.conds[1]:this.conds[1]},E2.p.prototype.update_output=function(a){return this.state},E2.p=E2.plugins.floor_modulator=function(a,b){this.desc="Round <b>value</b> to the closest lower interger.",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Value to be rounded.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"The rounded result.",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=Math.floor(b))},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.mesh_renderer_emitter=function(a,b){this.desc="Render the supplied <b>mesh</b>. If no <b>shader</b> is specified, the internal shader (if any) of the <b>mesh</b> is used.",this.input_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"The input mesh to be rendered."},{name:"shader",dt:a.datatypes.SHADER,desc:"Connect to this slot to use the supplied shader in favor of the one specified by the mesh (if any).",def:"Use mesh shader"},{name:"camera",dt:a.datatypes.CAMERA,desc:"Camera to use for rendering.",def:"Screenspace camera."},{name:"transform",dt:a.datatypes.MATRIX,desc:"Mesh transform.",def:"Identity"}],this.output_slots=[],this.gl=a.renderer.context},E2.p.prototype.reset=function(){this.mesh=null,this.shader=null},E2.p.prototype.update_input=function(a,b){a.index===0?this.mesh=b:a.index===1?this.shader=b:a.index===2?this.camera=b:a.index===3&&(this.transform=b)},E2.p.prototype.connection_changed=function(a,b,c){a||(c.index===0?this.mesh=null:c.index===1&&(this.shader=null))},E2.p.prototype.update_state=function(){var a=this.mesh;if(!a)return;this.shader?a.render(this.camera,this.transform,this.shader,this.shader.material):a.render(this.camera,this.transform,a.shader,a.material)},E2.p.prototype.state_changed=function(a){a||(this.camera=new Camera,this.transform=mat4.create(),mat4.identity(this.transform))},E2.p=E2.plugins.convert_hsla_color_modulator=function(a,b){this.desc="Create an RGBA color from hue, saturation and luminosity and alpha.",this.input_slots=[{name:"hue",dt:a.datatypes.FLOAT,desc:"The hue of the output color.",lo:0,hi:1,def:1},{name:"saturation",dt:a.datatypes.FLOAT,desc:"The saturation (color intensity) of the output color.",lo:0,hi:1,def:1},{name:"luminosity",dt:a.datatypes.FLOAT,desc:"The luminosity (brightness) of the output color.",lo:0,hi:1,def:1},{name:"alpha",dt:a.datatypes.FLOAT,desc:"The alpha of the output color.",lo:0,hi:1,def:1}],this.output_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"The corresponding RGBA color.",def:"White"}]},E2.p.prototype.reset=function(){this.hsla=[1,1,1,1],this.color=new Color(1,1,1,1)},E2.p.prototype.update_input=function(a,b){this.hsla[a.index]=b<0?0:b>1?1:b},E2.p.prototype.update_state=function(){var a=this.hsla[1],b=this.hsla[2],c=this.color.rgba;c[3]=this.hsla[3];if(a===0){c[0]=c[1]=c[2]=b;return}var d=this.hsla[0],e=b<=.5?b*(1+a):b+a-b*a,f=2*b-e,g=[d+1/3,d,d-1/3];for(var h=0;h<3;h++){g[h]<0&&(g[h]+=1),g[h]>1&&(g[h]-=1);var i=g[h];6*i<1?c[h]=f+(e-f)*i*6:2*i<1?c[h]=e:3*i<2?c[h]=f+(e-f)*(2/3-i)*6:c[h]=f}},E2.p.prototype.update_output=function(a){return this.color},E2.p=E2.plugins.nand_modulator=function(a,b){this.desc="Emits false when both inputs are true and false otherwise.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"The first operand.",def:"False"},{name:"bool",dt:a.datatypes.BOOL,desc:"The second operand.",def:"False"}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Emits false if <b>first</b> and <b>second</b> are true and false otherwise.",def:"False"}]},E2.p.prototype.reset=function(){this.conds=[!1,!1],this.state=!1},E2.p.prototype.update_input=function(a,b){this.conds[a.index]=b},E2.p.prototype.update_state=function(){this.state=!this.conds[0]||!this.conds[1]},E2.p.prototype.update_output=function(a){return this.state},E2.p=E2.plugins.texture_diffuse_shader=function(a,b){this.desc="Simple shader for rendering meshes with one texture modulated by a diffuse color.",this.input_slots=[{name:"material",dt:a.datatypes.MATERIAL,desc:"The surface material."},{name:"uv offset",dt:a.datatypes.VECTOR,desc:"UV translation. Only the x and y components are used with the z axis disregarded."},{name:"uv scale",dt:a.datatypes.VECTOR,desc:"UV scale. Only the x and y components are used with the z axis factor disregarded."},{name:"uv rotation",dt:a.datatypes.FLOAT,desc:"UV rotation in degrees."}],this.output_slots=[{name:"shader",dt:a.datatypes.SHADER,desc:"The resulting shader."}];var c="attribute vec3 v_pos;attribute vec2 v_uv0;varying vec2 f_uv0;uniform mat4 m_mat;uniform mat4 v_mat;uniform mat4 p_mat;uniform vec2 uv_offset;uniform vec2 uv_scale;uniform float uv_rotation;void main(void) {    gl_Position = p_mat * v_mat * m_mat * vec4(v_pos, 1.0);    float cs = cos(uv_rotation);    float sn = sin(uv_rotation);    f_uv0 = vec2((((v_uv0.x * cs) - (v_uv0.y * sn)) * uv_scale.x) + uv_offset.x, (((v_uv0.x * sn) + (v_uv0.y * cs)) * uv_scale.y) + uv_offset.y);}",d="precision mediump float;varying vec2 f_uv0;uniform sampler2D tex0;uniform vec4 a_col;uniform vec4 d_col;uniform int e2_alpha_clip;void main(void) { vec4 c = texture2D(tex0, f_uv0.st); c *= d_col; c.rgb += a_col.rgb; if(e2_alpha_clip > 0 && c.a < 0.5) discard; gl_FragColor = vec4(c); }",e=this.gl=a.renderer.context;this.def_ambient=new Float32Array([0,0,0,1]),this.def_diffuse=new Float32Array([1,1,1,1]),this.s=new ShaderProgram(e),this.vs=new Shader(e,e.VERTEX_SHADER,c),this.ps=new Shader(e,e.FRAGMENT_SHADER,d);var f=this.s.program;this.s.attach(this.vs),this.s.attach(this.ps),this.s.link(),this.s.v_pos=e.getAttribLocation(f,"v_pos"),this.s.v_uv0=e.getAttribLocation(f,"v_uv0"),this.s.m_mat=e.getUniformLocation(f,"m_mat"),this.s.v_mat=e.getUniformLocation(f,"v_mat"),this.s.p_mat=e.getUniformLocation(f,"p_mat"),this.s.a_col=e.getUniformLocation(f,"a_col"),this.s.d_col=e.getUniformLocation(f,"d_col"),this.s.tex0=e.getUniformLocation(f,"tex0"),this.s.uv_offset=e.getUniformLocation(f,"uv_offset"),this.s.uv_scale=e.getUniformLocation(f,"uv_scale"),this.s.uv_rotation=e.getUniformLocation(f,"uv_rotation"),this.s.e2_alpha_clip=e.getUniformLocation(f,"e2_alpha_clip"),this.s.bind_array=function(a,b){return function(a,c,d){var e=VertexBuffer.vertex_type,f=null;if(a===e.VERTEX)f=this.v_pos;else if(a===e.UV0)f=this.v_uv0;else return;b.bindBuffer(b.ARRAY_BUFFER,c),b.enableVertexAttribArray(f),b.vertexAttribPointer(f,d,b.FLOAT,!1,0,0)}}(this.s,e),this.s.apply_uniforms=function(a,b){return function(c){var d=a.material?a.material:c.material;b.uniform4fv(a.s.a_col,d.ambient_color?new Float32Array(d.ambient_color.rgba):this.def_ambient),b.uniform4fv(a.s.d_col,d.diffuse_color?new Float32Array(d.diffuse_color.rgba):this.def_diffuse),b.enableVertexAttribArray(a.s.v_pos),b.enableVertexAttribArray(a.s.v_uv0),b.uniform2fv(a.s.uv_offset,a.uv_offset),b.uniform2fv(a.s.uv_scale,a.uv_scale),b.uniform1f(a.s.uv_rotation,a.uv_rotation),b.uniform1i(a.s.e2_alpha_clip,d.alpha_clip?1:0);var e=!1;if(a.material){var f=a.material.textures[Material.texture_type.DIFFUSE_COLOR];f&&(b.uniform1i(a.s.tex0Uniform,0),f.enable(b.TEXTURE0),e=!0)}if(!e){var f=c.material.textures[Material.texture_type.DIFFUSE_COLOR];f?(b.uniform1i(this.tex0Uniform,0),f.enable(b.TEXTURE0)):b.bindTexture(b.TEXTURE_2D,null)}d.enable()}}(this,e)},E2.p.prototype.update_input=function(a,b){a.index===0?this.material=b:a.index===1?this.uv_offset=new Float32Array([b[0],b[1]]):a.index===2?this.uv_scale=new Float32Array([b[0],b[1]]):a.index===3&&(this.uv_rotation=b%360/180*Math.PI)},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.material=null)},E2.p.prototype.update_output=function(a){return this.s},E2.p.prototype.state_changed=function(a){a||(this.material=null,this.uv_offset=new Float32Array([0,0]),this.uv_scale=new Float32Array([1,1]),this.uv_rotation=0)},E2.p=E2.plugins.sin_modulator=function(a,b){this.desc="Sin(x).",this.input_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Input value.",def:0}],this.output_slots=[{name:"result",dt:a.datatypes.FLOAT,desc:"sin(<b>value</b>).",def:0}]},E2.p.prototype.reset=function(){this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0&&(this.value=Math.sin(b))},E2.p.prototype.update_output=function(a){return this.value},E2.p=E2.plugins.color_blend_modulator=function(a,b){this.desc="Color x-fader. Perform linear blend between two colors.",this.input_slots=[{name:"color A",dt:a.datatypes.COLOR,desc:"First color operand.",def:"Black"},{name:"color B",dt:a.datatypes.COLOR,desc:"Second color operand.",def:"Black"},{name:"mix",dt:a.datatypes.FLOAT,desc:"0: Emit pure color A\n1: Emit pure color B",lo:0,hi:1,def:.5}],this.output_slots=[{name:"color",dt:a.datatypes.COLOR,desc:"Linear mix of color A and B:\n\nA * (1 - mix) + B * mix"}]},E2.p.prototype.reset=function(){this.output_color=new Color(0,0,0)},E2.p.prototype.update_input=function(a,b){a.index===0?this.color_a=b:a.index===1?this.color_b=b:this.mix=b},E2.p.prototype.update_state=function(){var a=this.mix,b=1-a,c=this.color_a.rgba,d=this.color_b.rgba,e=this.output_color.rgba;for(var f=0;f<4;f++)e[f]=c[f]*a+d[f]*b},E2.p.prototype.update_output=function(a){return this.output_color},E2.p.prototype.state_changed=function(a){a||(this.color_a=new Color(0,0,0),this.color_b=new Color(0,0,0),this.output_color=new Color(0,0,0),this.mix=.5)},E2.p=E2.plugins.video_get_current_time_modulator=function(a,b){this.desc="Get the current playback time of the supplied video in seconds.",this.input_slots=[{name:"video",dt:a.datatypes.VIDEO,desc:"Input video."}],this.output_slots=[{name:"time",dt:a.datatypes.FLOAT,desc:"Current playback time.",def:0}]},E2.p.prototype.reset=function(){this.time=0,this.video=null},E2.p.prototype.update_input=function(a,b){this.video=b},E2.p.prototype.update_output=function(a){return this.updated=!0,this.video?this.video.currentTime:0},E2.p=E2.plugins.reset_framebuffer_recorder=function(a,b){this.desc="Instruct the specified framedump server to clear its cache and start recording at from zero.",this.input_slots=[{name:"reset",dt:a.datatypes.BOOL,desc:"Send true to this slot to reset the specified server.",def:!1},{name:"url",dt:a.datatypes.TEXT,desc:"URL of the recording server."}],this.output_slots=[],this.clear=!1},E2.p.prototype.reset=function(){this.url=null},E2.p.prototype.connection_changed=function(a,b,c){a||(c.index===0?this.clear=!1:c.index===1&&(this.url=null))},E2.p.prototype.update_input=function(a,b){a.index===0&&b?this.clear=!0:a.index===1&&(this.url=b)},E2.p.prototype.update_state=function(){if(!this.clear||!this.url||this.url.length<1)return;var a=this.url;a[a.length-1]!="/"&&(a+="/"),a+="reset",$.ajax({url:a,async:!1,contentType:!1,processData:!1,type:"GET",success:function(a){msg("Framdumping reset to frame 0")},error:function(){msg("ERROR: Failed to reset the speficied framedumping server: "+this.url)}}),this.clear=!1},E2.p=E2.plugins.data_info_display=function(a,b){this.desc="Displays metrics about the input value and its type.",this.input_slots=[{name:"any",dt:a.datatypes.ANY,desc:"Input value to be analyzed."}],this.output_slots=[]},E2.p.prototype.reset=function(){this.update_value(null)},E2.p.prototype.create_ui=function(){return this.label=make("pre"),this.update_value(null),this.label},E2.p.prototype.connection_changed=function(a,b,c){a||this.update_value(null)},E2.p.prototype.update_input=function(a,b){this.update_value(b)},E2.p.prototype.update_value=function(a){if(this.label){var b=function(a){return type=typeof a,type==="object"&&!a?"null":type},c=function(a,d,e,f){e=e||"  ",b(f)!=="number"&&(f=1);var g=b(d);if(g==="function")return"";var h=e+a+"("+g+") :";if(g==="object"){if(f>0){e+="  ";for(i in d){var i=c(i,d[i],e,f-1);h+="\n"+i}return h}return h+" ..."}return g==="null"?h+" null":h+" "+d};this.label[0].innerHTML=c("",a)}},E2.p=E2.plugins.quad_mesh_generator=function(a,b){this.desc="Create a planar quad mesh in the XY-plane of unit size with normals and one set of UV-cordinates.",this.input_slots=[],this.output_slots=[{name:"mesh",dt:a.datatypes.MESH,desc:"Quad mesh."}],this.gl=a.renderer.context,this.mesh=null},E2.p.prototype.reset=function(){this.updated=!0},E2.p.prototype.update_output=function(a){return this.mesh},E2.p.prototype.state_changed=function(a){if(!a){var b=this.gl;this.mesh=new Mesh(b,b.TRIANGLE_STRIP);var c=this.mesh.vertex_buffers.VERTEX=new VertexBuffer(b,VertexBuffer.vertex_type.VERTEX);c.bind_data([1,1,0,-1,1,0,1,-1,0,-1,-1,0]);var d=this.mesh.vertex_buffers.NORMAL=new VertexBuffer(b,VertexBuffer.vertex_type.NORMAL);d.bind_data([0,0,1,0,0,1,0,0,1,0,0,1]);var e=this.mesh.vertex_buffers.UV0=new VertexBuffer(b,VertexBuffer.vertex_type.UV0);e.bind_data([1,1,0,1,1,0,0,0]);var f=this.mesh.index_buffer=new IndexBuffer(b);f.bind_data([3,1,0,3,2,0])}},E2.p=E2.plugins.orthographic_camera=function(a,b){this.desc="Create a orthographic camera, i.e a 3d-camera with no perspectivation (isometric).",this.input_slots=[{name:"left",dt:a.datatypes.FLOAT,desc:"Left plane x-coordinate.",def:-1},{name:"right",dt:a.datatypes.FLOAT,desc:"Right plane x-coordinate.",def:1},{name:"top",dt:a.datatypes.FLOAT,desc:"Top plane y-coordinate.",def:-1},{name:"bottom",dt:a.datatypes.FLOAT,desc:"Bottom plane y-coordinate.",def:1},{name:"near",dt:a.datatypes.FLOAT,desc:"Near plane z-coordinate.",def:1},{name:"far",dt:a.datatypes.FLOAT,desc:"Far plane x-coordinate.",def:1e3},{name:"transform",dt:a.datatypes.MATRIX,desc:"Camera transform.",def:"Identity"}],this.output_slots=[{name:"camera",dt:a.datatypes.CAMERA,desc:"The resulting camera."}],this.gl=a.renderer.context},E2.p.prototype.update_input=function(a,b){a.index<6?this.params[a.index]=b:this.view=b},E2.p.prototype.update_state=function(){this.update_camera()},E2.p.prototype.update_camera=function(){var a=this.params;this.camera=new Camera,mat4.ortho(a[0],a[1],a[2],a[3],a[4],a[5],this.camera.projection),this.camera.view=this.view},E2.p.prototype.update_output=function(a){return this.camera},E2.p.prototype.state_changed=function(a){a||(this.camera=new Camera,this.params=[-1,1,-1,1,1,1e3],this.view=mat4.create(),mat4.identity(this.view),this.update_camera())},E2.p=E2.plugins.light_type_modulator=function(a,b){this.desc="Sets the type of the light source to either point or directional.",this.input_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"Input light."},{name:"type",dt:a.datatypes.FLOAT,desc:"Set the light type. See also Generators/Values/Light type.",def:"False"}],this.output_slots=[{name:"light",dt:a.datatypes.LIGHT,desc:"The modified light."}]},E2.p.prototype.update_input=function(a,b){a.index===0?this.light=b:this.type=b<0?0:b%Light.type.COUNT},E2.p.prototype.connection_changed=function(a,b,c){!a&&c.type===E2.slot_type.input&&c.index===0&&(this.light=new Light)},E2.p.prototype.update_state=function(){this.light.type=this.type},E2.p.prototype.update_output=function(a){return this.light},E2.p.prototype.state_changed=function(a){a||(this.light=new Light,this.type=Light.type.POINT)},E2.p=E2.plugins.and_modulator=function(a,b){this.desc="Emit true if and only if both inputs are true and false otherwise.",this.input_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"The first operand.",def:"False"},{name:"bool",dt:a.datatypes.BOOL,desc:"The second operand.",def:"False"}],this.output_slots=[{name:"bool",dt:a.datatypes.BOOL,desc:"Emits true if <b>first</b> <i>and</i> <b>second</b> are true, and false otherwise.",def:"False"}]},E2.p.prototype.reset=function(){this.conds=[!1,!1],this.state=!1},E2.p.prototype.update_input=function(a,b){this.conds[a.index]=b},E2.p.prototype.update_state=function(){this.state=this.conds[0]&&this.conds[1]},E2.p.prototype.update_output=function(a){return this.state},E2.p=E2.plugins.random_float_generator=function(a,b){this.desc="Emits a random float constant in a specified range.",this.input_slots=[{name:"min",dt:a.datatypes.FLOAT,desc:"Minimum output value.",def:0},{name:"max",dt:a.datatypes.FLOAT,desc:"Maximum output value.",def:1}],this.output_slots=[{name:"value",dt:a.datatypes.FLOAT,desc:"Random output value between <b>min</b> and <b>max</b>."}],this.lo=0,this.hi=1,this.value=0},E2.p.prototype.update_input=function(a,b){a.index===0?this.lo=b:a.index===1&&(this.hi=b)},E2.p.prototype.update_state=function(){var a=this.lo,b=this.hi;if(a>b){var c=a;a=b,b=c}this.value=a+Math.random()*(b-a),this.updated=!0},E2.p.prototype.update_output=function(a){return this.value};