/*
 * Decompiled with CFR 0.152.
 */
package saito.objloader;

import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;
import saito.objloader.OBJModel;

public class BoundingBox
implements PConstants {
    PApplet parent;
    private PVector min = new PVector(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    private PVector max = new PVector(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    private PVector center = new PVector(0.0f, 0.0f, 0.0f);
    private PVector whd = new PVector(0.0f, 0.0f, 0.0f);

    public BoundingBox(PApplet parent, OBJModel model) {
        this.parent = parent;
        model.debug.println("OBJBoundingBox - \tGetting the Bounding Box");
        int numberOfVerts = model.getVertexCount();
        if (numberOfVerts == 0) {
            model.debug.println("OBJBoundingBox - \tThe model has no verts. Have you loaded it yet?");
        } else {
            int i = 0;
            while (i < numberOfVerts) {
                PVector v = model.getVertex(i);
                if (v.x < this.min.x) {
                    this.min.x = v.x;
                }
                if (v.x > this.max.x) {
                    this.max.x = v.x;
                }
                if (v.y < this.min.y) {
                    this.min.y = v.y;
                }
                if (v.y > this.max.y) {
                    this.max.y = v.y;
                }
                if (v.z < this.min.z) {
                    this.min.z = v.z;
                }
                if (v.z > this.max.z) {
                    this.max.z = v.z;
                }
                ++i;
            }
            this.whd.x = (float)Math.sqrt((this.max.x - this.min.x) * (this.max.x - this.min.x));
            this.whd.y = (float)Math.sqrt((this.max.y - this.min.y) * (this.max.y - this.min.y));
            this.whd.z = (float)Math.sqrt((this.max.z - this.min.z) * (this.max.z - this.min.z));
            this.center.add(this.min);
            this.center.add(this.max);
            this.center.div(2.0f);
        }
    }

    public void draw() {
        this.parent.rectMode(1);
        this.parent.pushMatrix();
        this.parent.translate(this.center.x, this.center.y, this.center.z);
        this.parent.box(this.whd.x, this.whd.y, this.whd.z);
        this.parent.popMatrix();
    }

    public PVector getMin() {
        return this.min;
    }

    public PVector getMax() {
        return this.max;
    }

    public PVector getCenter() {
        return this.center;
    }

    public PVector getWHD() {
        return this.whd;
    }
}

