/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

final class FFTutils {
    int WINDOW_SIZE;
    int WS2;
    int BIT_LEN;
    int[] _bitrevtable;
    float _normF;
    float[] _equalize;
    float[] _envelope;
    float[] _fft_result;
    float[][] _fftBuffer;
    float[] _cosLUT;
    float[] _sinLUT;
    float[] _FIRCoeffs;
    boolean _isEqualized;
    boolean _hasEnvelope;

    public FFTutils(int n) {
        this.WINDOW_SIZE = this.WS2 = n;
        this.WS2 >>= 1;
        this.BIT_LEN = (int)(Math.log(this.WINDOW_SIZE) / 0.693147180559945 + 0.5);
        this._normF = 2.0f / (float)this.WINDOW_SIZE;
        this._hasEnvelope = false;
        this._isEqualized = false;
        this.initFFTtables();
    }

    private static final float getFrame(float[] fArray, int n, int n2) {
        if (n > n2) {
            return 0.0f;
        }
        return fArray[n];
    }

    void initFFTtables() {
        int n;
        this._cosLUT = new float[this.BIT_LEN];
        this._sinLUT = new float[this.BIT_LEN];
        this._fftBuffer = new float[this.WINDOW_SIZE][2];
        this._fft_result = new float[this.WS2];
        float f = (float)Math.PI;
        for (n = 0; n < this.BIT_LEN; ++n) {
            this._cosLUT[n] = (float)Math.cos(f);
            this._sinLUT[n] = (float)Math.sin(f);
            f = (float)((double)f * 0.5);
        }
        this._bitrevtable = new int[this.WINDOW_SIZE];
        for (n = 0; n < this.WINDOW_SIZE; ++n) {
            this._bitrevtable[n] = n;
        }
        int n2 = 0;
        for (n = 0; n < this.WINDOW_SIZE; ++n) {
            int n3;
            if (n2 > n) {
                int n4 = this._bitrevtable[n];
                this._bitrevtable[n] = this._bitrevtable[n2];
                this._bitrevtable[n2] = n4;
            }
            for (n3 = this.WS2; n3 >= 1 && n2 >= n3; n2 -= n3, n3 >>= 1) {
            }
            n2 += n3;
        }
    }

    void useEqualizer(boolean bl) {
        this._isEqualized = bl;
        if (bl) {
            float f = -0.02f;
            float f2 = 1.0f / (float)this.WS2;
            this._equalize = new float[this.WS2];
            for (int i = 0; i < this.WS2; ++i) {
                this._equalize[i] = f * (float)Math.log((double)(this.WS2 - i) * (double)f2);
            }
        }
    }

    void useEnvelope(boolean bl, float f) {
        block4: {
            this._hasEnvelope = bl;
            if (!bl) break block4;
            float f2 = (float)((double)(1.0f / (float)this.WINDOW_SIZE) * (Math.PI * 2));
            this._envelope = new float[this.WINDOW_SIZE];
            if (f == 1.0f) {
                for (int i = 0; i < this.WINDOW_SIZE; ++i) {
                    this._envelope[i] = (float)(0.5 + 0.5 * Math.sin((double)((float)i * f2) - 1.5707963267948966));
                }
            } else {
                for (int i = 0; i < this.WINDOW_SIZE; ++i) {
                    this._envelope[i] = (float)Math.pow(0.5 + 0.5 * Math.sin((double)((float)i * f2) - 1.5707963267948966), f);
                }
            }
        }
    }

    float[] computeFFT(float[] fArray, int n, int n2) {
        int n3;
        int n4;
        if (this._hasEnvelope) {
            for (n4 = 0; n4 < this.WINDOW_SIZE; ++n4) {
                n3 = this._bitrevtable[n4];
                this._fftBuffer[n4][0] = n3 < this.WINDOW_SIZE ? FFTutils.getFrame(fArray, n3 + n, n2) * this._envelope[n3] : 0.0f;
                this._fftBuffer[n4][1] = 0.0f;
            }
        } else {
            for (n4 = 0; n4 < this.WINDOW_SIZE; ++n4) {
                n3 = this._bitrevtable[n4];
                this._fftBuffer[n4][0] = n3 < this.WINDOW_SIZE ? FFTutils.getFrame(fArray, n3 + n, n2) : 0.0f;
                this._fftBuffer[n4][1] = 0.0f;
            }
        }
        int n5 = 2;
        int n6 = 0;
        for (int i = 1; i <= this.BIT_LEN; ++i) {
            int n7 = n5 >> 1;
            float f = this._cosLUT[n6];
            float f2 = this._sinLUT[n6++];
            float f3 = 1.0f;
            float f4 = 0.0f;
            for (int j = 1; j <= n7; ++j) {
                float f5;
                for (n4 = j; n4 <= this.WINDOW_SIZE; n4 += n5) {
                    int n8 = n4 + n7;
                    int n9 = n8 - 1;
                    int n10 = n4 - 1;
                    float[] fArray2 = this._fftBuffer[n9];
                    f5 = fArray2[0] * f3 - f4 * fArray2[1];
                    float f6 = fArray2[1] * f3 + f4 * fArray2[0];
                    fArray2[0] = this._fftBuffer[n10][0] - f5;
                    fArray2[1] = this._fftBuffer[n10][1] - f6;
                    float[] fArray3 = this._fftBuffer[n10];
                    fArray3[0] = fArray3[0] + f5;
                    float[] fArray4 = this._fftBuffer[n10];
                    fArray4[1] = fArray4[1] + f6;
                }
                f5 = f3 * f - f2 * f4;
                f4 = f * f4 + f2 * f3;
                f3 = f5;
            }
            n5 <<= 1;
        }
        if (this._isEqualized) {
            for (n4 = 0; n4 < this.WS2; ++n4) {
                float[] fArray5 = this._fftBuffer[n4];
                this._fft_result[n4] = this._equalize[n4] * (float)Math.sqrt(fArray5[0] * fArray5[0] + fArray5[1] * fArray5[1]);
            }
        } else {
            for (n4 = 0; n4 < this.WS2; ++n4) {
                float[] fArray6 = this._fftBuffer[n4];
                this._fft_result[n4] = this._normF * (float)Math.sqrt(fArray6[0] * fArray6[0] + fArray6[1] * fArray6[1]);
            }
        }
        return this._fft_result;
    }
}

