/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import krister.Ess.AudioInput;
import krister.Ess.AudioOutput;
import krister.Ess.Ess;
import krister.Ess.FFTutils;

public final class FFT {
    private FFTutils theFFT;
    private int windowSize;
    private int windowSize2;
    private boolean useEqualizer;
    private boolean useEnvelope;
    private float envelopeCurve;
    private boolean isFirstSetup = true;
    public float[] baseSpectrum;
    public float[] zeroSpectrum;
    private float rDamp;
    private float rMinLimit;
    private float rMaxLimit;
    private boolean doDamp;
    private boolean doNormalize;
    private float rMax;
    private float maxDelta;
    private int maxCnt;
    private float[] smoothSpectrum;
    private float[] dampSpectrum;
    private int numAverages;
    private int averageSteps;
    public boolean smooth;
    public float updateMultiplier;
    public float max;
    public float[] spectrum;
    public float[] maxSpectrum;
    public float[] averages;
    public float[] maxAverages;

    public FFT() {
        this.setupFFT(512);
    }

    public FFT(int n) {
        this.setupFFT(n);
    }

    public void setupFFT(int n) {
        this.windowSize = n;
        this.windowSize2 = this.windowSize / 2;
        this.theFFT = new FFTutils(this.windowSize);
        this.zeroSpectrum = new float[this.windowSize2];
        if (this.isFirstSetup) {
            this.envelopeCurve = 1.2f;
            this.useEnvelope = false;
            this.useEqualizer = false;
        }
        this.setupFFTHelper();
        this.isFirstSetup = false;
    }

    public void equalizer(boolean bl) {
        this.useEqualizer = bl;
        if (this.theFFT != null) {
            this.theFFT.useEqualizer(bl);
        }
    }

    public void noEnvelope() {
        this.useEnvelope = false;
        if (this.theFFT != null) {
            this.theFFT.useEnvelope(false, 0.0f);
        }
    }

    public void envelope(float f) {
        this.envelopeCurve = f;
        if (this.theFFT != null) {
            this.theFFT.useEnvelope(true, this.envelopeCurve);
        }
    }

    public void getSpectrum(AudioOutput audioOutput) {
        if (audioOutput.getState() == 2) {
            int n = (int)((float)(Ess.parent.millis() - audioOutput.getBufferStartTime()) / (float)audioOutput.ms(audioOutput.buffer.length) * (float)audioOutput.buffer.length);
            this.baseSpectrum = this.theFFT.computeFFT(audioOutput.buffer2, n, audioOutput.buffer2.length);
        } else {
            System.arraycopy(this.zeroSpectrum, 0, this.theFFT._fft_result, 0, this.windowSize2);
            this.baseSpectrum = this.theFFT._fft_result;
        }
        this.FFTHelper();
    }

    public void getSpectrum(AudioInput audioInput) {
        if (audioInput.getState() == 3) {
            int n = (int)((float)(Ess.parent.millis() - audioInput.getBufferStartTime()) / (float)audioInput.ms(audioInput.buffer.length) * (float)audioInput.buffer.length);
            this.baseSpectrum = this.theFFT.computeFFT(audioInput.buffer2, n, audioInput.buffer2.length);
        } else {
            System.arraycopy(this.zeroSpectrum, 0, this.theFFT._fft_result, 0, this.windowSize2);
            this.baseSpectrum = this.theFFT._fft_result;
        }
        this.FFTHelper();
    }

    public void getSpectrum(float[] fArray, int n) {
        this.baseSpectrum = this.theFFT.computeFFT(fArray, n, fArray.length);
        this.FFTHelper();
    }

    public float getLevel(AudioOutput audioOutput) {
        if (audioOutput.getState() == 2) {
            int n = (int)((float)(Ess.parent.millis() - audioOutput.getBufferStartTime()) / (float)audioOutput.ms(audioOutput.buffer.length) * (float)audioOutput.buffer.length);
            return Math.abs(audioOutput.buffer[Math.min(audioOutput.buffer.length - 1, n)]);
        }
        return 0.0f;
    }

    public float getLevel(AudioInput audioInput) {
        if (audioInput.getState() == 3) {
            int n = (int)((float)(Ess.parent.millis() - audioInput.getBufferStartTime()) / (float)audioInput.ms(audioInput.buffer.length) * (float)audioInput.buffer.length);
            return Math.abs(audioInput.buffer[Math.min(audioInput.buffer.length - 1, n)]);
        }
        return 0.0f;
    }

    public float getLevel(float[] fArray, int n, int n2) {
        int n3 = Math.min(fArray.length, n2 + n) - n;
        float f = 0.0f;
        for (int i = n; i < n + n2; ++i) {
            if (!(Math.abs(fArray[i]) > f)) continue;
            f = Math.abs(fArray[i]);
        }
        return f;
    }

    public void noDamp() {
        this.doDamp = false;
    }

    public void damp(float f) {
        this.rDamp = f;
        this.doDamp = true;
    }

    public void noLimits() {
        this.doNormalize = false;
    }

    public void limits() {
        this.limits(0.005f, 0.05f);
    }

    public void limits(float f, float f2) {
        this.rMinLimit = f;
        this.rMaxLimit = f2;
        this.doNormalize = true;
    }

    public void averages(int n) {
        this.numAverages = Math.min(n, this.windowSize2);
        this.averages = new float[this.numAverages];
        this.maxAverages = new float[this.numAverages];
        this.averageSteps = this.windowSize2 / this.numAverages;
    }

    private void setupFFTHelper() {
        this.smoothSpectrum = new float[this.windowSize2];
        this.dampSpectrum = new float[this.windowSize2];
        this.spectrum = new float[this.windowSize2];
        this.maxSpectrum = new float[this.windowSize2];
        if (this.isFirstSetup) {
            this.limits();
            this.doNormalize = false;
            this.doDamp = false;
            this.smooth = false;
            this.rMax = this.rMinLimit;
            this.updateMultiplier = 0.995f;
        }
        this.averages(2);
    }

    private void FFTHelper() {
        int n;
        int n2;
        if (this.smooth) {
            this.smoothSpectrum[0] = (this.baseSpectrum[0] + this.baseSpectrum[1]) * 0.5f;
            this.smoothSpectrum[this.windowSize2 - 1] = (this.baseSpectrum[this.windowSize2 - 1] + this.baseSpectrum[this.windowSize2 - 2]) * 0.5f;
            for (n2 = 1; n2 < this.windowSize2 - 1; ++n2) {
                this.smoothSpectrum[n2] = (this.baseSpectrum[n2 - 1] + this.baseSpectrum[n2] + this.baseSpectrum[n2 + 1]) / 3.0f;
            }
        } else {
            System.arraycopy(this.baseSpectrum, 0, this.smoothSpectrum, 0, this.windowSize2);
        }
        if (this.doDamp) {
            for (n2 = 0; n2 < this.windowSize2; ++n2) {
                this.dampSpectrum[n2] = Math.min(this.rMaxLimit, this.smoothSpectrum[n2] * this.rDamp + this.dampSpectrum[n2] * (1.0f - this.rDamp));
            }
        } else {
            System.arraycopy(this.smoothSpectrum, 0, this.dampSpectrum, 0, this.windowSize2);
        }
        if (this.doNormalize) {
            float f = 0.0f;
            if (this.maxCnt > 0) {
                this.rMax += this.maxDelta;
                --this.maxCnt;
            }
            for (n = 0; n < this.windowSize2; ++n) {
                if (this.dampSpectrum[n] > this.rMax) {
                    this.rMax = this.dampSpectrum[n];
                    this.maxDelta = (this.dampSpectrum[n] - this.rMax) / 4.0f;
                    this.maxCnt = 4;
                    this.rMax += this.maxDelta;
                    --this.maxCnt;
                }
                if (!(this.dampSpectrum[n] > f)) continue;
                f = this.dampSpectrum[n];
            }
            if (f > this.rMaxLimit) {
                f = this.rMaxLimit;
            }
            if (this.rMax > this.rMinLimit && this.maxCnt == 0) {
                this.rMax = f * (1.0f - this.updateMultiplier) + this.rMax * this.updateMultiplier;
            }
            if (this.rMax > this.rMaxLimit) {
                this.rMax = this.rMaxLimit;
            }
            for (n = 0; n < this.windowSize2; ++n) {
                this.spectrum[n] = Math.min(1.0f, this.dampSpectrum[n] / this.rMax);
                if (this.maxSpectrum[n] < this.spectrum[n]) {
                    this.maxSpectrum[n] = this.spectrum[n];
                    continue;
                }
                int n3 = n;
                this.maxSpectrum[n3] = this.maxSpectrum[n3] * this.updateMultiplier;
            }
            this.max = this.rMax;
        } else {
            System.arraycopy(this.dampSpectrum, 0, this.spectrum, 0, this.windowSize2);
            for (n2 = 0; n2 < this.windowSize2; ++n2) {
                if (this.maxSpectrum[n2] < this.spectrum[n2]) {
                    this.maxSpectrum[n2] = this.spectrum[n2];
                    continue;
                }
                int n4 = n2;
                this.maxSpectrum[n4] = this.maxSpectrum[n4] * this.updateMultiplier;
            }
        }
        int n5 = 0;
        for (n = 0; n < this.numAverages; ++n) {
            this.averages[n] = 0.0f;
            for (int i = 0; i < this.averageSteps; ++i) {
                int n6 = n;
                this.averages[n6] = this.averages[n6] + this.spectrum[n5++];
            }
            int n7 = n;
            this.averages[n7] = this.averages[n7] / (float)this.averageSteps;
            if (this.maxAverages[n] < this.averages[n]) {
                this.maxAverages[n] = this.averages[n];
                continue;
            }
            int n8 = n;
            this.maxAverages[n8] = this.maxAverages[n8] * this.updateMultiplier;
        }
    }
}

