
Texture2D tex_image;
static float2 quad[4] = { 
	float2(-1,-1), float2(-1,1), float2(1,-1), float2(1,1)
};
static float2 uv[4] = { 
	float2(-1,-1), float2(-1,1), float2(1,-1), float2(1,1)
};

cbuffer InstanceData {
	float4 prms;
	float aspect;
	float t;
	float2 orig;
	float2 size;
	float a;
	float g;
}

struct VS_OUTPUT {
    float4 Position : SV_POSITION;
	float2 uv : TEXCOORD0;
};

SamplerState Trilinear {
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

BlendState transparent {
	AlphaToCoverageEnable = FALSE;
	BlendEnable[0] = TRUE;
	SrcBlend = SRC_ALPHA;
	DestBlend = INV_SRC_ALPHA;
};


VS_OUTPUT VS( uint id : SV_VertexID ) {
	VS_OUTPUT Out;
	Out.Position = float4( quad[id], 0, 1 );
	float2 keksi= float2(1,1) *0.5f;
	Out.uv = keksi + uv[id]*0.5f * (1.0f+g);
	return Out;
}

float4 PS( VS_OUTPUT In ) : SV_Target {
	return float4( tex_image.Sample( Trilinear, In.uv ).rgb, a * 1.0f );

}

technique10 Pattern {
    pass P0 {
		SetBlendState( transparent, float4(1,1,1,1), 0xffffffff );
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
    }
}


