rectTiming<-null;

function setTime(t)
{
    getSystem().setGlobalTime( t );
    sound.setTime(getSystem().getGlobalTime());
    sound.play();
    drawTimeLine();
    
}
pressed<-false;

function drawTimeLine()
{
    local posPixel=(0.0+getSystem().getGlobalTime())*( (getSystem().getWidth()+0.0)/lengthDemo);
    rectTiming.setPosition( posPixel  ,getSystem().getHeight()-80,1);
}




class ui
{
    scene = null;
    world = null;
    rectTimingBG=null;
    ih=null;
    dbg=null;


    function moved(event)
    {
        if(pressed)
        {
            setTime( ((event.x+0.0)/(getSystem().getWidth()+0.0) )*lengthDemo);
        }
        drawTimeLine();
    }

    function pressed(event)
    {
        pressed=true;
    }

    function released(event)
    {
        pressed=false;
    }


    constructor()
    {
        scene = Scene();
        scene.addToRoot();

        world=World();
        rectTimingBG = world.createRect("bla",getSystem().getWidth(),80);
        rectTimingBG.setPosition(getSystem().getWidth()/2,getSystem().getHeight()-80,0);
        rectTimingBG.isOrtho=true;
        rectTimingBG.getMaterial().setDiffuseColor(0,0,0);
        rectTimingBG.getMaterial().opacity=0.5;

        rectTiming = world.createRect("bla2",10,80);
        rectTiming.setPosition(0,getSystem().getHeight()-80,1);
        rectTiming.isOrtho=true;
        rectTiming.getMaterial().setDiffuseColor(1,1,1);
        rectTiming.getMaterial().opacity=0.5;


        scene.addChild(world);

        ih = InputHandler();
        ih.enabled=true;
        ih.setCallBackPointerPressed(pressed);
        ih.setCallBackPointerReleased(released);
        ih.setCallBackPointerMoved(moved);
        ih.setCallBackKeyCharPressed(keyPressed);

        dbg=DebugOverlay();
        scene.addChild(dbg);
    }

    function toggle()
    {
        scene.enabled=!scene.enabled;
    }

    function keyPressed(event)
    {
        if(event.key=="q")setTime( getSystem().getGlobalTime()-1.0 );
        if(event.key=="w")setTime( getSystem().getGlobalTime()+1.0 );
        if(event.key=="g")gui.toggle();

    }


}
